/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.LayoutUtil;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.StringDialogField;
import org.eclipse.jst.jsf.facesconfig.ui.EditorMessages;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class AddEditFacetDialog
extends Dialog {
    private StringDialogField facetNameField;
    private StringDialogField displayNameField;
    private StringDialogField descriptionField;
    private boolean isNew;
    private static final int MIN_DIALOG_WIDTH = 300;
    private String facetName;
    private String displayName;
    private String description;

    public AddEditFacetDialog(Shell parentShell, boolean isNew) {
        super(parentShell);
        this.isNew = isNew;
    }

    public AddEditFacetDialog(Shell parentShell, String facetName, String displayName, String description) {
        super(parentShell);
        this.facetName = facetName;
        this.displayName = displayName;
        this.description = description;
        this.isNew = false;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.isNew) {
            newShell.setText(EditorMessages.FacetSection_Dialog_Title_Add);
        } else {
            newShell.setText(EditorMessages.FacetSection_Dialog_Title_Edit);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 4);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        TabFolder tabFolder = new TabFolder(container, 4);
        tabFolder.setLayoutData((Object)gd);
        TabItem generalTabItem = new TabItem(tabFolder, 0);
        generalTabItem.setText(EditorMessages.FacetSection_Dialog_Tab_General);
        Control control = this.createGeneralTabControl((Composite)generalTabItem.getParent());
        generalTabItem.setControl(control);
        return container;
    }

    private Control createGeneralTabControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        composite.setFont(parent.getFont());
        this.facetNameField = new StringDialogField();
        this.facetNameField.setLabelText(EditorMessages.FacetSection_Dialog_FacetName);
        this.displayNameField = new StringDialogField();
        this.displayNameField.setLabelText(EditorMessages.FacetSection_Dialog_DisplayName);
        this.descriptionField = new StringDialogField();
        this.descriptionField.setLabelText(EditorMessages.FacetSection_Dialog_Description);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        int numberOfColumns = 4;
        GridLayout gl = new GridLayout(numberOfColumns, false);
        composite.setLayout((Layout)gl);
        this.facetNameField.doFillIntoGrid(null, composite, numberOfColumns);
        this.displayNameField.doFillIntoGrid(null, composite, numberOfColumns);
        this.descriptionField.doFillIntoGrid(null, composite, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.facetNameField.getTextControl(null, composite));
        this.facetNameField.setText(this.facetName);
        this.displayNameField.setText(this.displayName);
        this.descriptionField.setText(this.description);
        return composite;
    }

    protected Point getInitialSize() {
        Point shellSize = super.getInitialSize();
        return new Point(Math.max(this.convertHorizontalDLUsToPixels(300), shellSize.x), shellSize.y);
    }

    protected void okPressed() {
        this.facetName = this.facetNameField.getText();
        this.displayName = this.displayNameField.getText();
        this.description = this.descriptionField.getText();
        super.okPressed();
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getFacetName() {
        return this.facetName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setFacetName(String facetName) {
        this.facetName = facetName;
    }
}

