/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.ILocationVisitor;
import org.eclipse.wtp.releng.tools.component.api.ComponentAPI;
import org.eclipse.wtp.releng.tools.component.api.PackageAPI;
import org.eclipse.wtp.releng.tools.component.internal.FileLocation;
import org.eclipse.wtp.releng.tools.component.internal.Location;

public class ComponentAPICache {
    private int size;
    private String compAPIDir;
    private List cachedIds;
    private List cachedCompAPIs;
    private Map pkg2Id;

    public ComponentAPICache(String compAPIDir) {
        this(20, compAPIDir);
    }

    public ComponentAPICache(int size, String compAPIDir) {
        this.cachedIds = new ArrayList(this.size);
        this.cachedCompAPIs = new ArrayList(this.size);
        this.size = size;
        this.compAPIDir = this.addTrailingSeperator(compAPIDir);
    }

    private String addTrailingSeperator(String s) {
        if (s != null && !s.endsWith("/") && !s.endsWith("\\")) {
            StringBuffer sb = new StringBuffer(s);
            sb.append('/');
            return sb.toString();
        }
        return s;
    }

    public ComponentAPI getComponentAPI(String id) throws IOException {
        int index = this.cachedIds.indexOf(id);
        if (index != -1) {
            ComponentAPI compAPI = (ComponentAPI)this.cachedCompAPIs.get(index);
            if (index != 0) {
                this.cachedIds.remove(index);
                this.cachedCompAPIs.remove(index);
                this.cachedIds.add(0, id);
                this.cachedCompAPIs.add(0, compAPI);
            }
            return compAPI;
        }
        StringBuffer sb = new StringBuffer(this.compAPIDir);
        sb.append(id);
        sb.append("/api-info.xml");
        File file = new File(sb.toString());
        ComponentAPI compAPI = new ComponentAPI();
        compAPI.setName(id);
        compAPI.setLocation(new FileLocation(file));
        if (file.exists()) {
            compAPI.load();
        }
        if (this.cachedCompAPIs.size() == this.size) {
            this.cachedIds.remove(this.size - 1);
            ((ComponentAPI)this.cachedCompAPIs.remove(this.size - 1)).save();
        }
        this.cachedIds.add(0, id);
        this.cachedCompAPIs.add(0, compAPI);
        return compAPI;
    }

    public ComponentAPI getComponentAPIByClassName(String className) {
        List ids;
        int index;
        if (this.pkg2Id == null) {
            this.pkg2Id = new HashMap();
            ILocation dir = Location.createLocation(new File(this.compAPIDir));
            LocationVisitor visitor = new LocationVisitor();
            dir.accept(visitor);
        }
        String pkgName = (index = className.lastIndexOf(46)) != -1 ? className.substring(0, index) : "";
        String localName = index != -1 ? className.substring(index + 1) : className;
        int innerClassIndex = localName.indexOf("$");
        if (innerClassIndex != -1) {
            localName = localName.substring(0, innerClassIndex);
        }
        if (localName.endsWith("[]")) {
            localName = localName.substring(0, localName.length() - 2);
        }
        if ((ids = (List)this.pkg2Id.get(pkgName)) != null) {
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                try {
                    ComponentAPI compAPI = this.getComponentAPI((String)it.next());
                    PackageAPI pkgAPI = compAPI.getPackageAPI(pkgName);
                    if (pkgAPI.getClassAPI(localName) == null) continue;
                    return compAPI;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        return null;
    }

    private class LocationVisitor
    implements ILocationVisitor {
        private LocationVisitor() {
        }

        public boolean accept(ILocation location) {
            String id;
            int i;
            String absPath = location.getAbsolutePath().replace('\\', '/');
            if (absPath.endsWith("api-info.xml") && (i = (id = absPath.substring(0, absPath.length() - "/api-info.xml".length())).lastIndexOf(47)) != -1) {
                id = id.substring(i + 1);
                try {
                    ComponentAPI compAPI = new ComponentAPI();
                    compAPI.setLocation(location);
                    compAPI.load();
                    Iterator it = compAPI.getPackageAPIs().iterator();
                    while (it.hasNext()) {
                        String pkgName = ((PackageAPI)it.next()).getName();
                        ArrayList<String> ids = (ArrayList<String>)ComponentAPICache.this.pkg2Id.get(pkgName);
                        if (ids == null) {
                            ids = new ArrayList<String>();
                            ComponentAPICache.this.pkg2Id.put(pkgName, ids);
                        }
                        ids.add(id);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            return true;
        }
    }
}

