/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.results;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.test.internal.performance.results.AbstractResults;
import org.eclipse.test.internal.performance.results.BuildResults;
import org.eclipse.test.internal.performance.results.DB_Results;
import org.eclipse.test.internal.performance.results.PerformanceResults;
import org.eclipse.test.internal.performance.results.ScenarioResults;

public class ConfigResults
extends AbstractResults {
    BuildResults baseline;
    BuildResults current;
    boolean baselined = false;
    boolean valid = false;

    public ConfigResults(AbstractResults parent, int id) {
        super(parent, id);
        this.name = parent.getPerformance().sortedConfigNames[id];
        this.print = parent.print;
    }

    public String getBaselineBuildName() {
        return this.baseline.getName();
    }

    public BuildResults getBaselineBuildResults() {
        return this.baseline;
    }

    public List getBuilds(String buildPattern) {
        ArrayList<BuildResults> builds = new ArrayList<BuildResults>();
        int size = this.size();
        int i = 0;
        while (i < size) {
            BuildResults buildResults = (BuildResults)this.children.get(i);
            if (buildResults.match(buildPattern)) {
                builds.add(buildResults);
            }
            ++i;
        }
        return builds;
    }

    public List getBuildsMatchingPrefixes(List prefixes) {
        ArrayList<AbstractResults> builds = new ArrayList<AbstractResults>();
        int size = this.size();
        int length = prefixes.size();
        int i = 0;
        while (i < size) {
            AbstractResults buildResults = (AbstractResults)this.children.get(i);
            String buildName = buildResults.getName();
            int j = 0;
            while (j < length) {
                if (buildName.startsWith((String)prefixes.get(j))) {
                    builds.add(buildResults);
                }
                ++j;
            }
            ++i;
        }
        return builds;
    }

    public double[] getCurrentBuildDeviation() {
        int dim_id = SUPPORTED_DIMS[0].getId();
        double baselineValue = this.baseline.getValue(dim_id);
        double currentValue = this.current.getValue(dim_id);
        double deviation = (currentValue - baselineValue) / baselineValue;
        if (Double.isNaN(deviation)) {
            return new double[]{Double.NaN, Double.NaN};
        }
        long baselineCount = this.baseline.getCount(dim_id);
        long currentCount = this.current.getCount(dim_id);
        if (baselineCount == 1L || currentCount == 1L) {
            return new double[]{deviation, Double.NaN};
        }
        double baselineError = this.baseline.getError(dim_id);
        double currentError = this.current.getError(dim_id);
        double stderr = Double.isNaN(baselineError) ? currentError / baselineValue : Math.sqrt(baselineError * baselineError + currentError * currentError) / baselineValue;
        return new double[]{deviation, stderr};
    }

    public String getCurrentBuildName() {
        return this.current.getName();
    }

    public BuildResults getCurrentBuildResults() {
        return this.current;
    }

    public double[] getStatistics(List prefixes, int dim_id) {
        int size = this.size();
        int length = prefixes == null ? 0 : prefixes.size();
        int count = 0;
        double mean = 0.0;
        double stddev = 0.0;
        double variation = 0.0;
        double[] values = new double[size];
        count = 0;
        mean = 0.0;
        int i = 0;
        while (i < size) {
            BuildResults buildResults = (BuildResults)this.children.get(i);
            String buildName = buildResults.getName();
            if (this.isBuildConcerned(buildResults)) {
                if (prefixes == null) {
                    double value;
                    values[count] = value = buildResults.getValue(dim_id);
                    mean += value;
                    ++count;
                } else {
                    int j = 0;
                    while (j < length) {
                        if (buildName.startsWith((String)prefixes.get(j))) {
                            double value;
                            values[count] = value = buildResults.getValue(dim_id);
                            mean += value;
                            ++count;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        mean /= (double)count;
        i = 0;
        while (i < count) {
            stddev += Math.pow(values[i] - mean, 2.0);
            ++i;
        }
        stddev = Math.sqrt(stddev / (double)(count - 1));
        variation = Math.round(stddev / mean * 100.0 * 100.0) / 100L;
        return new double[]{count, mean, stddev, variation};
    }

    public boolean isBaselined() {
        return this.baselined;
    }

    boolean isBuildConcerned(BuildResults buildResults) {
        String baselineBuildDate;
        String buildDate = buildResults.getDate();
        String currentBuildDate = this.getCurrentBuildResults() == null ? null : this.getCurrentBuildResults().getDate();
        String string = baselineBuildDate = this.getBaselineBuildResults() == null ? null : this.getBaselineBuildResults().getDate();
        return !(currentBuildDate != null && buildDate.compareTo(currentBuildDate) > 0 || baselineBuildDate != null && buildDate.compareTo(baselineBuildDate) > 0);
    }

    public boolean isValid() {
        return this.valid;
    }

    public List lastNightlyBuildNames(int n) {
        ArrayList<String> labels = new ArrayList<String>();
        int i = this.size() - 2;
        while (i >= 0) {
            String buildName;
            BuildResults buildResults = (BuildResults)this.children.get(i);
            if (this.isBuildConcerned(buildResults) && (buildName = buildResults.getName()).startsWith("N")) {
                labels.add(buildName);
                if (labels.size() >= n) break;
            }
            --i;
        }
        return labels;
    }

    void readData(DataInputStream stream) throws IOException {
        int size = stream.readInt();
        int i = 0;
        while (i < size) {
            BuildResults buildResults = new BuildResults(this);
            buildResults.readData(stream);
            this.addChild(buildResults, true);
            ++i;
        }
    }

    void setValue(int build_id, int dim_id, int step, long value) {
        BuildResults buildResults = (BuildResults)this.getResults(build_id);
        if (buildResults == null) {
            buildResults = new BuildResults((AbstractResults)this, build_id);
            this.addChild(buildResults, true);
        }
        buildResults.setValue(dim_id, step, value);
    }

    void update() {
        PerformanceResults perfResults = this.getPerformance();
        String baselineBuildName = perfResults.getBaselineName();
        String currentBuildName = perfResults.getName();
        int size = this.size();
        int i = 0;
        while (i < size) {
            BuildResults buildResults = (BuildResults)this.children.get(i);
            if (buildResults.values != null) {
                buildResults.cleanValues();
            }
            if (buildResults.getName().equals(baselineBuildName)) {
                this.baseline = buildResults;
                this.baselined = true;
            } else if (buildResults.getName().equals(currentBuildName)) {
                this.current = buildResults;
                this.valid = true;
            }
            ++i;
        }
        if (this.baseline == null) {
            this.baseline = (BuildResults)this.children.get(0);
        }
        if (this.current == null) {
            this.current = (BuildResults)this.children.get(this.size() - 1);
        }
        ScenarioResults scenarioResults = (ScenarioResults)this.parent;
        DB_Results.queryScenarioFailures(scenarioResults, this.name, this.current, this.baseline);
        DB_Results.queryScenarioSummaries(scenarioResults, this.name, this.current, this.baseline);
    }

    void write(DataOutputStream stream) throws IOException {
        int size = this.size();
        stream.writeInt(this.id);
        stream.writeInt(size);
        int i = 0;
        while (i < size) {
            BuildResults buildResults = (BuildResults)this.children.get(i);
            buildResults.write(stream);
            ++i;
        }
    }
}

