/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.ui.internal.adopter.preference;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wtp.releng.tools.component.adopters.References;
import org.eclipse.wtp.releng.tools.component.ui.Message;
import org.eclipse.wtp.releng.tools.component.ui.internal.ComponentUIPlugin;
import org.eclipse.wtp.releng.tools.component.ui.internal.adopter.preference.ContainerSelectionDialog;

public class UsageReportsPrefPage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener {
    private org.eclipse.swt.widgets.List reports;
    private Button add;
    private Button remove;
    private Text output;
    private Button browse;
    private static List refs = null;

    protected Control createContents(Composite superparent) {
        Composite parent = new Composite(superparent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(768));
        Label label = new Label(parent, 72);
        label.setText(Message.getMessage("LABEL_ADOPTER_USAGE_REPORTS"));
        label.setLayoutData((Object)new GridData(768));
        Composite c = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        c.setLayout((Layout)gl);
        c.setLayoutData((Object)new GridData(768));
        this.reports = new org.eclipse.swt.widgets.List(c, 68354);
        GridData gd = new GridData(1808);
        gd.widthHint = 256;
        this.reports.setLayoutData((Object)gd);
        Composite c2 = new Composite(c, 0);
        gl = new GridLayout();
        gl.numColumns = 1;
        gl.marginHeight = 10;
        gl.marginWidth = 0;
        c2.setLayout((Layout)gl);
        this.add = new Button(c2, 8);
        this.add.setText(Message.getMessage("LABEL_ADD"));
        this.add.setLayoutData((Object)new GridData(256));
        this.add.addSelectionListener((SelectionListener)this);
        this.remove = new Button(c2, 8);
        this.remove.setText(Message.getMessage("LABEL_REMOVE"));
        this.remove.setLayoutData((Object)new GridData(256));
        this.remove.addSelectionListener((SelectionListener)this);
        label = new Label(c, 72);
        label.setText("");
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label = new Label(c, 72);
        label.setText(Message.getMessage("LABEL_BREAKAGE_REPORT_OUTPUT_DIR"));
        label.setLayoutData((Object)gd);
        this.output = new Text(c, 2120);
        this.output.setLayoutData((Object)new GridData(768));
        this.browse = new Button(c, 8);
        this.browse.setText(Message.getMessage("LABEL_BROWSE"));
        this.browse.setLayoutData((Object)new GridData(256));
        this.browse.addSelectionListener((SelectionListener)this);
        this.initValues();
        return parent;
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        return true;
    }

    protected void performApply() {
        this.performOk();
    }

    private void initValues() {
        IPreferenceStore pref = ComponentUIPlugin.getDefault().getPreferenceStore();
        String value = pref.getString("UsageReportPrefPage");
        StringTokenizer st = new StringTokenizer(value, "#");
        ArrayList<String> containers = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            this.reports.add(token);
            containers.add(token);
        }
        UsageReportsPrefPage.reloadRefs(containers);
        String outputValue = pref.getString("UsageReportPrefPage.output");
        this.output.setText(outputValue);
    }

    private void storeValues() {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> containers = new ArrayList<String>();
        String[] s = this.reports.getItems();
        int i = 0;
        while (i < s.length) {
            sb.append(s[i]);
            sb.append("#");
            containers.add(s[i]);
            ++i;
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        IPreferenceStore pref = ComponentUIPlugin.getDefault().getPreferenceStore();
        pref.setValue("UsageReportPrefPage", sb.toString());
        UsageReportsPrefPage.reloadRefs(containers);
        pref.setValue("UsageReportPrefPage.output", this.output.getText());
    }

    public void init(IWorkbench desktop) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        IContainer[] container;
        ContainerSelectionDialog dialog;
        if (e.widget == this.add) {
            IContainer[] containers;
            String[] excludes = this.reports.getItems();
            ArrayList<String> list = new ArrayList<String>(excludes.length);
            int i = 0;
            while (i < excludes.length) {
                list.add(excludes[i]);
                ++i;
            }
            ContainerSelectionDialog dialog2 = new ContainerSelectionDialog(this.getShell(), true, list);
            if (dialog2.open() == 0 && (containers = dialog2.getSelections()) != null) {
                int i2 = 0;
                while (i2 < containers.length) {
                    this.reports.add(containers[i2].getFullPath().toString());
                    ++i2;
                }
            }
        } else if (e.widget == this.remove) {
            this.reports.remove(this.reports.getSelectionIndices());
        } else if (e.widget == this.browse && (dialog = new ContainerSelectionDialog(this.getShell(), false, null)).open() == 0 && (container = dialog.getSelections()) != null && container.length > 0) {
            this.output.setText(container[0].getFullPath().toString());
        }
    }

    public static List getReferences() {
        if (refs == null) {
            IPreferenceStore pref = ComponentUIPlugin.getDefault().getPreferenceStore();
            String value = pref.getString("UsageReportPrefPage");
            StringTokenizer st = new StringTokenizer(value, "#");
            ArrayList<String> containers = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                containers.add(st.nextToken());
            }
            UsageReportsPrefPage.reloadRefs(containers);
        }
        return refs;
    }

    public static IContainer getOutput() {
        IPreferenceStore pref = ComponentUIPlugin.getDefault().getPreferenceStore();
        String outputValue = pref.getString("UsageReportPrefPage.output");
        if (outputValue != null) {
            return (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember(outputValue);
        }
        return null;
    }

    private static void reloadRefs(List containers) {
        refs = new ArrayList();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Iterator it = containers.iterator();
        while (it.hasNext()) {
            IContainer container = (IContainer)root.findMember((String)it.next());
            if (container == null) continue;
            try {
                container.accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) throws CoreException {
                        if (proxy.getName().endsWith(".xml")) {
                            References ref = new References();
                            try {
                                ref.load(((IFile)proxy.requestResource()).getContents());
                                refs.add(ref);
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                        return true;
                    }
                }, 0);
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
        }
    }
}

