/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.console;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.eclipse.debug.core.model.IStreamsProxy2;
import org.eclipse.lsp4e.debug.console.DSPStreamMonitor;
import org.eclipse.lsp4j.debug.EvaluateArguments;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;

public class DSPStreamsProxy
implements IStreamsProxy2 {
    private IDebugProtocolServer debugProtocolServer;
    private DSPStreamMonitor outputStream;
    private DSPStreamMonitor errorStream;

    public DSPStreamsProxy(IDebugProtocolServer debugProtocolServer) {
        this.debugProtocolServer = debugProtocolServer;
        this.errorStream = new DSPStreamMonitor();
        this.outputStream = new DSPStreamMonitor();
    }

    public DSPStreamMonitor getErrorStreamMonitor() {
        return this.errorStream;
    }

    public DSPStreamMonitor getOutputStreamMonitor() {
        return this.outputStream;
    }

    public void write(String input) throws IOException {
        String trimmed = input.trim();
        if (!trimmed.isEmpty()) {
            EvaluateArguments args = new EvaluateArguments();
            args.setContext("repl");
            args.setExpression(trimmed);
            CompletableFuture future = this.debugProtocolServer.evaluate(args);
            ((CompletableFuture)future.thenAcceptAsync(response -> {
                if (response != null && response.getResult() != null) {
                    String result = String.valueOf(response.getResult()) + System.lineSeparator();
                    this.outputStream.append(result);
                }
            })).exceptionally(t -> {
                if (t.getCause() instanceof ResponseErrorException) {
                    ResponseErrorException exception = (ResponseErrorException)t.getCause();
                    ResponseError error = exception.getResponseError();
                    this.errorStream.append(String.valueOf(error.getMessage()) + System.lineSeparator());
                } else {
                    this.errorStream.append(String.valueOf(t.getLocalizedMessage()) + System.lineSeparator());
                }
                return null;
            });
        }
    }

    public void closeInputStream() throws IOException {
    }
}

