/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.xml.internal.ui.preferences;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wildwebdeveloper.xml.internal.Activator;
import org.eclipse.wildwebdeveloper.xml.internal.ui.preferences.XMLPreferenceConstants;
import org.osgi.framework.Bundle;

public class XMLCatalogs {
    private static final Comparator<File> FILE_CASE_INSENSITIVE_ORDER = Comparator.comparing(File::getAbsolutePath, String.CASE_INSENSITIVE_ORDER);
    private static final File SYSTEM_CATALOG = Activator.getDefault().getStateLocation().append("system-catalog.xml").toFile();

    public static Set<File> getUserCatalogs(IPreferenceStore store) {
        TreeSet<File> catalogs = new TreeSet<File>(FILE_CASE_INSENSITIVE_ORDER);
        String[] stringArray = store.getString(XMLPreferenceConstants.XML_PREFERENCES_CATAGLOGS.preferenceId).split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String filepath = stringArray[n2];
            if (!filepath.isEmpty()) {
                catalogs.add(new File(filepath));
            }
            ++n2;
        }
        return catalogs;
    }

    public static Set<File> getAllCatalogs(IPreferenceStore store) {
        Set<File> res = XMLCatalogs.getUserCatalogs(store);
        res.add(XMLCatalogs.getWTPExtensionCatalog());
        return res;
    }

    private static File getWTPExtensionCatalog() {
        StringBuilder catalogFile = new StringBuilder();
        catalogFile.append("<?xml version=\"1.0\"?>\n<!DOCTYPE catalog PUBLIC \"-//OASIS//DTD Entity Resolution XML Catalog V1.0//EN\" \"http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd\">\n<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\" prefer=\"public\">\n");
        Arrays.stream(Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.wst.xml.core.catalogContributions")).filter(element -> "catalogContribution".equals(element.getName())).flatMap(element -> Arrays.stream(element.getChildren("system"))).forEach(element -> {
            String namespace = element.getAttribute("systemId");
            URI uri = URI.create(element.getAttribute("uri"));
            if (!uri.isAbsolute()) {
                try {
                    uri = FileLocator.find((Bundle)Platform.getBundle((String)element.getContributor().getName()), (IPath)Path.fromPortableString((String)uri.toString())).toURI();
                }
                catch (URISyntaxException | InvalidRegistryObjectException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wildwebdeveloper.xml", e.getMessage(), e));
                }
            }
            if (!"file".equals(uri.getScheme())) {
                try {
                    uri = FileLocator.toFileURL((URL)uri.toURL()).toURI();
                }
                catch (IOException | URISyntaxException | InvalidRegistryObjectException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wildwebdeveloper.xml", e.getMessage(), e));
                }
            }
            if (namespace != null && uri != null) {
                catalogFile.append("<system systemId=\"").append(namespace).append("\" uri=\"").append(uri).append("\"/>\n");
            }
        });
        catalogFile.append("</catalog>");
        try {
            Files.writeString(SYSTEM_CATALOG.toPath(), (CharSequence)catalogFile.toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wildwebdeveloper.xml", e.getMessage(), (Throwable)e));
        }
        return SYSTEM_CATALOG;
    }

    public static void storeUserCatalogs(IPreferenceStore store, Set<File> catalogs) {
        StringBuilder catalogsStr = new StringBuilder();
        if (!catalogs.isEmpty()) {
            for (File f : catalogs) {
                catalogsStr.append(f.getAbsolutePath()).append(',');
            }
        }
        store.setValue(XMLPreferenceConstants.XML_PREFERENCES_CATAGLOGS.preferenceId, catalogsStr.toString());
    }
}

