/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.util;

import com.google.common.base.Preconditions;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.parser.outline.OutlineParser;
import org.eclipse.mylyn.wikitext.util.DefaultXmlStreamWriter;
import org.eclipse.mylyn.wikitext.util.FormattingXMLStreamWriter;
import org.eclipse.mylyn.wikitext.util.XmlStreamWriter;

public class MarkupToEclipseToc {
    private String bookTitle;
    private String htmlFile;
    private MarkupLanguage markupLanguage;
    private String helpPrefix;
    private String copyrightNotice;
    private int anchorLevel = -1;

    public String parse(String markupContent) {
        if (this.markupLanguage == null) {
            throw new IllegalStateException("Must set markupLanguage");
        }
        OutlineParser parser = new OutlineParser(this.markupLanguage);
        OutlineItem root = parser.parse(markupContent);
        return this.createToc(root);
    }

    public String createToc(OutlineItem root) {
        StringWriter out = new StringWriter(8096);
        XmlStreamWriter writer = this.createXmlStreamWriter(out);
        writer.writeStartDocument("utf-8", "1.0");
        if (this.copyrightNotice != null) {
            writer.writeComment(this.copyrightNotice);
        }
        writer.writeStartElement("toc");
        writer.writeAttribute("topic", this.adjustForPrefix(this.getHtmlFile()));
        writer.writeAttribute("label", this.getBookTitle());
        this.emitToc(writer, root.getChildren());
        if (this.anchorLevel >= 0) {
            writer.writeEmptyElement("anchor");
            writer.writeAttribute("id", "additions");
        }
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.close();
        return out.toString();
    }

    private void emitToc(XmlStreamWriter writer, List<OutlineItem> children) {
        for (OutlineItem item : children) {
            boolean hasPrevious;
            writer.writeStartElement("topic");
            String file = this.computeFile(item);
            file = this.adjustForPrefix(file);
            String suffix = "";
            OutlineItem previous = item.getPrevious();
            boolean bl = hasPrevious = previous != null && previous.getParent() != null;
            if (hasPrevious) {
                String fileOfPrevious = this.computeFile(previous);
                if (file.equals(fileOfPrevious = this.adjustForPrefix(fileOfPrevious))) {
                    suffix = "#" + item.getId();
                }
            }
            writer.writeAttribute("href", file + suffix);
            writer.writeAttribute("label", item.getLabel());
            if (!item.getChildren().isEmpty()) {
                this.emitToc(writer, item.getChildren());
            }
            if (item.getLevel() <= this.anchorLevel) {
                writer.writeEmptyElement("anchor");
                writer.writeAttribute("id", item.getId() + "-additions");
            }
            writer.writeEndElement();
        }
    }

    private String adjustForPrefix(String file) {
        if (this.helpPrefix != null) {
            file = this.helpPrefix.endsWith("/") ? this.helpPrefix + file : this.helpPrefix + '/' + file;
        }
        return file;
    }

    protected String computeFile(OutlineItem item) {
        return this.getHtmlFile();
    }

    public MarkupLanguage getMarkupLanguage() {
        return this.markupLanguage;
    }

    public void setMarkupLanguage(MarkupLanguage markupLanguage) {
        this.markupLanguage = markupLanguage;
    }

    public String getBookTitle() {
        return this.bookTitle;
    }

    public void setBookTitle(String bookTitle) {
        this.bookTitle = bookTitle;
    }

    public String getHtmlFile() {
        return this.htmlFile;
    }

    public void setHtmlFile(String htmlFile) {
        this.htmlFile = htmlFile;
    }

    public int getAnchorLevel() {
        return this.anchorLevel;
    }

    public void setAnchorLevel(int anchorLevel) {
        Preconditions.checkArgument((anchorLevel >= 0 && anchorLevel <= 6 ? 1 : 0) != 0, (Object)"The anchor level must be >= 0 and <= 6");
        this.anchorLevel = anchorLevel;
    }

    protected XmlStreamWriter createXmlStreamWriter(Writer out) {
        DefaultXmlStreamWriter writer = new DefaultXmlStreamWriter(out);
        return new FormattingXMLStreamWriter(writer);
    }

    public void setHelpPrefix(String helpPrefix) {
        this.helpPrefix = helpPrefix;
    }

    public String getCopyrightNotice() {
        return this.copyrightNotice;
    }

    public void setCopyrightNotice(String copyrightNotice) {
        this.copyrightNotice = copyrightNotice;
    }
}

