/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.shells.core.subsystems;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IProperty;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.PropertyList;
import org.eclipse.rse.core.subsystems.CommunicationsEvent;
import org.eclipse.rse.core.subsystems.ICommunicationsListener;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IRemoteSystemEnvVar;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.internal.subsystems.shells.core.ShellStrings;
import org.eclipse.rse.internal.subsystems.shells.subsystems.RemoteSystemEnvVar;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.shells.core.model.RemoteOutput;
import org.eclipse.rse.subsystems.shells.core.subsystems.ICandidateCommand;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystemConfiguration;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class RemoteCmdSubSystem
extends SubSystem
implements IRemoteCmdSubSystem,
ICommunicationsListener {
    private static String COMMAND_SHELLS_MEMENTO = "commandshells";
    private static String ENVIRONMENT_VARS = "EnvironmentVariables";
    protected ArrayList _cmdShells = new ArrayList();
    protected IRemoteCommandShell _defaultShell;
    protected IRemoteFileSubSystem _fileSubSystem;
    private boolean _hasRestoredState = false;

    public RemoteCmdSubSystem(IHost host, IConnectorService connectorService) {
        super(host, connectorService);
    }

    public void initializeSubSystem(IProgressMonitor monitor) throws SystemMessageException {
        super.initializeSubSystem(monitor);
        this._hasRestoredState = false;
        Platform.getAdapterManager().loadAdapter((Object)new RemoteOutput(null, ""), "org.eclipse.rse.ui.view.ISystemViewElementAdapter");
    }

    public IRemoteCmdSubSystemConfiguration getParentRemoteCmdSubSystemConfiguration() {
        return (IRemoteCmdSubSystemConfiguration)super.getSubSystemConfiguration();
    }

    public boolean checkForCancel(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            String msgTxt = NLS.bind((String)ShellStrings.MSG_CONNECT_FAILED, (Object)this.getHostName());
            throw new OperationCanceledException(msgTxt);
        }
        return false;
    }

    public IRemoteSystemEnvVar[] getEnvironmentVariableList() {
        IPropertySet environmentVariables = this.getEnvironmentVariables();
        String[] names = environmentVariables.getPropertyKeys();
        IRemoteSystemEnvVar[] result = new IRemoteSystemEnvVar[names.length];
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            String value = environmentVariables.getPropertyValue(name);
            RemoteSystemEnvVar v = new RemoteSystemEnvVar();
            v.setName(name);
            v.setValue(value);
            result[i] = v;
            ++i;
        }
        return result;
    }

    private boolean areVariablesTheSame(String[] names, String[] values) {
        IPropertySet environmentVariables = this.getPropertySet(ENVIRONMENT_VARS);
        if (environmentVariables == null || names == null) {
            return false;
        }
        String[] originalNames = environmentVariables.getPropertyKeys();
        if (originalNames.length != names.length) {
            return false;
        }
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            String originalName = originalNames[i];
            if (!name.equals(originalName)) {
                return false;
            }
            String value = values[i];
            String originalValue = environmentVariables.getPropertyValue(name);
            if (!value.equals(originalValue)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setEnvironmentVariableList(String[] names, String[] values) {
        if (this.areVariablesTheSame(names, values)) {
            return;
        }
        this.removePropertySet(ENVIRONMENT_VARS);
        IPropertySet environmentVariables = this.getEnvironmentVariables();
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                environmentVariables.addProperty(names[i], values[i]);
                ++i;
            }
        }
        try {
            if (this.getSubSystemConfiguration() != null) {
                this.getSubSystemConfiguration().saveSubSystem((ISubSystem)this);
            }
        }
        catch (Exception exc) {
            RSECorePlugin.getDefault().getLogger().logError("Error saving command subsystem after setting env var entries", (Throwable)exc);
        }
    }

    public void addEnvironmentVariable(String name, String value) {
        IPropertySet environmentVariables = this.getEnvironmentVariables();
        environmentVariables.addProperty(name, value);
        this.commit();
    }

    public void addEnvironmentVariable(IRemoteSystemEnvVar rsev) {
        this.addEnvironmentVariable(rsev.getName(), rsev.getValue());
    }

    public void removeEnvironmentVariable(IRemoteSystemEnvVar rsev) {
        this.removeEnvironmentVariable(rsev.getName());
    }

    public void removeEnvironmentVariable(String name) {
        IPropertySet environmentVariables = this.getEnvironmentVariables();
        environmentVariables.removeProperty(name);
        this.commit();
    }

    public IRemoteSystemEnvVar getEnvironmentVariable(String name) {
        RemoteSystemEnvVar result = null;
        String value = this.getEnvironmentVariableValue(name);
        if (value != null) {
            result = new RemoteSystemEnvVar();
            result.setName(name);
            result.setValue(value);
        }
        return result;
    }

    public String getEnvironmentVariableValue(String name) {
        IPropertySet environmentVariables = this.getEnvironmentVariables();
        String value = environmentVariables.getPropertyValue(name);
        return value;
    }

    protected String[] getEnvVarsAsStringArray() {
        IPropertySet environmentVariables = this.getEnvironmentVariables();
        String[] names = environmentVariables.getPropertyKeys();
        String[] result = new String[names.length];
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            String value = environmentVariables.getPropertyValue(name);
            result[i] = String.valueOf(name) + "=" + value;
            ++i;
        }
        return result;
    }

    protected boolean isUniqueVariable(List variables, String varName) {
        int i = 0;
        while (i < variables.size()) {
            String variableStr = (String)variables.get(i);
            if (variableStr.startsWith(varName)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected String[] getUserAndHostEnvVarsAsStringArray() {
        int assignIndex;
        String varName;
        String[] userVars = this.getEnvVarsAsStringArray();
        List systemVars = this.getHostEnvironmentVariables();
        ArrayList<String> combinedVars = new ArrayList<String>();
        if (userVars != null) {
            int i = userVars.length - 1;
            while (i >= 0) {
                String userVar = userVars[i];
                varName = null;
                assignIndex = userVar.indexOf(61);
                if (assignIndex > 0 && this.isUniqueVariable(combinedVars, varName = userVar.substring(0, assignIndex + 1))) {
                    combinedVars.add(0, userVar);
                }
                --i;
            }
        }
        int s = 0;
        while (s < systemVars.size()) {
            String systemVar = (String)systemVars.get(s);
            varName = null;
            assignIndex = systemVar.indexOf(61);
            if (assignIndex > 0 && this.isUniqueVariable(combinedVars, varName = systemVar.substring(0, assignIndex + 1))) {
                combinedVars.add(systemVar);
            }
            ++s;
        }
        String[] result = new String[combinedVars.size()];
        int a = 0;
        while (a < combinedVars.size()) {
            result[a] = (String)combinedVars.get(a);
            ++a;
        }
        return result;
    }

    public boolean isWindows() {
        return this.getHost().getSystemType().isWindows();
    }

    public ICandidateCommand[] getCandidateCommands(Object context) {
        if (context instanceof IRemoteCommandShell) {
            IRemoteCommandShell command = (IRemoteCommandShell)context;
            return command.getCandidateCommands();
        }
        return null;
    }

    protected List parsePathEnvironmentVariable(String path) {
        ArrayList<String> addedPaths = new ArrayList<String>();
        ArrayList<IRemoteFile> addedFolders = new ArrayList<IRemoteFile>();
        char separator = this.isWindows() ? (char)';' : ':';
        StringTokenizer tokenizer = new StringTokenizer(path, String.valueOf(separator));
        NullProgressMonitor monitor = new NullProgressMonitor();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (addedPaths.contains(token)) continue;
            addedPaths.add(token);
            IRemoteFileSubSystem fs = this.getFileSubSystem();
            try {
                IRemoteFile file = fs.getRemoteFileObject(token, (IProgressMonitor)monitor);
                addedFolders.add(file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return addedFolders;
    }

    public IRemoteFileSubSystem getFileSubSystem() {
        if (this._fileSubSystem == null) {
            this._fileSubSystem = RemoteFileUtility.getFileSubSystem((IHost)this.getHost());
        }
        return this._fileSubSystem;
    }

    public String getInvalidEnvironmentVariableNameCharacters() {
        return "=";
    }

    public IRemoteCmdSubSystem getCommandSubSystem() {
        return this;
    }

    protected Object[] internalResolveFilterString(String filterString, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        return null;
    }

    public Object[] getChildren() {
        return this.getShells();
    }

    public boolean hasChildren() {
        if (this._cmdShells == null) {
            return false;
        }
        return this._cmdShells.size() > 0;
    }

    public IRemoteCommandShell getDefaultShell() throws Exception {
        IRemoteCommandShell[] shells = this.getShells();
        if (shells == null || shells.length == 0) {
            return this.runShell(null);
        }
        return shells[0];
    }

    public IRemoteCommandShell[] getShells() {
        IRemoteCommandShell[] shells = new IRemoteCommandShell[this._cmdShells.size()];
        int i = 0;
        while (i < this._cmdShells.size()) {
            shells[i] = (IRemoteCommandShell)this._cmdShells.get(i);
            ++i;
        }
        return shells;
    }

    public boolean canRunShell() {
        return true;
    }

    public boolean canRunCommand() {
        return true;
    }

    public Object getObjectWithAbsoluteName(String key, IProgressMonitor monitor) throws Exception {
        String cmdKey = key;
        String outKey = null;
        int indexOfColon = key.indexOf(58);
        if (indexOfColon > 0) {
            cmdKey = key.substring(0, indexOfColon);
            outKey = key.substring(indexOfColon + 1, key.length());
        }
        IRemoteCommandShell theCmd = null;
        IRemoteCommandShell[] cmds = this.getShells();
        int i = 0;
        while (i < cmds.length && theCmd == null) {
            IRemoteCommandShell cmd = cmds[i];
            if (cmd != null && cmd.getId().equals(cmdKey)) {
                theCmd = cmd;
            }
            ++i;
        }
        if (theCmd != null) {
            if (outKey != null) {
                int outIndex = Integer.parseInt(outKey);
                return theCmd.getOutputAt(outIndex);
            }
            return theCmd;
        }
        return super.getObjectWithAbsoluteName(key, monitor);
    }

    protected void saveShellState(List cmdShells) {
        StringBuffer shellBuffer = new StringBuffer();
        int i = 0;
        while (i < cmdShells.size()) {
            IRemoteCommandShell cmd;
            if (i != 0) {
                shellBuffer.append('|');
            }
            if ((cmd = (IRemoteCommandShell)cmdShells.get(i)) != null && cmd.isActive()) {
                String context = cmd.getContextString();
                if (context instanceof String) {
                    shellBuffer.append((Object)context);
                } else {
                    shellBuffer.append(cmd.getType());
                }
            }
            ++i;
        }
        IPropertySet set = this.getPropertySet("Remote");
        if (set == null) {
            set = this.createPropertySet("Remote");
        }
        if (set != null) {
            IProperty property = set.getProperty(COMMAND_SHELLS_MEMENTO);
            if (property == null) {
                property = set.addProperty(COMMAND_SHELLS_MEMENTO, shellBuffer.toString());
            } else {
                property.setValue(shellBuffer.toString());
            }
        }
        this.commit();
    }

    protected void internalRemoveShell(Object command) throws InvocationTargetException, InterruptedException {
        if (command instanceof IRemoteCommandShell) {
            IRemoteCommandShell cmdShell = (IRemoteCommandShell)command;
            if (cmdShell.isActive()) {
                this.internalCancelShell(command, null);
            }
            if (this._defaultShell == command) {
                this._defaultShell = null;
            }
            cmdShell.removeOutput();
            this._cmdShells.remove(command);
            Display.getDefault().asyncExec((Runnable)new RefreshRemovedShell(this, cmdShell));
        }
    }

    public IRemoteCommandShell[] restoreShellState(Shell shellWindow) {
        if (this._hasRestoredState) {
            return null;
        }
        this.shell = shellWindow;
        IRemoteCommandShell[] results = null;
        String shellStr = null;
        IPropertySet set = this.getPropertySet("Remote");
        if (set != null) {
            shellStr = set.getPropertyValue(COMMAND_SHELLS_MEMENTO);
        }
        int numShells = 0;
        if (shellStr != null && shellStr.length() > 0) {
            StringTokenizer tok = new StringTokenizer(shellStr, "|");
            results = new IRemoteCommandShell[tok.countTokens()];
            while (tok.hasMoreTokens()) {
                String context = tok.nextToken();
                if (context == null || context.length() <= 0) continue;
                try {
                    IRemoteCommandShell rmtCmd;
                    results[numShells] = rmtCmd = this.internalRunShell(context, null);
                    ++numShells;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (numShells > 0) {
            Display.getDefault().asyncExec((Runnable)new Refresh(this));
        }
        this._hasRestoredState = true;
        return results;
    }

    public void cancelAllShells() {
        int i = this._cmdShells.size() - 1;
        while (i >= 0) {
            IRemoteCommandShell cmdShell = (IRemoteCommandShell)this._cmdShells.get(i);
            try {
                this.internalRemoveShell(cmdShell);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            --i;
        }
        this._cmdShells.clear();
        this._defaultShell = null;
        Display.getDefault().asyncExec((Runnable)new Refresh(this));
    }

    public boolean isPassiveCommunicationsListener() {
        return true;
    }

    public void communicationsStateChange(CommunicationsEvent e) {
        switch (e.getState()) {
            case 4: {
                this.getConnectorService().removeCommunicationsListener((ICommunicationsListener)this);
                break;
            }
            case 3: 
            case 5: {
                this.saveShellState(this._cmdShells);
                if (this.getShells().length <= 0) break;
                Display.getDefault().asyncExec((Runnable)new CancelAllShells());
                break;
            }
        }
    }

    private IPropertySet getEnvironmentVariables() {
        IPropertySet environmentVariables = this.getPropertySet(ENVIRONMENT_VARS);
        if (environmentVariables == null) {
            environmentVariables = this.createPropertySet(ENVIRONMENT_VARS);
        }
        return environmentVariables;
    }

    public IPropertySet createPropertySet(String name) {
        IPropertySet result = null;
        if (name.equals(ENVIRONMENT_VARS)) {
            result = new PropertyList(ENVIRONMENT_VARS);
            this.addPropertySet(result);
        } else {
            result = super.createPropertySet(name);
        }
        return result;
    }

    public Object[] runCommand(String command, Object context, boolean interpretOutput) throws Exception {
        return this.internalRunCommand(command, context, interpretOutput, null);
    }

    public Object[] runCommand(String command, Object context, boolean interpretOutput, IProgressMonitor monitor) throws Exception {
        return this.internalRunCommand(command, context, interpretOutput, monitor);
    }

    public IRemoteCommandShell runShell(Object context) throws Exception {
        IRemoteCommandShell cmdShell = null;
        if (!this.isConnected()) {
            return null;
        }
        cmdShell = this.internalRunShell(context, null);
        Refresh refreshOnMain = new Refresh(this);
        Display.getDefault().asyncExec((Runnable)refreshOnMain);
        return cmdShell;
    }

    public IRemoteCommandShell runShell(Object context, IProgressMonitor monitor) throws Exception {
        IRemoteCommandShell cmdShell = this.internalRunShell(context, monitor);
        Refresh refreshOnMain = new Refresh(this);
        Display.getDefault().asyncExec((Runnable)refreshOnMain);
        return cmdShell;
    }

    public Object[] runCommand(String command, Object context) throws Exception {
        return this.runCommand(command, context, true);
    }

    public Object[] runCommand(String command, Object context, IProgressMonitor monitor) throws Exception {
        return this.runCommand(command, context, true, monitor);
    }

    public void sendCommandToShell(String input, Object commandObject, IProgressMonitor monitor) throws Exception {
        boolean ok = true;
        if (!this.isConnected()) {
            ok = this.promptForPassword();
        }
        if (ok) {
            this.internalSendCommandToShell(input, commandObject, monitor);
        } else {
            SystemBasePlugin.logDebugMessage((String)this.getClass().getName(), (String)"in SubSystemImpl.sendCommandToShell: isConnected() returning false!");
        }
    }

    public void cancelShell(Object commandObject) throws Exception {
        if (this.isConnected()) {
            this.internalCancelShell(commandObject, null);
        } else {
            boolean ok = true;
            if (!this.isConnected()) {
                ok = this.promptForPassword();
            }
            if (ok) {
                try {
                    CancelShellJob job = new CancelShellJob(commandObject);
                    this.scheduleJob(job, null);
                }
                catch (InterruptedException exc) {
                    if (this.shell == null) {
                        throw exc;
                    }
                    this.showOperationCancelledMessage(this.shell);
                }
            } else {
                SystemBasePlugin.logDebugMessage((String)this.getClass().getName(), (String)"in SubSystemImpl.cancelShell: isConnected() returning false!");
            }
        }
    }

    public void cancelShell(Object commandObject, IProgressMonitor monitor) throws Exception {
        boolean ok = true;
        if (!this.isConnected()) {
            ok = this.promptForPassword();
        }
        if (ok) {
            this.internalCancelShell(commandObject, monitor);
        } else {
            SystemBasePlugin.logDebugMessage((String)this.getClass().getName(), (String)"in SubSystemImpl.cancelShell: isConnected() returning false!");
        }
    }

    public void removeShell(Object commandObject) throws Exception {
        if (this.isConnected()) {
            this.internalRemoveShell(commandObject);
        } else {
            boolean ok = true;
            if (!this.isConnected()) {
                ok = this.promptForPassword();
            }
            if (ok) {
                try {
                    RemoveShellJob job = new RemoveShellJob(commandObject);
                    this.scheduleJob(job, null);
                }
                catch (InterruptedException exc) {
                    if (this.shell == null) {
                        throw exc;
                    }
                    this.showOperationCancelledMessage(this.shell);
                }
            } else {
                SystemBasePlugin.logDebugMessage((String)this.getClass().getName(), (String)"in SubSystemImpl.removeShell: isConnected() returning false!");
            }
        }
    }

    protected Object[] internalRunCommand(String cmd, Object context, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, SystemMessageException {
        return null;
    }

    protected Object[] internalRunCommand(String cmd, Object context, boolean interpretOutput, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, SystemMessageException {
        return null;
    }

    protected IRemoteCommandShell internalRunShell(Object context, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, SystemMessageException {
        return null;
    }

    protected void internalCancelShell(Object command, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
    }

    protected void internalSendCommandToShell(String cmd, Object command, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
    }

    private class CancelAllShells
    implements Runnable {
        private CancelAllShells() {
        }

        public void run() {
            RemoteCmdSubSystem.this.cancelAllShells();
        }
    }

    protected class CancelShellJob
    extends SubSystem.SubSystemOperationJob {
        protected Object _runContext;

        public CancelShellJob(Object runContext) {
            super((SubSystem)RemoteCmdSubSystem.this, ShellStrings.RSESubSystemOperation_Cancel_Shell_message);
            this._runContext = runContext;
        }

        public void performOperation(IProgressMonitor mon) throws InterruptedException, InvocationTargetException, Exception {
            String msg = null;
            int totalWorkUnits = -1;
            if (!RemoteCmdSubSystem.this.implicitConnect(false, mon, msg, totalWorkUnits)) {
                String msgTxt = NLS.bind((String)ShellStrings.MSG_CONNECT_FAILED, (Object)RemoteCmdSubSystem.this.getHostName());
                throw new Exception(msgTxt);
            }
            RemoteCmdSubSystem.this.internalCancelShell(this._runContext, mon);
        }
    }

    public class Refresh
    implements Runnable {
        private RemoteCmdSubSystem _ss;

        public Refresh(RemoteCmdSubSystem ss) {
            this._ss = ss;
        }

        public void run() {
            if (RSECorePlugin.isTheSystemRegistryActive()) {
                ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
                registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)this._ss, 82, (Object)this._ss));
            }
        }
    }

    public class RefreshRemovedShell
    implements Runnable {
        private RemoteCmdSubSystem _ss;
        private IRemoteCommandShell _cmdShell;

        public RefreshRemovedShell(RemoteCmdSubSystem ss, IRemoteCommandShell cmdShell) {
            this._ss = ss;
            this._cmdShell = cmdShell;
        }

        public void run() {
            ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
            registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)this._cmdShell, 141, null));
            registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)this._ss, 82, (Object)this._ss));
        }
    }

    public class RefreshSubSystem
    implements Runnable {
        RemoteCmdSubSystem _ss;

        public RefreshSubSystem(RemoteCmdSubSystem ss) {
            this._ss = ss;
        }

        public void run() {
            RSECorePlugin.getTheSystemRegistry().fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)this._ss, 141, (Object)this._ss));
        }
    }

    protected class RemoveShellJob
    extends SubSystem.SubSystemOperationJob {
        protected Object _runContext;

        public RemoveShellJob(Object runContext) {
            super((SubSystem)RemoteCmdSubSystem.this, ShellStrings.RSESubSystemOperation_Remove_Shell_message);
            this._runContext = runContext;
        }

        public void performOperation(IProgressMonitor mon) throws InterruptedException, InvocationTargetException, Exception {
            RemoteCmdSubSystem.this.internalRemoveShell(this._runContext);
        }
    }

    protected class RunCommandJob
    extends SubSystem.SubSystemOperationJob {
        protected String _cmd;
        protected Object _runContext;
        protected boolean _runInterpret;

        public RunCommandJob(String cmd, Object runContext, boolean runInterpret) {
            super((SubSystem)RemoteCmdSubSystem.this, ShellStrings.RSESubSystemOperation_Run_command_message);
            this._cmd = cmd;
            this._runContext = runContext;
            this._runInterpret = runInterpret;
        }

        public void performOperation(IProgressMonitor mon) throws InterruptedException, InvocationTargetException, Exception {
            String msg = null;
            int totalWorkUnits = -1;
            msg = RemoteCmdSubSystem.getRunningMessage((String)this._cmd);
            if (!RemoteCmdSubSystem.this.implicitConnect(false, mon, msg, totalWorkUnits)) {
                String msgTxt = NLS.bind((String)ShellStrings.MSG_CONNECT_FAILED, (Object)RemoteCmdSubSystem.this.getHostName());
                throw new Exception(msgTxt);
            }
            this.runOutputs = RemoteCmdSubSystem.this.internalRunCommand(this._cmd, this._runContext, this._runInterpret, mon);
        }
    }

    protected class RunShellJob
    extends SubSystem.SubSystemOperationJob {
        protected Object _runContext;

        public RunShellJob(Object runContext) {
            super((SubSystem)RemoteCmdSubSystem.this, ShellStrings.RSESubSystemOperation_Run_Shell_message);
            this._runContext = runContext;
        }

        public void performOperation(IProgressMonitor mon) throws InterruptedException, InvocationTargetException, Exception {
            String msg = null;
            int totalWorkUnits = -1;
            if (!RemoteCmdSubSystem.this.implicitConnect(false, mon, msg, totalWorkUnits)) {
                String msgTxt = NLS.bind((String)ShellStrings.MSG_CONNECT_FAILED, (Object)RemoteCmdSubSystem.this.getHostName());
                throw new Exception(msgTxt);
            }
            this.runOutputs = new Object[]{RemoteCmdSubSystem.this.internalRunShell(this._runContext, mon)};
        }
    }

    protected class SendCommandToShellJob
    extends SubSystem.SubSystemOperationJob {
        protected Object _runContext;
        protected String _cmd;

        public SendCommandToShellJob(String cmd, Object runContext) {
            super((SubSystem)RemoteCmdSubSystem.this, ShellStrings.RSESubSystemOperation_Send_command_to_Shell_message);
            this._cmd = cmd;
            this._runContext = runContext;
        }

        public void performOperation(IProgressMonitor mon) throws InterruptedException, InvocationTargetException, Exception {
            String msg = null;
            int totalWorkUnits = -1;
            msg = RemoteCmdSubSystem.getRunningMessage((String)this._cmd);
            if (!RemoteCmdSubSystem.this.implicitConnect(false, mon, msg, totalWorkUnits)) {
                String msgTxt = NLS.bind((String)ShellStrings.MSG_CONNECT_FAILED, (Object)RemoteCmdSubSystem.this.getHostName());
                throw new Exception(msgTxt);
            }
            RemoteCmdSubSystem.this.internalSendCommandToShell(this._cmd, this._runContext, mon);
        }
    }
}

