/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.intro.IIntroDescriptor;
import org.eclipse.ui.internal.intro.IIntroRegistry;
import org.eclipse.ui.internal.intro.IntroDescriptor;
import org.eclipse.ui.internal.intro.IntroMessages;
import org.eclipse.ui.internal.registry.RegistryReader;

public class IntroRegistry
implements IIntroRegistry {
    private static final String TAG_INTRO = "intro";
    private static final String TAG_INTROPRODUCTBINDING = "introProductBinding";
    private static final String ATT_INTROID = "introId";
    private static final String ATT_PRODUCTID = "productId";

    @Override
    public int getIntroCount() {
        return this.getIntros().length;
    }

    @Override
    public IIntroDescriptor[] getIntros() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", TAG_INTRO);
        if (point == null) {
            return new IIntroDescriptor[0];
        }
        IExtension[] extensions = point.getExtensions();
        extensions = RegistryReader.orderExtensions(extensions);
        ArrayList<IntroDescriptor> list = new ArrayList<IntroDescriptor>(extensions.length);
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals(TAG_INTRO)) {
                    try {
                        IntroDescriptor descriptor = new IntroDescriptor(element);
                        list.add(descriptor);
                    }
                    catch (CoreException e) {
                        WorkbenchPlugin.log(IntroMessages.Intro_could_not_create_descriptor, e.getStatus());
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return list.toArray(new IIntroDescriptor[list.size()]);
    }

    @Override
    public IIntroDescriptor getIntroForProduct(String targetProductId) {
        IIntroDescriptor[] intros;
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", TAG_INTRO);
        if (point == null) {
            return null;
        }
        IExtension[] extensions = point.getExtensions();
        String targetIntroId = this.getIntroForProduct(targetProductId, extensions = RegistryReader.orderExtensions(extensions));
        if (targetIntroId == null) {
            return null;
        }
        IIntroDescriptor descriptor = null;
        IIntroDescriptor[] iIntroDescriptorArray = intros = this.getIntros();
        int n = intros.length;
        int n2 = 0;
        while (n2 < n) {
            IIntroDescriptor intro = iIntroDescriptorArray[n2];
            if (intro.getId().equals(targetIntroId)) {
                descriptor = intro;
                break;
            }
            ++n2;
        }
        return descriptor;
    }

    private String getIntroForProduct(String targetProductId, IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals(TAG_INTROPRODUCTBINDING)) {
                    String introId = element.getAttribute(ATT_INTROID);
                    String productId = element.getAttribute(ATT_PRODUCTID);
                    if (introId == null || productId == null) {
                        Status status = new Status(4, element.getDeclaringExtension().getContributor().getName(), 4, "introId and productId must be defined.", (Throwable)new IllegalArgumentException());
                        WorkbenchPlugin.log("Invalid intro binding", (IStatus)status);
                    } else if (targetProductId.equals(productId)) {
                        return introId;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IIntroDescriptor getIntro(String id) {
        IIntroDescriptor[] intros;
        IIntroDescriptor[] iIntroDescriptorArray = intros = this.getIntros();
        int n = intros.length;
        int n2 = 0;
        while (n2 < n) {
            IIntroDescriptor desc = iIntroDescriptorArray[n2];
            if (desc.getId().equals(id)) {
                return desc;
            }
            ++n2;
        }
        return null;
    }
}

