/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core.commands;

import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.core.commands.AbstractDebugCommand;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IStep;
import org.eclipse.debug.core.model.IThread;

public abstract class StepCommand
extends AbstractDebugCommand {
    @Override
    protected void doExecute(Object[] targets, IProgressMonitor monitor, IRequest request) throws CoreException {
        Object[] objectArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            Object target = objectArray[n2];
            this.step(target);
            ++n2;
        }
    }

    protected abstract void step(Object var1) throws CoreException;

    @Override
    protected boolean isExecutable(Object[] targets, IProgressMonitor monitor, IEnabledStateRequest collector) throws CoreException {
        if (this.isThreadCompatible(targets)) {
            Object[] objectArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                Object target = objectArray[n2];
                if (!this.isSteppable(target)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    protected abstract boolean isSteppable(Object var1) throws CoreException;

    protected boolean isThreadCompatible(Object[] targets) {
        if (targets.length == 1) {
            return true;
        }
        HashSet<IThread> threads = new HashSet<IThread>(targets.length);
        Object[] objectArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            IStackFrame frame = null;
            if (object instanceof IStackFrame) {
                frame = (IStackFrame)object;
            } else if (object instanceof IAdaptable) {
                frame = (IStackFrame)((IAdaptable)object).getAdapter(IStackFrame.class);
            }
            if (frame != null && !threads.add(frame.getThread())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    protected Object getTarget(Object element) {
        return this.getAdapter(element, IStep.class);
    }
}

