/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.xml.internal.ui.preferences;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wildwebdeveloper.xml.internal.ui.preferences.XMLCatalogs;

public class XMLPreferenceServerConstants {
    public static final LemminxPreference XML_PREFERENCES_DOWNLOAD_EXTERNAL_RESOURCES = new LemminxPreference("downloadExternalResources/enabled");
    public static final LemminxPreference XML_PREFERENCES_CATAGLOGS = new LemminxPreference("catalogs");
    public static final LemminxPreference XML_PREFERENCES_CODELENS_ENABLED = new LemminxPreference("codeLens/enabled");
    public static final LemminxPreference XML_PREFERENCES_FOLDING_INCLUDE_CLOSING_TAG_IN_FOLD = new LemminxPreference("foldings/includeClosingTagInFold");
    public static final LemminxPreference XML_PREFERENCES_FORMAT_EMPTY_ELEMENTS = new LemminxPreference("format/emptyElements");
    public static final LemminxPreference XML_PREFERENCES_FORMAT_SPACE_BEFORE_EMPTY_CLOSE_TAG = new LemminxPreference("format/spaceBeforeEmptyCloseTag");
    public static final LemminxPreference XML_PREFERENCES_FORMAT_SPLIT_ATTRIBUTES = new LemminxPreference("format/splitAttributes");
    public static final LemminxPreference XML_PREFERENCES_FORMAT_SPLIT_ATTRIBUTES_INDENT_SIZE = new LemminxPreference("format/splitAttributesIndentSize");
    public static final LemminxPreference XML_PREFERENCES_FORMAT_PRESERVE_ATTRIBUTE_LINE_BREAKS = new LemminxPreference("format/preserveAttributeLineBreaks");
    public static final LemminxPreference XML_PREFERENCES_FORMAT_CLOSING_BRACKET_NEW_LINE = new LemminxPreference("format/closingBracketNewLine");
    public static final LemminxPreference XML_PREFERENCES_FORMAT_XSI_SCHEMA_LOCATION_SPLIT = new LemminxPreference("format/xsiSchemaLocationSplit");
    public static final LemminxPreference XML_PREFERENCES_FORMAT_JOIN_COMMENTLINES = new LemminxPreference("format/joinCommentLines");
    public static final LemminxPreference XML_PREFERENCES_VALIDATION_ENABLED = new LemminxPreference("validation/enabled");
    public static final LemminxPreference XML_PREFERENCES_VALIDATION_NAMESPACES_ENABLED = new LemminxPreference("validation/namespaces/enabled");
    public static final LemminxPreference XML_PREFERENCES_VALIDATION_SCHEMA_ENABLED = new LemminxPreference("validation/schema/enabled");
    public static final LemminxPreference XML_PREFERENCES_VALIDATION_DISALLOW_DOCTYPE_DECL = new LemminxPreference("validation/disallowDocTypeDecl");
    public static final LemminxPreference XML_PREFERENCES_VALIDATION_RESOLVE_EXTERNAL_ENTITIES = new LemminxPreference("validation/resolveExternalEntities");
    public static final LemminxPreference XML_PREFERENCES_VALIDATION_NO_GRAMMAR = new LemminxPreference("validation/noGrammar");
    private static final LemminxPreference[] ALL_LEMMINX_PREFERENCES = new LemminxPreference[]{XML_PREFERENCES_DOWNLOAD_EXTERNAL_RESOURCES, XML_PREFERENCES_CATAGLOGS, XML_PREFERENCES_CODELENS_ENABLED, XML_PREFERENCES_FOLDING_INCLUDE_CLOSING_TAG_IN_FOLD, XML_PREFERENCES_FORMAT_EMPTY_ELEMENTS, XML_PREFERENCES_FORMAT_SPACE_BEFORE_EMPTY_CLOSE_TAG, XML_PREFERENCES_FORMAT_SPLIT_ATTRIBUTES, XML_PREFERENCES_FORMAT_SPLIT_ATTRIBUTES_INDENT_SIZE, XML_PREFERENCES_FORMAT_PRESERVE_ATTRIBUTE_LINE_BREAKS, XML_PREFERENCES_FORMAT_CLOSING_BRACKET_NEW_LINE, XML_PREFERENCES_FORMAT_XSI_SCHEMA_LOCATION_SPLIT, XML_PREFERENCES_FORMAT_JOIN_COMMENTLINES, XML_PREFERENCES_VALIDATION_ENABLED, XML_PREFERENCES_VALIDATION_NAMESPACES_ENABLED, XML_PREFERENCES_VALIDATION_SCHEMA_ENABLED, XML_PREFERENCES_VALIDATION_DISALLOW_DOCTYPE_DECL, XML_PREFERENCES_VALIDATION_RESOLVE_EXTERNAL_ENTITIES, XML_PREFERENCES_VALIDATION_NO_GRAMMAR};

    public static Optional<LemminxPreference> getLemminxPreference(PropertyChangeEvent event) {
        return Arrays.stream(ALL_LEMMINX_PREFERENCES).filter(pref -> Objects.equals(pref.preferenceId, event.getProperty())).findAny();
    }

    private XMLPreferenceServerConstants() {
    }

    public static void storePreferencesToLemminxOptions(IPreferenceStore store, Map<String, Object> xmlOpts) {
        XML_PREFERENCES_DOWNLOAD_EXTERNAL_RESOURCES.storeToLemminxOptions(store.getBoolean(XMLPreferenceServerConstants.XML_PREFERENCES_DOWNLOAD_EXTERNAL_RESOURCES.preferenceId), xmlOpts);
        XML_PREFERENCES_CATAGLOGS.storeToLemminxOptions(XMLCatalogs.getAllCatalogs(store).stream().map(File::getAbsolutePath).toArray(String[]::new), xmlOpts);
        XML_PREFERENCES_CODELENS_ENABLED.storeToLemminxOptions(store.getBoolean(XMLPreferenceServerConstants.XML_PREFERENCES_CODELENS_ENABLED.preferenceId), xmlOpts);
        XML_PREFERENCES_FOLDING_INCLUDE_CLOSING_TAG_IN_FOLD.storeToLemminxOptions(store.getBoolean(XMLPreferenceServerConstants.XML_PREFERENCES_FOLDING_INCLUDE_CLOSING_TAG_IN_FOLD.preferenceId), xmlOpts);
        XML_PREFERENCES_FORMAT_EMPTY_ELEMENTS.storeToLemminxOptions(store.getString(XMLPreferenceServerConstants.XML_PREFERENCES_FORMAT_EMPTY_ELEMENTS.preferenceId), xmlOpts);
        XML_PREFERENCES_FORMAT_SPACE_BEFORE_EMPTY_CLOSE_TAG.storeToLemminxOptions(store.getBoolean(XMLPreferenceServerConstants.XML_PREFERENCES_FORMAT_SPACE_BEFORE_EMPTY_CLOSE_TAG.preferenceId), xmlOpts);
        XML_PREFERENCES_FORMAT_SPLIT_ATTRIBUTES.storeToLemminxOptions(store.getBoolean(XMLPreferenceServerConstants.XML_PREFERENCES_FORMAT_SPLIT_ATTRIBUTES.preferenceId), xmlOpts);
        XML_PREFERENCES_FORMAT_SPLIT_ATTRIBUTES_INDENT_SIZE.storeToLemminxOptions(store.getInt(XMLPreferenceServerConstants.XML_PREFERENCES_FORMAT_SPLIT_ATTRIBUTES_INDENT_SIZE.preferenceId), xmlOpts);
        XML_PREFERENCES_FORMAT_PRESERVE_ATTRIBUTE_LINE_BREAKS.storeToLemminxOptions(store.getBoolean(XMLPreferenceServerConstants.XML_PREFERENCES_FORMAT_PRESERVE_ATTRIBUTE_LINE_BREAKS.preferenceId), xmlOpts);
        XML_PREFERENCES_FORMAT_CLOSING_BRACKET_NEW_LINE.storeToLemminxOptions(store.getBoolean(XMLPreferenceServerConstants.XML_PREFERENCES_FORMAT_CLOSING_BRACKET_NEW_LINE.preferenceId), xmlOpts);
        XML_PREFERENCES_FORMAT_XSI_SCHEMA_LOCATION_SPLIT.storeToLemminxOptions(store.getString(XMLPreferenceServerConstants.XML_PREFERENCES_FORMAT_XSI_SCHEMA_LOCATION_SPLIT.preferenceId), xmlOpts);
        XML_PREFERENCES_FORMAT_JOIN_COMMENTLINES.storeToLemminxOptions(store.getBoolean(XMLPreferenceServerConstants.XML_PREFERENCES_FORMAT_JOIN_COMMENTLINES.preferenceId), xmlOpts);
        XML_PREFERENCES_VALIDATION_ENABLED.storeToLemminxOptions(store.getBoolean(XMLPreferenceServerConstants.XML_PREFERENCES_VALIDATION_ENABLED.preferenceId), xmlOpts);
        XML_PREFERENCES_VALIDATION_NAMESPACES_ENABLED.storeToLemminxOptions(store.getString(XMLPreferenceServerConstants.XML_PREFERENCES_VALIDATION_NAMESPACES_ENABLED.preferenceId), xmlOpts);
        XML_PREFERENCES_VALIDATION_SCHEMA_ENABLED.storeToLemminxOptions(store.getString(XMLPreferenceServerConstants.XML_PREFERENCES_VALIDATION_SCHEMA_ENABLED.preferenceId), xmlOpts);
        XML_PREFERENCES_VALIDATION_DISALLOW_DOCTYPE_DECL.storeToLemminxOptions(store.getBoolean(XMLPreferenceServerConstants.XML_PREFERENCES_VALIDATION_DISALLOW_DOCTYPE_DECL.preferenceId), xmlOpts);
        XML_PREFERENCES_VALIDATION_RESOLVE_EXTERNAL_ENTITIES.storeToLemminxOptions(store.getBoolean(XMLPreferenceServerConstants.XML_PREFERENCES_VALIDATION_RESOLVE_EXTERNAL_ENTITIES.preferenceId), xmlOpts);
        XML_PREFERENCES_VALIDATION_NO_GRAMMAR.storeToLemminxOptions(store.getString(XMLPreferenceServerConstants.XML_PREFERENCES_VALIDATION_NO_GRAMMAR.preferenceId), xmlOpts);
    }

    public static class LemminxPreference {
        public final String preferenceId;
        public final String lemminxOptionPath;

        public LemminxPreference(String lemminxOptionPath) {
            this.preferenceId = LemminxPreference.getPreferenceId(lemminxOptionPath);
            this.lemminxOptionPath = lemminxOptionPath;
        }

        private static String getPreferenceId(String lemminxOptionPath) {
            return "org.eclipse.wildwebdeveloper.xml." + lemminxOptionPath.replace("/", ".");
        }

        public void storeToLemminxOptions(Object value, Map<String, Object> options) {
            HashMap<String, Object> result = options;
            String[] paths = this.lemminxOptionPath.split("/");
            String path = null;
            int i = 0;
            while (i < paths.length - 1) {
                path = paths[i];
                if (result.containsKey(path)) {
                    result = (HashMap<String, Object>)result.get(path);
                } else {
                    HashMap<String, Object> item = new HashMap<String, Object>();
                    result.put(path, item);
                    result = item;
                }
                ++i;
            }
            path = paths[paths.length - 1];
            result.put(path, value);
        }
    }
}

