/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.resources;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.info.GitItemState;
import org.eclipse.egit.core.internal.info.GitItemStateFactory;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.internal.expressions.AbstractPropertyTester;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;

public class ResourceStatePropertyTester
extends AbstractPropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Property prop;
        Property property2 = prop = property != null ? this.toProperty(property) : null;
        if (prop == null || receiver == null) {
            return false;
        }
        return this.computeResult(expectedValue, this.internalTest(receiver, prop));
    }

    private boolean internalTest(@NonNull Object receiver, @NonNull Property property) {
        Collection collection = (Collection)receiver;
        if (collection.isEmpty()) {
            return false;
        }
        Object selection = null;
        Object first = collection.iterator().next();
        selection = collection.size() == 1 && first instanceof ITextSelection ? SelectionUtils.getStructuredSelection((ISelection)((ITextSelection)first)) : new StructuredSelection(new ArrayList(collection));
        IPath[] iPathArray = SelectionUtils.getSelectedLocations(selection);
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            if (path != null && ResourceUtil.getRepository((IPath)path) != null) {
                GitItemState state = GitItemStateFactory.getInstance().get(path.toFile());
                switch (property) {
                    case HAS_STAGED_CHANGES: {
                        if (!state.isStaged()) break;
                        return true;
                    }
                    case HAS_UNSTAGED_CHANGES: {
                        if (!state.hasUnstagedChanges()) break;
                        return true;
                    }
                    case HAS_NOT_IGNORED_RESOURCES: {
                        if (state.isIgnored()) break;
                        return true;
                    }
                    case HAS_TRACKED_RESOURCES: {
                        if (!state.isTracked()) break;
                        return true;
                    }
                }
            }
            ++n2;
        }
        return false;
    }

    @Nullable
    private Property toProperty(@NonNull String value) {
        if ("hasStagedChanges".equals(value)) {
            return Property.HAS_STAGED_CHANGES;
        }
        if ("hasUnstagedChanges".equals(value)) {
            return Property.HAS_UNSTAGED_CHANGES;
        }
        if ("hasNotIgnoredResources".equals(value)) {
            return Property.HAS_NOT_IGNORED_RESOURCES;
        }
        if ("hasTrackedResources".equals(value)) {
            return Property.HAS_TRACKED_RESOURCES;
        }
        return null;
    }

    private static enum Property {
        HAS_STAGED_CHANGES,
        HAS_UNSTAGED_CHANGES,
        HAS_NOT_IGNORED_RESOURCES,
        HAS_TRACKED_RESOURCES;

    }
}

