/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.properties;

import java.util.Collections;
import java.util.List;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ListPropertySource
implements IPropertySource {
    private final List<?> values;
    private final IPropertyDescriptor[] descriptors;

    public ListPropertySource(List<?> values) {
        this.values = values == null ? Collections.emptyList() : values;
        IPropertyDescriptor[] result = new IPropertyDescriptor[this.values.size()];
        int i = 1;
        while (i <= result.length) {
            result[i - 1] = new PropertyDescriptor((Object)i, Integer.toString(i));
            ++i;
        }
        this.descriptors = result;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.descriptors;
    }

    public Object getPropertyValue(Object id) {
        int index;
        if (id instanceof Integer && (index = (Integer)id - 1) >= 0 && index < this.values.size()) {
            return this.values.get(index);
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public Object getEditableValue() {
        return this;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public String toString() {
        return this.values.isEmpty() ? "" : this.values.toString();
    }
}

