/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.epp.internal.mpc.core.model.News;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiResources;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceWizard;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.NewsUrlHandler;
import org.eclipse.epp.mpc.core.model.INews;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.equinox.internal.p2.ui.discovery.util.WorkbenchUtil;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;

public class NewsViewer {
    private Control browser;
    private Control control;
    private final MarketplaceWizard wizard;

    public NewsViewer(MarketplaceWizard marketplaceWizard) {
        this.wizard = marketplaceWizard;
    }

    public Control createControl(Composite parent) {
        this.control = this.createBrowser(parent);
        if (this.control == null && !parent.isDisposed()) {
            this.control = this.createNoBrowserPart(parent);
        }
        return this.control;
    }

    protected Control createNoBrowserPart(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).margins(20, 0).applyTo(container);
        Label noEmbedBrowserLabel = new Label(container, 64);
        GridDataFactory.fillDefaults().align(1, 0x1000008).grab(true, true).hint(450, -1).applyTo((Control)noEmbedBrowserLabel);
        noEmbedBrowserLabel.setText(Messages.NewsViewer_No_embeddable_browser);
        final Link link = new Link(container, 0);
        GridDataFactory.fillDefaults().align(1, 1).indent(7, 0).grab(true, true).hint(443, -1).applyTo((Control)link);
        link.setText(Messages.NewsViewer_No_news);
        link.setEnabled(false);
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WorkbenchUtil.openUrl((String)e.text, (int)128);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Menu popup = new Menu((Decorations)parent.getShell(), 8);
        MenuItem copyMenuItem = new MenuItem(popup, 8);
        copyMenuItem.setText(Messages.NewsViewer_Copy_Link_Address);
        copyMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Clipboard clipboard = new Clipboard(link.getDisplay());
                String data = (String)link.getData("href");
                clipboard.setContents(new Object[]{data}, new Transfer[]{TextTransfer.getInstance()});
                clipboard.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        link.setMenu(popup);
        this.browser = link;
        return container;
    }

    protected Control createBrowser(Composite parent) {
        block3: {
            try {
                if (PlatformUI.getWorkbench().getBrowserSupport().isInternalWebBrowserAvailable()) break block3;
                return null;
            }
            catch (Throwable t) {
                return null;
            }
        }
        Browser browser = new Browser(parent, 0);
        browser.addProgressListener((ProgressListener)new ProgressRunnable());
        browser.addLocationListener((LocationListener)new NewsUrlHandler(this));
        this.browser = browser;
        return browser;
    }

    public Control getControl() {
        return this.control;
    }

    public MarketplaceWizard getWizard() {
        return this.wizard;
    }

    public Browser getBrowser() {
        if (this.browser instanceof Browser) {
            return (Browser)this.browser;
        }
        return null;
    }

    public void showNews(INews news) {
        String url = news.getUrl();
        if (url != null && url.length() > 0) {
            this.showUrl(url);
            String key = this.computeNewsPreferenceKey();
            MarketplaceClientUiResources.getInstance().getPreferenceStore().putValue(key, this.computeNewsStamp(news));
        }
    }

    protected void showUrl(String url) {
        if (this.browser instanceof Browser) {
            ((Browser)this.browser).setUrl(url);
        } else {
            Link link = (Link)this.browser;
            link.setData("href", (Object)url);
            link.setText(NLS.bind((String)"<a href=\"{0}\">{1}</a>", (Object)url, (Object)url));
            link.setEnabled(true);
            link.getParent().layout();
        }
    }

    public void refresh() {
        if (this.browser instanceof Browser) {
            ((Browser)this.browser).refresh();
        }
    }

    public void stop() {
        if (this.browser instanceof Browser) {
            ((Browser)this.browser).stop();
        }
    }

    public void dispose() {
        if (this.browser != null && this.browser.getMenu() != null) {
            this.browser.getMenu().dispose();
        }
        if (this.control != null) {
            this.control.dispose();
        }
    }

    public boolean isUpdated(INews news) {
        if (news == null) {
            return false;
        }
        String url = news.getUrl();
        if (url == null || url.length() == 0) {
            return false;
        }
        String key = this.computeNewsPreferenceKey();
        String previous = MarketplaceClientUiResources.getInstance().getPreferenceStore().getString(key);
        if (previous != null && previous.length() > 0) {
            String current = this.computeNewsStamp(news);
            return !previous.equals(current);
        }
        return true;
    }

    private String computeNewsStamp(INews news) {
        return NLS.bind((String)"[{0}]{1}", (Object)news.getTimestamp(), (Object)news.getUrl());
    }

    private String computeNewsPreferenceKey() {
        URI catalogUri;
        CatalogDescriptor catalogDescriptor = this.wizard.getConfiguration().getCatalogDescriptor();
        URL catalogUrl = catalogDescriptor.getUrl();
        try {
            catalogUri = catalogUrl.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        String marketplaceId = catalogUri.toString().replaceAll("[^a-zA-Z0-9_-]", "_");
        return String.valueOf(News.class.getSimpleName()) + "/" + marketplaceId;
    }

    private class ProgressRunnable
    implements IRunnableWithProgress,
    ProgressListener {
        private int current;
        private int total;
        private int lastCurrent;
        private int lastTotal;
        private boolean done;
        private boolean running = false;

        private ProgressRunnable() {
        }

        public void completed(ProgressEvent event) {
            if (this.running) {
                this.running = false;
                this.done();
            }
        }

        public void changed(ProgressEvent event) {
            if (event.total == 0) {
                return;
            }
            if (!this.running) {
                this.running = true;
                this.current = event.current;
                this.total = event.total;
                Display.getCurrent().asyncExec(() -> {
                    try {
                        try {
                            IWizardContainer container = NewsViewer.this.wizard.getContainer();
                            if (container != null) {
                                NewsViewer.this.wizard.getContainer().run(true, true, (IRunnableWithProgress)this);
                            }
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            this.completed(null);
                            Browser browser = NewsViewer.this.getBrowser();
                            if (!browser.isDisposed()) {
                                browser.stop();
                                browser.removeProgressListener((ProgressListener)this);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            this.completed(null);
                            Browser browser = NewsViewer.this.getBrowser();
                            if (!browser.isDisposed()) {
                                browser.stop();
                                browser.removeProgressListener((ProgressListener)this);
                            }
                        }
                    }
                    finally {
                        this.completed(null);
                        Browser browser = NewsViewer.this.getBrowser();
                        if (!browser.isDisposed()) {
                            browser.stop();
                            browser.removeProgressListener((ProgressListener)this);
                        }
                    }
                });
            } else {
                this.progress(event.current, event.total);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.NewsViewer_Loading, (int)this.total);
            if (this.current > 0) {
                progress.worked(this.current);
            }
            long lastUpdate = System.currentTimeMillis();
            while (!monitor.isCanceled() && !this.done) {
                int worked;
                int newRemaining;
                ProgressRunnable progressRunnable = this;
                synchronized (progressRunnable) {
                    this.wait(200L);
                    int newCurrent = this.current;
                    int newTotal = this.total;
                    int oldRemaining = this.lastTotal - this.lastCurrent;
                    newRemaining = newTotal - newCurrent;
                    long now = System.currentTimeMillis();
                    long timeSinceLastUpdate = now - lastUpdate;
                    if (newCurrent != this.lastCurrent || newTotal != this.lastTotal) {
                        lastUpdate = now;
                    } else if (newRemaining == 0 && oldRemaining == 0 && timeSinceLastUpdate >= 900L || timeSinceLastUpdate > 10000L) {
                        break;
                    }
                    worked = oldRemaining - newRemaining;
                    if (worked <= 0) {
                        worked = 1;
                    }
                    this.lastTotal = newTotal;
                    this.lastCurrent = newCurrent;
                }
                progress.setWorkRemaining(newRemaining + worked);
                progress.worked(worked);
            }
            if (monitor.isCanceled()) {
                NewsViewer.this.getBrowser().stop();
                return;
            }
        }

        public synchronized void progress(int current, int total) {
            this.current = current;
            this.total = total;
            this.notify();
        }

        public synchronized void done() {
            this.done = true;
            this.notify();
        }
    }
}

