/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.ide.dialogs.InternalErrorDialog;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.WorkbenchErrorHandler;

public class IDEWorkbenchErrorHandler
extends WorkbenchErrorHandler {
    private int exceptionCount = 0;
    private static FatalErrorDialog dialog;
    private boolean closing = false;
    private IWorkbenchConfigurer workbenchConfigurer;
    private static String MSG_OutOfMemoryError;
    private static String MSG_StackOverflowError;
    private static String MSG_VirtualMachineError;
    private static String MSG_SWTError;
    private static String MSG_FATAL_ERROR;
    private static String MSG_FATAL_ERROR_Recursive;
    private static String MSG_FATAL_ERROR_Title;
    private final Map<IStatus, ?> map = Collections.synchronizedMap(new WeakHashMap());

    static {
        MSG_OutOfMemoryError = IDEWorkbenchMessages.FatalError_OutOfMemoryError;
        MSG_StackOverflowError = IDEWorkbenchMessages.FatalError_StackOverflowError;
        MSG_VirtualMachineError = IDEWorkbenchMessages.FatalError_VirtualMachineError;
        MSG_SWTError = IDEWorkbenchMessages.FatalError_SWTError;
        MSG_FATAL_ERROR = IDEWorkbenchMessages.FatalError;
        MSG_FATAL_ERROR_Recursive = IDEWorkbenchMessages.FatalError_RecursiveError;
        MSG_FATAL_ERROR_Title = IDEWorkbenchMessages.InternalError;
    }

    public IDEWorkbenchErrorHandler(IWorkbenchConfigurer configurer) {
        this.workbenchConfigurer = configurer;
    }

    public void handle(StatusAdapter statusAdapter, int style) {
        if (this.isFatal(statusAdapter)) {
            if (this.map.containsKey(statusAdapter.getStatus())) {
                return;
            }
            this.map.put(statusAdapter.getStatus(), null);
            if (statusAdapter.getProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY) == Boolean.TRUE) {
                statusAdapter.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, (Object)Boolean.FALSE);
            }
            super.handle(statusAdapter, style | 4);
        } else {
            super.handle(statusAdapter, style);
        }
        if (this.isFatal(statusAdapter)) {
            UIJob handlingExceptionJob = UIJob.create((String)"IDE Exception Handler", m -> {
                this.handleException(statusAdapter.getStatus().getException());
                return new Status(0, "org.eclipse.ui.ide", IDEWorkbenchMessages.IDEExceptionHandler_ExceptionHandledMessage);
            });
            handlingExceptionJob.setSystem(true);
            handlingExceptionJob.schedule();
        }
    }

    private boolean isFatal(StatusAdapter statusAdapter) {
        return statusAdapter.getStatus().getException() != null && (statusAdapter.getStatus().getException() instanceof OutOfMemoryError || statusAdapter.getStatus().getException() instanceof StackOverflowError || statusAdapter.getStatus().getException() instanceof VirtualMachineError || statusAdapter.getStatus().getException() instanceof SWTError);
    }

    private void handleException(Throwable t) {
        try {
            ++this.exceptionCount;
            if (this.exceptionCount > 1) {
                try {
                    dialog.updateMessage(MessageFormat.format(MSG_FATAL_ERROR, MSG_FATAL_ERROR_Recursive));
                    dialog.getShell().forceActive();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (this.openQuestionDialog(t)) {
                this.closeWorkbench();
            }
        }
        finally {
            --this.exceptionCount;
        }
    }

    private boolean openQuestionDialog(Throwable t) {
        try {
            String msg = null;
            msg = t instanceof OutOfMemoryError ? MSG_OutOfMemoryError : (t instanceof StackOverflowError ? MSG_StackOverflowError : (t instanceof VirtualMachineError ? MSG_VirtualMachineError : (t instanceof SWTError ? MSG_SWTError : (t.getMessage() == null ? IDEWorkbenchMessages.InternalErrorNoArg : NLS.bind((String)IDEWorkbenchMessages.InternalErrorOneArg, (Object)t.getMessage())))));
            Throwable detail = t;
            if (!Policy.DEBUG_OPEN_ERROR_DIALOG) {
                detail = null;
            }
            return (dialog = this.openInternalQuestionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), MSG_FATAL_ERROR_Title, MessageFormat.format(MSG_FATAL_ERROR, msg), detail, 1)).open() == 0;
        }
        catch (Throwable th) {
            System.err.println("Error while informing user about event loop exception:");
            t.printStackTrace();
            System.err.println("Dialog open exception:");
            th.printStackTrace();
            return true;
        }
    }

    private FatalErrorDialog openInternalQuestionDialog(Shell parent, String title, String message, Throwable detail, int defaultIndex) {
        String[] labels = detail == null ? new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL} : new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.SHOW_DETAILS_LABEL};
        FatalErrorDialog dialog = new FatalErrorDialog(parent, title, null, message, detail, 3, labels, defaultIndex);
        if (detail != null) {
            dialog.setDetailButton(2);
        }
        return dialog;
    }

    private void closeWorkbench() {
        if (this.closing) {
            return;
        }
        try {
            this.closing = true;
            if (dialog != null && dialog.getShell() != null && !dialog.getShell().isDisposed()) {
                dialog.close();
            }
            if (this.workbenchConfigurer != null) {
                this.workbenchConfigurer.emergencyClose();
            }
        }
        catch (RuntimeException re) {
            System.err.println("Fatal runtime error happened during workbench emergency close.");
            re.printStackTrace();
            throw re;
        }
        catch (Error e) {
            System.err.println("Fatal error happened during workbench emergency close.");
            e.printStackTrace();
            throw e;
        }
    }

    private static class FatalErrorDialog
    extends InternalErrorDialog {
        public FatalErrorDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, Throwable detail, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
            super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, detail, dialogImageType, dialogButtonLabels, defaultIndex);
        }

        public void updateMessage(String message) {
            this.message = message;
            if (this.messageLabel != null && !this.messageLabel.isDisposed()) {
                this.messageLabel.setText(message);
                this.messageLabel.update();
            }
        }
    }
}

