/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.SerializationException;
import org.eclipse.core.commands.State;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.commands.internal.ICommandHelpService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.renderers.swt.IUpdateService;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.jface.commands.PersistentState;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementReference;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.commands.CommandPersistence;
import org.eclipse.ui.internal.commands.ElementReference;
import org.eclipse.ui.internal.menus.MenuHelper;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;

public final class CommandService
implements ICommandService,
IUpdateService {
    private static final String PREFERENCE_KEY_PREFIX = "org.eclipse.ui.commands/state";
    private final CommandManager commandManager;
    private final CommandPersistence commandPersistence;
    private IEclipseContext context;
    private ICommandHelpService commandHelpService;
    private Map<String, List<IElementReference>> commandCallbacks = new HashMap<String, List<IElementReference>>();

    static String createPreferenceKey(Command command, String stateId) {
        return "org.eclipse.ui.commands/state/" + command.getId() + '/' + stateId;
    }

    public CommandService(CommandManager commandManager, IEclipseContext context) {
        if (commandManager == null) {
            throw new NullPointerException("Cannot create a command service with a null manager");
        }
        this.commandManager = commandManager;
        this.commandPersistence = new CommandPersistence(commandManager);
        this.context = context;
        this.commandHelpService = (ICommandHelpService)context.get(ICommandHelpService.class);
    }

    @Override
    public void addExecutionListener(IExecutionListener listener) {
        this.commandManager.addExecutionListener(listener);
    }

    @Override
    public void defineUncategorizedCategory(String name, String description) {
        this.commandManager.defineUncategorizedCategory(name, description);
    }

    @Override
    public ParameterizedCommand deserialize(String serializedParameterizedCommand) throws NotDefinedException, SerializationException {
        return this.commandManager.deserialize(serializedParameterizedCommand);
    }

    @Override
    public void dispose() {
        Command[] commands;
        this.commandPersistence.dispose();
        Command[] commandArray = commands = this.commandManager.getAllCommands();
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            String[] stateIds;
            Command command = commandArray[n2];
            String[] stringArray = stateIds = command.getStateIds();
            int n3 = stateIds.length;
            int n4 = 0;
            while (n4 < n3) {
                PersistentState persistentState;
                String stateId = stringArray[n4];
                State state = command.getState(stateId);
                if (state instanceof PersistentState && (persistentState = (PersistentState)state).shouldPersist()) {
                    persistentState.save(PrefUtil.getInternalPreferenceStore(), CommandService.createPreferenceKey(command, stateId));
                }
                ++n4;
            }
            ++n2;
        }
        this.commandCallbacks = null;
    }

    @Override
    public Category getCategory(String categoryId) {
        return this.commandManager.getCategory(categoryId);
    }

    @Override
    public Command getCommand(String commandId) {
        return this.commandManager.getCommand(commandId);
    }

    @Override
    public Category[] getDefinedCategories() {
        return this.commandManager.getDefinedCategories();
    }

    @Override
    public Collection getDefinedCategoryIds() {
        return this.commandManager.getDefinedCategoryIds();
    }

    @Override
    public Collection getDefinedCommandIds() {
        return this.commandManager.getDefinedCommandIds();
    }

    @Override
    public Command[] getDefinedCommands() {
        return this.commandManager.getDefinedCommands();
    }

    @Override
    public Collection getDefinedParameterTypeIds() {
        return this.commandManager.getDefinedParameterTypeIds();
    }

    @Override
    public ParameterType[] getDefinedParameterTypes() {
        return this.commandManager.getDefinedParameterTypes();
    }

    @Override
    public String getHelpContextId(Command command) throws NotDefinedException {
        return this.commandHelpService.getHelpContextId(command.getId(), this.context);
    }

    @Override
    public String getHelpContextId(String commandId) throws NotDefinedException {
        Command command = this.getCommand(commandId);
        return this.getHelpContextId(command);
    }

    @Override
    public ParameterType getParameterType(String parameterTypeId) {
        return this.commandManager.getParameterType(parameterTypeId);
    }

    @Override
    public void readRegistry() {
        this.commandPersistence.reRead();
    }

    @Override
    public void removeExecutionListener(IExecutionListener listener) {
        this.commandManager.removeExecutionListener(listener);
    }

    @Override
    public void setHelpContextId(IHandler handler, String helpContextId) {
        this.commandHelpService.setHelpContextId(handler, helpContextId);
    }

    @Override
    public void refreshElements(String commandId, Map filter) {
        Command cmd = this.getCommand(commandId);
        if (!cmd.isDefined() || !(cmd.getHandler() instanceof IElementUpdater)) {
            return;
        }
        final IElementUpdater updater = (IElementUpdater)cmd.getHandler();
        if (this.commandCallbacks == null) {
            return;
        }
        List<IElementReference> callbackRefs = this.commandCallbacks.get(commandId);
        if (callbackRefs == null) {
            return;
        }
        for (final IElementReference callbackRef : callbackRefs) {
            final Map parms = Collections.unmodifiableMap(callbackRef.getParameters());
            ISafeRunnable run = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    WorkbenchPlugin.log("Failed to update callback: " + callbackRef.getCommandId(), exception);
                }

                public void run() throws Exception {
                    updater.updateElement(callbackRef.getElement(), parms);
                }
            };
            if (filter == null) {
                SafeRunner.run((ISafeRunnable)run);
                continue;
            }
            boolean match = true;
            Iterator j = filter.entrySet().iterator();
            while (j.hasNext() && match) {
                Map.Entry parmEntry = j.next();
                Object value = parms.get(parmEntry.getKey());
                if (parmEntry.getValue().equals(value)) continue;
                match = false;
            }
            if (!match) continue;
            SafeRunner.run((ISafeRunnable)run);
        }
    }

    @Override
    public IElementReference registerElementForCommand(ParameterizedCommand command, UIElement element) throws NotDefinedException {
        if (!command.getCommand().isDefined()) {
            throw new NotDefinedException("Cannot define a callback for undefined command " + command.getCommand().getId());
        }
        if (element == null) {
            throw new NotDefinedException("No callback defined for command " + command.getCommand().getId());
        }
        ElementReference ref = new ElementReference(command.getId(), element, command.getParameterMap());
        this.registerElement(ref);
        return ref;
    }

    @Override
    public void registerElement(IElementReference elementReference) {
        List<IElementReference> parameterizedCommands = this.commandCallbacks.get(elementReference.getCommandId());
        if (parameterizedCommands == null) {
            parameterizedCommands = new ArrayList<IElementReference>();
            this.commandCallbacks.put(elementReference.getCommandId(), parameterizedCommands);
        }
        parameterizedCommands.add(elementReference);
        Command command = this.getCommand(elementReference.getCommandId());
        if (command.isDefined() && command.getHandler() instanceof IElementUpdater) {
            ((IElementUpdater)command.getHandler()).updateElement(elementReference.getElement(), elementReference.getParameters());
        }
    }

    @Override
    public void unregisterElement(IElementReference elementReference) {
        if (this.commandCallbacks == null) {
            return;
        }
        List<IElementReference> parameterizedCommands = this.commandCallbacks.get(elementReference.getCommandId());
        if (parameterizedCommands != null) {
            parameterizedCommands.remove(elementReference);
            if (parameterizedCommands.isEmpty()) {
                this.commandCallbacks.remove(elementReference.getCommandId());
            }
        }
    }

    public CommandPersistence getCommandPersistence() {
        return this.commandPersistence;
    }

    public Runnable registerElementForUpdate(ParameterizedCommand parameterizedCommand, final MItem item) {
        UIElement element = new UIElement((IServiceLocator)this.context.get(IWorkbench.class)){

            @Override
            public void setText(String text) {
                item.setLabel(text);
            }

            @Override
            public void setTooltip(String text) {
                item.setTooltip(text);
            }

            @Override
            public void setIcon(ImageDescriptor desc) {
                item.setIconURI(MenuHelper.getIconURI(desc, CommandService.this.context));
            }

            @Override
            public void setDisabledIcon(ImageDescriptor desc) {
                item.getTransientData().put("e4_disabled_icon_image_key", MenuHelper.getIconURI(desc, CommandService.this.context));
            }

            @Override
            public void setHoverIcon(ImageDescriptor desc) {
            }

            @Override
            public void setChecked(boolean checked) {
                item.setSelected(checked);
            }
        };
        try {
            IElementReference reference = this.registerElementForCommand(parameterizedCommand, element);
            return () -> this.unregisterElement(reference);
        }
        catch (NotDefinedException e) {
            WorkbenchPlugin.log(e);
            return null;
        }
    }
}

