/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.eclipse.equinox.internal.p2.metadata.repository.Messages;
import org.eclipse.osgi.util.NLS;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.XZOutputStream;

public class XZCompressor {
    private static final String CONTENT_XML_XZ = "content.xml.xz";
    private static final String ARTIFACTS_XML_XZ = "artifacts.xml.xz";
    private static final String ARTIFACTS2 = "artifacts";
    private static final String CONTENT = "content";
    private static final String JAR = ".jar";
    private static final String XML = ".xml";
    private String repoFolder;
    private boolean preserveOriginalFile = true;
    private ArrayList<File> filesToDelete = new ArrayList();

    public String getRepoFolder() {
        return this.repoFolder;
    }

    public void setRepoFolder(String repoFolder) {
        this.repoFolder = repoFolder;
    }

    public boolean isPreserveOriginalFile() {
        return this.preserveOriginalFile;
    }

    public void setPreserveOriginalFile(boolean preserveOriginalFile) {
        this.preserveOriginalFile = preserveOriginalFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File uncompressJar(File jarFile, String fileToExtract) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (JarInputStream jarStream = new JarInputStream(new FileInputStream(jarFile));){
            File extractedFile;
            block23: {
                JarEntry jarEntry = jarStream.getNextJarEntry();
                while (true) {
                    if (jarEntry == null || fileToExtract.equals(jarEntry.getName())) {
                        if (jarEntry != null) break;
                        jarStream.close();
                        throw new IOException(NLS.bind((String)Messages.repoMan_invalidLocation, (Object)jarFile.getAbsolutePath()));
                    }
                    jarEntry = jarStream.getNextJarEntry();
                }
                extractedFile = new File(jarFile.getAbsoluteFile().getParent(), fileToExtract);
                Throwable throwable2 = null;
                Object var9_12 = null;
                try {
                    BufferedInputStream input = new BufferedInputStream(jarStream);
                    try {
                        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(extractedFile));){
                            byte[] buffer = new byte[8192];
                            int bytesRead = 0;
                            while ((bytesRead = input.read(buffer)) != -1) {
                                ((OutputStream)output).write(buffer, 0, bytesRead);
                            }
                        }
                        if (input == null) break block23;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        if (input == null) throw throwable2;
                        input.close();
                        throw throwable2;
                    }
                    input.close();
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                        throw throwable2;
                    }
                    if (throwable2 == throwable4) throw throwable2;
                    throwable2.addSuppressed(throwable4);
                    throw throwable2;
                }
            }
            this.filesToDelete.add(extractedFile);
            return extractedFile;
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }

    private File getMetadataFile(String prefix) throws IOException {
        File candidate = new File(this.repoFolder, String.valueOf(prefix) + XML);
        if (candidate.exists()) {
            if (!this.preserveOriginalFile) {
                this.filesToDelete.add(candidate);
            }
            return candidate;
        }
        candidate = new File(this.repoFolder, String.valueOf(prefix) + JAR);
        if (candidate.exists()) {
            if (!this.preserveOriginalFile) {
                this.filesToDelete.add(candidate);
            }
            return this.uncompressJar(candidate, String.valueOf(prefix) + XML);
        }
        return null;
    }

    public void compressRepo() throws IOException {
        File artifacts;
        File metadata = this.getMetadataFile(CONTENT);
        if (metadata != null) {
            this.compressFile(metadata, new File(this.repoFolder, CONTENT_XML_XZ));
        }
        if ((artifacts = this.getMetadataFile(ARTIFACTS2)) != null) {
            this.compressFile(artifacts, new File(this.repoFolder, ARTIFACTS_XML_XZ));
        }
        this.createP2Index(metadata != null, artifacts != null);
        this.deleteFiles();
    }

    private void deleteFiles() {
        for (File file : this.filesToDelete) {
            file.delete();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void compressFile(File input, File output) throws IOException {
        LZMA2Options options = new LZMA2Options();
        try {
            options.setDictSize(0x800000);
            options.setLcLp(3, 0);
            options.setPb(4);
            options.setMode(2);
            options.setNiceLen(273);
            options.setMatchFinder(20);
            options.setDepthLimit(512);
        }
        catch (UnsupportedOptionsException unsupportedOptionsException) {}
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            XZOutputStream out = new XZOutputStream((OutputStream)new FileOutputStream(output), (FilterOptions)options);
            try {
                try (FileInputStream is = new FileInputStream(input);){
                    int size;
                    byte[] buf = new byte[8192];
                    while ((size = is.read(buf)) != -1) {
                        out.write(buf, 0, size);
                    }
                }
                if (out == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
            out.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void createP2Index(boolean metadata, boolean artifacts) throws IOException {
        Properties p2Index = new Properties();
        if (metadata) {
            if (this.preserveOriginalFile) {
                p2Index.setProperty("metadata.repository.factory.order", "content.xml.xz,content.xml,!");
            } else {
                p2Index.setProperty("metadata.repository.factory.order", "content.xml.xz,!");
            }
        }
        if (artifacts) {
            if (this.preserveOriginalFile) {
                p2Index.setProperty("artifact.repository.factory.order", "artifacts.xml.xz,artifacts.xml,!");
            } else {
                p2Index.setProperty("artifact.repository.factory.order", "artifacts.xml.xz,!");
            }
        }
        p2Index.setProperty("version", "1");
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream output = new FileOutputStream(new File(this.repoFolder, "p2.index"));){
            p2Index.store(output, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

