/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.tracwiki.internal.phrase;

import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElementProcessor;

public class SimpleWrappedPhraseModifier
extends PatternBasedElement {
    protected static final int CONTENT_GROUP = 1;
    private final String startDelimiter;
    private final String endDelimiter;
    private final DocumentBuilder.SpanType[] spanType;
    private final boolean nesting;

    public SimpleWrappedPhraseModifier(String startDelimiter, String endDelimiter, DocumentBuilder.SpanType[] spanType) {
        this(startDelimiter, endDelimiter, spanType, false);
    }

    public SimpleWrappedPhraseModifier(String startDelimiter, String endDelimiter, DocumentBuilder.SpanType[] spanType, boolean nesting) {
        this.startDelimiter = startDelimiter;
        this.endDelimiter = endDelimiter;
        this.spanType = spanType;
        this.nesting = nesting;
    }

    protected String getPattern(int groupOffset) {
        String pattern = Pattern.quote(this.startDelimiter) + "([^\\s-](?:.*?[^\\s-])?)(?:(?<=[^!])" + Pattern.quote(this.endDelimiter) + ")";
        return pattern;
    }

    protected int getPatternGroupCount() {
        return 1;
    }

    protected static String getContent(PatternBasedElementProcessor processor) {
        return processor.group(1);
    }

    protected static int getStart(PatternBasedElementProcessor processor) {
        return processor.start(1);
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new SimplePhraseModifierProcessor(this.spanType, this.nesting);
    }

    private static class SimplePhraseModifierProcessor
    extends PatternBasedElementProcessor {
        private final DocumentBuilder.SpanType[] spanType;
        private final boolean nesting;

        public SimplePhraseModifierProcessor(DocumentBuilder.SpanType[] spanType, boolean nesting) {
            this.spanType = spanType;
            this.nesting = nesting;
        }

        public void emit() {
            for (DocumentBuilder.SpanType type : this.spanType) {
                this.getBuilder().beginSpan(type, new Attributes());
            }
            if (this.nesting) {
                this.getMarkupLanguage().emitMarkupLine(this.parser, this.state, SimpleWrappedPhraseModifier.getStart(this), SimpleWrappedPhraseModifier.getContent(this), 0);
            } else {
                this.getMarkupLanguage().emitMarkupText(this.parser, this.state, SimpleWrappedPhraseModifier.getContent(this));
            }
            for (int x = 0; x < this.spanType.length; ++x) {
                this.getBuilder().endSpan();
            }
        }
    }
}

