/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.messages;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.messages.ISystemMessageLine;

public class StatusLineManagerAdapter
implements ISystemMessageLine {
    private IStatusLineManager statusLine;
    private String message;
    private String errorMessage;
    private SystemMessage sysErrorMessage;

    public StatusLineManagerAdapter(IStatusLineManager statusLineManager) {
        this.statusLine = statusLineManager;
    }

    public void clearErrorMessage() {
        this.errorMessage = null;
        this.sysErrorMessage = null;
        if (this.statusLine != null) {
            this.statusLine.setErrorMessage(this.errorMessage);
        }
    }

    public void clearMessage() {
        this.message = null;
        if (this.statusLine != null) {
            this.statusLine.setMessage(this.message);
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public SystemMessage getSystemErrorMessage() {
        return this.sysErrorMessage;
    }

    public String getMessage() {
        return this.message;
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
        if (this.statusLine != null) {
            this.statusLine.setErrorMessage(message);
        }
    }

    public void setErrorMessage(SystemMessage message) {
        this.sysErrorMessage = message;
        this.setErrorMessage(message.getLevelOneText());
    }

    public void setErrorMessage(Throwable exc) {
        this.setErrorMessage(exc.getMessage());
    }

    public void setMessage(String message) {
        this.message = message;
        if (this.statusLine != null) {
            this.statusLine.setMessage(message);
        }
    }

    public void setMessage(SystemMessage message) {
        this.setMessage(message.getLevelOneText());
    }
}

