/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.operations.completion.LSContentAssistProcessor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wildwebdeveloper.tests.AllCleanRule;
import org.eclipse.wildwebdeveloper.tests.Utils;
import org.eclipse.wildwebdeveloper.xml.internal.Activator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@ExtendWith(value={AllCleanRule.class})
public class TestXML {
    private IProject project;
    private ICompletionProposal[] proposals;

    @BeforeEach
    public void setUpProject() throws CoreException {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getClass().getName() + System.nanoTime());
        this.project.create(null);
        this.project.open(null);
    }

    @Test
    public void testXMLFile() throws Exception {
        IFile file = this.project.getFile("blah.xml");
        file.create("FAIL".getBytes(), true, false, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("<plugin></");
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)PlatformUI.getWorkbench().getDisplay(), (long)5000L, () -> {
            try {
                return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
            }
            catch (CoreException e) {
                return false;
            }
        }), (String)"Diagnostic not published");
    }

    @Test
    public void testXSLFile() throws Exception {
        IFile file = this.project.getFile("blah.xsl");
        file.create("FAIL".getBytes(), true, false, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("FAIL");
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)PlatformUI.getWorkbench().getDisplay(), (long)5000L, () -> {
            try {
                return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
            }
            catch (CoreException e) {
                return false;
            }
        }), (String)"Diagnostic not published");
    }

    @Test
    public void testXSDFile() throws Exception {
        IFile file = this.project.getFile("blah.xsd");
        file.create("FAIL".getBytes(), true, false, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("a<");
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)PlatformUI.getWorkbench().getDisplay(), (long)5000L, () -> {
            try {
                return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
            }
            catch (CoreException e) {
                return false;
            }
        }), (String)"Diagnostic not published");
    }

    @Test
    public void testDTDFile() throws Exception {
        IFile file = this.project.getFile("blah.dtd");
        file.create("FAIL".getBytes(), true, false, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("<!--<!-- -->");
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)PlatformUI.getWorkbench().getDisplay(), (long)5000L, () -> {
            try {
                return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
            }
            catch (CoreException e) {
                return false;
            }
        }), (String)"Diagnostic not published");
    }

    @Test
    public void testComplexXML() throws Exception {
        IFile file = this.project.getFile("blah.xml");
        String content = "<layout:BlockLayoutCell\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\t\n    xsi:schemaLocation=\"sap.ui.layout https://openui5.hana.ondemand.com/downloads/schemas/sap.ui.layout.xsd\"\n\txmlns:layout=\"sap.ui.layout\">\n    |\n</layout:BlockLayoutCell>";
        int offset = content.indexOf(124);
        content = content.replace("|", "");
        file.create(content.getBytes(), true, false, null);
        AbstractTextEditor editor = (AbstractTextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file, (String)"org.eclipse.ui.genericeditor.GenericEditor");
        editor.getSelectionProvider().setSelection((ISelection)new TextSelection(offset, 0));
        LSContentAssistProcessor processor = new LSContentAssistProcessor();
        this.proposals = processor.computeCompletionProposals((ITextViewer)Utils.getViewer(editor), offset);
        DisplayHelper.sleep((Display)editor.getSite().getShell().getDisplay(), (long)2000L);
        Assertions.assertTrue((this.proposals.length > 1 ? 1 : 0) != 0);
    }

    @Test
    public void autoCloseTags() throws Exception {
        IFile file = this.project.getFile("autoCloseTags.xml");
        file.create("<foo".getBytes(), true, false, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        document.replace(4, 0, ">");
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)PlatformUI.getWorkbench().getDisplay(), (long)5000L, () -> "<foo></foo>".equals(document.get())), (String)"Autoclose not done");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testXMLCatalog() throws Exception {
        Path bundlePath;
        block13: {
            bundlePath = Files.createTempFile("xmlCatalogTest", "bundle.jar", new FileAttribute[0]);
            bundlePath.toFile().deleteOnExit();
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                FileOutputStream bundleOutput = new FileOutputStream(bundlePath.toFile());
                try {
                    try (JarOutputStream bundleJarOut = new JarOutputStream(bundleOutput);){
                        bundleJarOut.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
                        PrintWriter fileOut = new PrintWriter(bundleJarOut, true, StandardCharsets.UTF_8);
                        fileOut.println("Manifest-Version: 1.0");
                        fileOut.println("Bundle-ManifestVersion: 2");
                        fileOut.println("Bundle-Name: XML-Catalog-Test");
                        fileOut.println("Bundle-SymbolicName: org.eclipse.wildwebdeveloper.test.xmlcatalog;singleton:=true");
                        fileOut.println("Bundle-Version: 0.0.1");
                        fileOut.println("Require-Bundle: org.eclipse.wst.xml.core");
                        bundleJarOut.putNextEntry(new JarEntry("plugin.xml"));
                        fileOut = new PrintWriter(bundleJarOut, true, StandardCharsets.UTF_8);
                        fileOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                        fileOut.println("<?eclipse version=\"3.0\"?>");
                        fileOut.println("<plugin>");
                        fileOut.println("<extension point=\"org.eclipse.wst.xml.core.catalogContributions\">");
                        fileOut.println("<catalogContribution id=\"Test\">");
                        fileOut.println("<uri name=\"http://eclipse.org/wildwebdeveloper/test\" ");
                        fileOut.println("uri=\"/org/eclipse/wildwebdeveloper/test/schema.xsd\"/>");
                        fileOut.println("</catalogContribution>");
                        fileOut.println("</extension>");
                        fileOut.println("</plugin>");
                        bundleJarOut.putNextEntry(new JarEntry("org/eclipse/wildwebdeveloper/test/schema.xsd"));
                        fileOut = new PrintWriter(bundleJarOut, true, StandardCharsets.UTF_8);
                        fileOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                        fileOut.println("<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://eclipse.org/wildwebdeveloper/test\" xmlns:com=\"http://acme.com/order\">");
                        fileOut.println("<xs:element name=\"order\" type=\"com:ordertype\" />");
                        fileOut.println("<xs:complexType name=\"ordertype\">");
                        fileOut.println("<xs:sequence>");
                        fileOut.println("<xs:element name=\"person\" type=\"xs:string\" />");
                        fileOut.println("<xs:element name=\"item\" maxOccurs=\"unbounded\" type=\"xs:string\" />");
                        fileOut.println("</xs:sequence>");
                        fileOut.println("<xs:attribute name=\"orderid\" type=\"xs:string\" use=\"required\" />");
                        fileOut.println("</xs:complexType>");
                        fileOut.println("</xs:schema>");
                        bundleJarOut.closeEntry();
                    }
                    if (bundleOutput == null) break block13;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (bundleOutput == null) throw throwable;
                    bundleOutput.close();
                    throw throwable;
                }
                bundleOutput.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        Activator plugin = Activator.getDefault();
        BundleContext bundleContext = plugin.getBundle().getBundleContext();
        URL bundleUrl = bundlePath.toUri().toURL();
        Bundle catalogBundle = bundleContext.installBundle(bundleUrl.toExternalForm(), bundleUrl.openStream());
        catalogBundle.start();
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"org.eclipse.wildwebdeveloper.xml.internal.ui.preferences.XMLCatalogPreferencePage", null, null);
        dialog.getShell().open();
        dialog.getShell().close();
        File systemCatalog = plugin.getStateLocation().append("system-catalog.xml").toFile();
        Document systemCatalogDom = DocumentBuilderFactory.newDefaultInstance().newDocumentBuilder().parse(systemCatalog);
        Node catalogNode = systemCatalogDom.getLastChild();
        Assertions.assertEquals((short)1, (short)catalogNode.getNodeType());
        Assertions.assertEquals((Object)"catalog", (Object)catalogNode.getNodeName());
        NodeList catalogEntries = catalogNode.getChildNodes();
        List uriNodes = IntStream.range(0, catalogEntries.getLength()).mapToObj(catalogEntries::item).filter(n -> n.getNodeType() == 1).filter(n -> "uri".equals(n.getNodeName())).collect(Collectors.toList());
        Assertions.assertFalse((boolean)uriNodes.isEmpty(), (String)"uri-nodes expected");
        List expectedNodes = uriNodes.stream().filter(n -> "http://eclipse.org/wildwebdeveloper/test".equals(n.getAttributes().getNamedItem("name").getNodeValue())).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)expectedNodes.size(), (String)"one uri-node with the used name expected");
        Node uriNode = (Node)expectedNodes.get(0);
        Assertions.assertNotNull((Object)uriNode.getAttributes().getNamedItem("uri"), (String)"uri-attribute expected");
        String uri = uriNode.getAttributes().getNamedItem("uri").getNodeValue();
        Assertions.assertNotNull((Object)uri, (String)"value fro uri expected");
        Assertions.assertTrue((boolean)uri.startsWith("jar:file:/"), (String)("jar-uri expected: " + uri));
        Assertions.assertTrue((boolean)uri.endsWith("/org/eclipse/wildwebdeveloper/test/schema.xsd"), (String)("relative path of schema in uri expected: " + uri));
        catalogBundle.uninstall();
    }
}

