/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.inlayhint;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.codemining.LineContentCodeMining;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.operations.inlayhint.InlayHintProvider;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.InlayHintLabelPart;
import org.eclipse.lsp4j.InlayHintRegistrationOptions;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class LSPLineContentCodeMining
extends LineContentCodeMining {
    private InlayHint inlayHint;
    private final LanguageServerWrapper wrapper;

    public LSPLineContentCodeMining(InlayHint inlayHint, IDocument document, LanguageServerWrapper languageServerWrapper, InlayHintProvider provider) throws BadLocationException {
        super(LSPLineContentCodeMining.toPosition(inlayHint.getPosition(), document), (ICodeMiningProvider)provider);
        this.inlayHint = inlayHint;
        this.wrapper = languageServerWrapper;
        this.setLabel(LSPLineContentCodeMining.getInlayHintString(inlayHint));
    }

    protected static @Nullable String getInlayHintString(@NonNull InlayHint inlayHint) {
        Either label = inlayHint.getLabel();
        return (String)label.map(Function.identity(), parts -> {
            if (parts == null) {
                return null;
            }
            return parts.stream().map(InlayHintLabelPart::getValue).collect(Collectors.joining());
        });
    }

    protected CompletableFuture<Void> doResolve(ITextViewer viewer, IProgressMonitor monitor) {
        if (this.wrapper.isActive() && LSPLineContentCodeMining.canResolveInlayHint(this.wrapper.getServerCapabilities())) {
            return this.wrapper.execute(ls -> ls.getTextDocumentService().resolveInlayHint(this.inlayHint).thenAcceptAsync(resolvedInlayHint -> {
                this.inlayHint = resolvedInlayHint;
                if (resolvedInlayHint != null) {
                    this.setLabel(LSPLineContentCodeMining.getInlayHintString(resolvedInlayHint));
                }
            }));
        }
        return CompletableFuture.completedFuture(null);
    }

    private static boolean canResolveInlayHint(ServerCapabilities capabilities) {
        Either inlayProvider = capabilities.getInlayHintProvider();
        if (inlayProvider != null && inlayProvider.isRight()) {
            InlayHintRegistrationOptions options = (InlayHintRegistrationOptions)inlayProvider.getRight();
            return options.getResolveProvider() != null && options.getResolveProvider() != false;
        }
        return false;
    }

    private static org.eclipse.jface.text.Position toPosition(Position position, IDocument document) throws BadLocationException {
        int start = LSPEclipseUtils.toOffset(position, document);
        return new org.eclipse.jface.text.Position(start, 1);
    }
}

