/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.themes.css;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.tm4e.core.internal.utils.StringUtils;
import org.eclipse.tm4e.core.theme.IStyle;
import org.eclipse.tm4e.core.theme.RGB;
import org.eclipse.tm4e.core.theme.css.CSSParser;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.themes.AbstractTokenProvider;
import org.eclipse.tm4e.ui.themes.ColorManager;

public class CSSTokenProvider
extends AbstractTokenProvider {
    private final CSSParser parser;

    public CSSTokenProvider(InputStream in) {
        CSSParser parser = null;
        try {
            parser = new CSSParser(in);
        }
        catch (Exception ex) {
            TMUIPlugin.logError(ex);
        }
        this.parser = parser == null ? new NoopCSSParser() : parser;
    }

    @Override
    protected @Nullable IStyle getBestStyle(String textMateTokenType) {
        return this.parser.getBestStyle(StringUtils.splitToArray((String)textMateTokenType, (char)'.'));
    }

    private @Nullable Color getColor(boolean isForeground, String ... cssClassNames) {
        RGB rgb;
        IStyle style = this.parser.getBestStyle(cssClassNames);
        if (style == null) {
            return null;
        }
        RGB rGB = rgb = isForeground ? style.getColor() : style.getBackgroundColor();
        if (rgb == null) {
            return null;
        }
        return ColorManager.getInstance().getColor(rgb);
    }

    @Override
    public @Nullable Color getEditorForeground() {
        return this.getColor(true, "editor");
    }

    @Override
    public @Nullable Color getEditorBackground() {
        return this.getColor(false, "editor");
    }

    @Override
    public @Nullable Color getEditorSelectionForeground() {
        return this.getColor(true, "editor", "selection");
    }

    @Override
    public @Nullable Color getEditorSelectionBackground() {
        return this.getColor(false, "editor", "selection");
    }

    @Override
    public @Nullable Color getEditorCurrentLineHighlight() {
        return this.getColor(false, "editor", "lineHighlight");
    }

    private static final class NoopCSSParser
    extends CSSParser {
        private NoopCSSParser() {
        }

        public List<IStyle> getStyles() {
            return Collections.emptyList();
        }

        public @Nullable IStyle getBestStyle(String ... names) {
            return null;
        }
    }
}

