/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description.rules;

import com.google.common.base.Predicate;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.description.rules.AbstractDesignerRule;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.xml.sax.Attributes;

public final class MethodsOperationRule
extends AbstractDesignerRule {
    private final boolean m_include;
    private ComponentDescription componentDescription;

    public MethodsOperationRule(boolean include) {
        this.m_include = include;
    }

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        this.componentDescription = (ComponentDescription)this.getDigester().peek();
        String signature = MethodsOperationRule.getRequiredAttribute(name, attributes, "signature");
        if (this.isRegexpSignature(signature)) {
            this.processRegexp(signature);
        } else {
            this.processSingleSignature(signature);
        }
    }

    private boolean isRegexpSignature(String signature) {
        return signature.startsWith("/") && signature.endsWith("/");
    }

    private void processRegexp(String signature) throws Exception {
        final Pattern pattern = Pattern.compile(StringUtils.substring((String)signature, (int)1, (int)-1));
        this.process(new Predicate<String>(){

            public boolean apply(String t) {
                return pattern.matcher(t).matches();
            }
        });
    }

    private void processSingleSignature(final String signature) throws Exception {
        this.process(new Predicate<String>(){

            public boolean apply(String t) {
                return signature.equals(t);
            }
        });
    }

    private void process(Predicate<String> signaturePredicate) throws Exception {
        if (this.m_include) {
            this.processInclude(signaturePredicate);
        } else {
            this.processExclude(signaturePredicate);
        }
    }

    private void processInclude(Predicate<String> signaturePredicate) throws Exception {
        Method[] methods;
        Method[] methodArray = methods = this.componentDescription.getComponentClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String methodSignature = ReflectionUtils.getMethodSignature((Method)method);
            if (signaturePredicate.apply((Object)methodSignature)) {
                this.componentDescription.addMethod(method);
            }
            ++n2;
        }
    }

    private void processExclude(Predicate<String> signaturePredicate) {
        Iterator<MethodDescription> I = this.componentDescription.getMethods().iterator();
        while (I.hasNext()) {
            MethodDescription methodDescription = I.next();
            String methodSignature = methodDescription.getSignature();
            if (!signaturePredicate.apply((Object)methodSignature)) continue;
            I.remove();
        }
    }
}

