/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.jdt.core;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ReferenceMatch;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.core.utils.pde.ReflectivePDE;
import org.eclipse.wb.internal.core.utils.reflect.ProjectClassLoader;

public class CodeUtils {
    private CodeUtils() {
    }

    public static CompilationUnit parseCompilationUnit(ICompilationUnit unit) throws Exception {
        String source = unit.getBuffer().getContents();
        source = CodeUtils.clearHiddenCode(source);
        return CodeUtils.parseCompilationUnit(source, unit.getJavaProject(), unit.getElementName());
    }

    public static CompilationUnit parseCompilationUnit(String source, IJavaProject javaProject, String unitName) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(source.toCharArray());
        parser.setProject(javaProject);
        parser.setCompilerOptions(ProjectUtils.getOptions(javaProject));
        parser.setUnitName(unitName);
        parser.setResolveBindings(true);
        return (CompilationUnit)parser.createAST(null);
    }

    private static String clearHiddenCode(String source) throws Exception {
        int hideIndex;
        String beginTag = CodeUtils.clearHiddenCode_getTag("hiddenCode.begin");
        String endTag = CodeUtils.clearHiddenCode_getTag("hiddenCode.end");
        while (true) {
            int beginIndex = source.indexOf(beginTag);
            int endIndex = source.indexOf(endTag);
            if (beginIndex == -1 && endIndex == -1) break;
            if (beginIndex == -1 && endIndex != -1) {
                throw new IllegalStateException("Unexpected state - no hide start and hide stop found.");
            }
            if (beginIndex != -1 && endIndex == -1) {
                throw new IllegalStateException("Unexpected state - no hide stop and hide start found.");
            }
            if (beginIndex >= endIndex) {
                throw new IllegalStateException("Unexpected state - hide start after hide stop.");
            }
            Document document = new Document(source);
            int beginLine = document.getLineOfOffset(beginIndex);
            int endLine = document.getLineOfOffset(endIndex);
            int line = beginLine;
            while (line <= endLine) {
                IRegion info = document.getLineInformation(line);
                int beginOffset = line == beginLine ? beginIndex : info.getOffset();
                int endOffset = info.getOffset() + info.getLength();
                int length = endOffset - beginOffset;
                document.replace(beginOffset, length, StringUtils.repeat((String)" ", (int)length));
                ++line;
            }
            source = document.get();
        }
        String lineTag = CodeUtils.clearHiddenCode_getTag("hiddenCode.singleLine");
        while ((hideIndex = source.indexOf(lineTag)) != -1) {
            Document document = new Document(source);
            IRegion lineInformation = document.getLineInformationOfOffset(hideIndex);
            document.replace(lineInformation.getOffset(), lineInformation.getLength(), StringUtils.repeat((String)" ", (int)lineInformation.getLength()));
            source = document.get();
        }
        return source;
    }

    private static String clearHiddenCode_getTag(String name) {
        IPreferenceStore preferences = DesignerPlugin.getPreferences();
        String tag = preferences.getString(name);
        tag = tag.trim();
        tag = StringUtils.removeStart((String)tag, (String)"//");
        return tag;
    }

    public static IType findPrimaryType(ICompilationUnit compilationUnit) {
        String unitName = compilationUnit.getElementName();
        String typeName = StringUtils.chomp((String)unitName, (String)".java");
        IType primaryType = compilationUnit.getType(typeName);
        if (primaryType.exists()) {
            return primaryType;
        }
        return null;
    }

    public static IType getType(IJavaElement element) throws JavaModelException {
        if (element instanceof IType) {
            return (IType)element;
        }
        if (element instanceof IMember) {
            return ((IMember)element).getDeclaringType();
        }
        if (element instanceof ICompilationUnit) {
            return ((ICompilationUnit)element).findPrimaryType();
        }
        if (element instanceof IClassFile) {
            return ((IClassFile)element).getType();
        }
        return null;
    }

    public static List<IJavaElement> searchReferences(IType type) throws Exception {
        IJavaSearchScope scope = CodeUtils.prepareSearchScope((IJavaElement)type);
        return CodeUtils.searchReferences(scope, type);
    }

    public static List<IJavaElement> searchReferences(IField field) throws Exception {
        IJavaSearchScope scope = CodeUtils.prepareSearchScope((IJavaElement)field);
        return CodeUtils.searchReferences(scope, (IJavaElement)field);
    }

    public static List<IJavaElement> searchReferences(IJavaSearchScope scope, IType type) throws Exception {
        return CodeUtils.searchReferences(scope, (IJavaElement)type);
    }

    private static List<IJavaElement> searchReferences(IJavaSearchScope scope, IJavaElement element) throws Exception {
        final ArrayList references = Lists.newArrayList();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) {
                if (match instanceof ReferenceMatch) {
                    ReferenceMatch refMatch = (ReferenceMatch)match;
                    IJavaElement matchElement = (IJavaElement)refMatch.getElement();
                    IJavaElement localElement = refMatch.getLocalElement();
                    if (localElement != null) {
                        matchElement = localElement;
                    }
                    references.add(matchElement);
                }
            }
        };
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)element, (int)2);
        SearchEngine searchEngine = new SearchEngine();
        searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, (IProgressMonitor)new NullProgressMonitor());
        return references;
    }

    private static IJavaSearchScope prepareSearchScope(IJavaElement element) {
        IJavaProject javaProject = element.getJavaProject();
        return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject}, (int)1);
    }

    public static String getShortClass(String className) {
        int index = StringUtils.lastIndexOfAny((String)className, (String[])new String[]{".", "$"});
        if (index != -1) {
            return className.substring(index + 1);
        }
        return className;
    }

    public static String getPackage(String className) {
        int lastDotIndex = className.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return "";
        }
        return className.substring(0, lastDotIndex);
    }

    public static boolean isSamePackage(String className_1, String className_2) {
        String package_1 = CodeUtils.getPackage(className_1);
        String package_2 = CodeUtils.getPackage(className_2);
        return package_1.equals(package_2);
    }

    public static String[] join(String[] baseStrings, String add) {
        if (baseStrings == null) {
            return new String[]{add};
        }
        String[] strings = new String[baseStrings.length + 1];
        System.arraycopy(baseStrings, 0, strings, 0, baseStrings.length);
        strings[baseStrings.length] = add;
        return strings;
    }

    public static String[] join(String[] strings_1, String[] strings_2) {
        if (strings_1 == null) {
            return strings_2;
        }
        if (strings_2 == null) {
            return strings_1;
        }
        String[] strings = new String[strings_1.length + strings_2.length];
        System.arraycopy(strings_1, 0, strings, 0, strings_1.length);
        System.arraycopy(strings_2, 0, strings, strings_1.length, strings_2.length);
        return strings;
    }

    public static String[] join(String[] strings_1, String[] strings_2, String[] strings_3) {
        String[] strings_1_2 = CodeUtils.join(strings_1, strings_2);
        return CodeUtils.join(strings_1_2, strings_3);
    }

    public static String getSource(String ... lines) {
        return StringUtils.join((Object[])lines, (String)"\n");
    }

    public static String generateUniqueName(String baseName, Predicate<String> validator) {
        int index = 0;
        while (true) {
            String name = baseName;
            if (index != 0) {
                name = String.valueOf(name) + "_" + index;
            }
            if (validator.apply((Object)name)) {
                return name;
            }
            ++index;
        }
    }

    public static ProjectClassLoader getProjectClassLoader(IJavaProject project) throws Exception {
        ClassLoader parentClassLoader = CodeUtils.class.getClassLoader();
        return ProjectClassLoader.create(parentClassLoader, project);
    }

    public static boolean isSuccessorOf(IType type, String superTypeName) throws JavaModelException {
        ITypeHierarchy supertypeHierarchy = type.newSupertypeHierarchy(null);
        IType[] iTypeArray = supertypeHierarchy.getAllTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType superType = iTypeArray[n2];
            if (superType.getFullyQualifiedName().equals(superTypeName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isSuccessorOf(IType type, IType superType) throws JavaModelException {
        return CodeUtils.isSuccessorOf(type, superType.getFullyQualifiedName());
    }

    public static IMethod findSuperMethod(IMethod method) throws Exception {
        String signature = CodeUtils.getMethodSignature(method);
        IType type = method.getDeclaringType();
        return CodeUtils.findMethodInSuperTypes(type, signature);
    }

    public static IMethod findMethod(IJavaProject project, IMethodBinding methodBinding) throws Exception {
        String declaringTypeName = AstNodeUtils.getFullyQualifiedName(methodBinding.getDeclaringClass(), false);
        String signature = AstNodeUtils.getMethodSignature(methodBinding);
        return CodeUtils.findMethod(project, declaringTypeName, signature);
    }

    public static IMethod findMethod(IJavaProject project, String typeName, String signature) throws Exception {
        IType type = project.findType(typeName);
        return CodeUtils.findMethod(type, signature);
    }

    public static IMethod findMethod(IType type, String signature) throws Exception {
        if (type == null) {
            return null;
        }
        IMethod method = CodeUtils.findMethodSingleType(type, signature);
        if (method != null) {
            return method;
        }
        return CodeUtils.findMethodInSuperTypes(type, signature);
    }

    private static IMethod findMethodInSuperTypes(IType type, String signature) throws JavaModelException {
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        IType[] allSupertypes = hierarchy.getAllSupertypes(type);
        int i = allSupertypes.length - 1;
        while (i >= 0) {
            IType superType = allSupertypes[i];
            IMethod superMethod = CodeUtils.findMethodSingleType(superType, signature);
            if (superMethod != null) {
                return superMethod;
            }
            --i;
        }
        return null;
    }

    public static IMethod findMethodSingleType(IType type, String signature) throws JavaModelException {
        String name = StringUtils.substringBefore((String)signature, (String)"(");
        boolean wantConstructor = "<init>".equals(name);
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if ((method.getElementName().equals(name) || wantConstructor && method.isConstructor()) && CodeUtils.getMethodSignature(method).equals(signature)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public static List<IMethod> findMethods(IType type, List<String> signatures) throws JavaModelException {
        Object[] methods = CodeUtils.findMethods(type, signatures.toArray(new String[signatures.size()]));
        return Lists.newArrayList((Object[])methods);
    }

    public static IMethod[] findMethods(IType type, String[] signatures) throws JavaModelException {
        TreeMap signatureToMethod = Maps.newTreeMap();
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            signatureToMethod.put(CodeUtils.getMethodSignature(method), method);
            ++n2;
        }
        IMethod[] methods = new IMethod[signatures.length];
        int i = 0;
        while (i < signatures.length) {
            String signature = signatures[i];
            if (signature != null) {
                methods[i] = (IMethod)signatureToMethod.get(signature);
            }
            ++i;
        }
        return methods;
    }

    public static String getMethodSignature(IMethod method) throws JavaModelException {
        Assert.isNotNull((Object)method);
        StringBuffer buffer = new StringBuffer();
        if (method.isConstructor()) {
            buffer.append("<init>");
        } else {
            buffer.append(method.getElementName());
        }
        buffer.append('(');
        IType contextType = method.getDeclaringType();
        String[] parameterTypes = method.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            String shortParameterType = parameterTypes[i];
            if (i != 0) {
                buffer.append(',');
            }
            String parameterType = CodeUtils.getResolvedTypeName(contextType, shortParameterType);
            buffer.append(parameterType);
            ++i;
        }
        buffer.append(')');
        return buffer.toString();
    }

    public static String getResolvedTypeName(IType context, String typeSignature) throws JavaModelException {
        int arrayCount;
        char type;
        if (typeSignature.indexOf(60) != -1) {
            typeSignature = Signature.getTypeErasure((String)typeSignature);
        }
        if ((type = typeSignature.charAt(arrayCount = Signature.getArrayCount((String)typeSignature))) == 'Q' || type == 'T') {
            int semi = typeSignature.indexOf(59, arrayCount + 1);
            String name = typeSignature.substring(arrayCount + 1, semi);
            String[][] resolvedNames = context.resolveType(name = CodeUtils.getResolvedTypeName_resolveTypeVariable(context, name));
            if (resolvedNames != null && resolvedNames.length > 0) {
                return String.valueOf(CodeUtils.concatenateName(resolvedNames[0][0], resolvedNames[0][1])) + StringUtils.repeat((String)"[]", (int)arrayCount);
            }
            return null;
        }
        String name = Signature.toString((String)typeSignature);
        name = CodeUtils.getResolvedTypeName_resolveTypeVariable(context, name);
        return name;
    }

    private static String getResolvedTypeName_resolveTypeVariable(IType context, String name) throws JavaModelException {
        ITypeParameter typeParameter = context.getTypeParameter(name);
        if (typeParameter.exists()) {
            String[] bounds = typeParameter.getBounds();
            name = bounds.length != 0 ? bounds[0] : "java.lang.Object";
        }
        return name;
    }

    private static String concatenateName(String name1, String name2) {
        StringBuffer buf = new StringBuffer();
        if (name1 != null && name1.length() > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length() > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name2);
        }
        return buf.toString();
    }

    public static IField findField(IJavaProject project, String typeName, String fieldName) throws Exception {
        IType type = project.findType(typeName);
        if (type == null) {
            return null;
        }
        IField field = CodeUtils.findFieldSingleType(type, fieldName);
        if (field != null) {
            return field;
        }
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        IType[] allSupertypes = hierarchy.getAllSupertypes(type);
        int i = allSupertypes.length - 1;
        while (i >= 0) {
            IType superType = allSupertypes[i];
            IField field2 = CodeUtils.findFieldSingleType(superType, fieldName);
            if (field2 != null) {
                return field2;
            }
            --i;
        }
        return null;
    }

    private static IField findFieldSingleType(IType type, String fieldName) throws JavaModelException {
        IField[] iFieldArray = type.getFields();
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            if (field.getElementName().equals(fieldName)) {
                return field;
            }
            ++n2;
        }
        return null;
    }

    public static List<IContainer> getSourceContainers(IJavaProject javaProject, boolean includeRequiredProjects) throws Exception {
        ArrayList containers = Lists.newArrayList();
        CodeUtils.addSourceContainers(containers, Sets.newHashSet(), javaProject, includeRequiredProjects);
        return containers;
    }

    private static void addSourceContainers(List<IContainer> containers, Set<IJavaProject> visitedProjects, IJavaProject javaProject, boolean includeRequiredProjects) throws Exception {
        BundleDescription bundleDescription;
        Object model;
        if (!javaProject.exists()) {
            return;
        }
        if (visitedProjects.contains(javaProject)) {
            return;
        }
        visitedProjects.add(javaProject);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = javaProject.getProject();
        Object[] objectArray = javaProject.getResolvedClasspath(true);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer container;
            IClasspathEntry entry = objectArray[n2];
            if (entry.getEntryKind() == 3 && (container = (IContainer)root.findMember(entry.getPath())) != null) {
                containers.add(container);
            }
            ++n2;
        }
        if (includeRequiredProjects) {
            objectArray = javaProject.getRequiredProjectNames();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                IClasspathEntry requiredProjectName = objectArray[n2];
                CodeUtils.addSourceContainers(containers, visitedProjects, (String)requiredProjectName);
                ++n2;
            }
        }
        if (includeRequiredProjects && (model = ReflectivePDE.findModel(project)) != null && (bundleDescription = ReflectivePDE.getPluginModelBundleDescription(model)) != null) {
            BundleDescription[] fragments;
            BundleDescription[] bundleDescriptionArray = fragments = bundleDescription.getFragments();
            int n3 = fragments.length;
            int n4 = 0;
            while (n4 < n3) {
                BundleDescription fragment = bundleDescriptionArray[n4];
                String fragmentProjectName = fragment.getSymbolicName();
                CodeUtils.addSourceContainers(containers, visitedProjects, fragmentProjectName);
                ++n4;
            }
        }
    }

    private static void addSourceContainers(List<IContainer> containers, Set<IJavaProject> visitedProjects, String projectName) throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        CodeUtils.addSourceContainers(containers, visitedProjects, javaProject, true);
    }

    public static IPackageFragmentRoot getPackageFragmentRoot(IJavaElement element) throws JavaModelException {
        if (element != null) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)element.getAncestor(3);
            if (root != null && root.getKind() == 1) {
                return root;
            }
            IJavaProject javaProject = element.getJavaProject();
            if (javaProject != null && javaProject.exists()) {
                IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
                int n = iPackageFragmentRootArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot root2 = iPackageFragmentRootArray[n2];
                    if (root2.getKind() == 1) {
                        return root2;
                    }
                    ++n2;
                }
            }
        }
        return null;
    }
}

