/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.bundle;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.converter.StringConverter;
import org.eclipse.wb.internal.core.nls.NlsSupport;
import org.eclipse.wb.internal.core.nls.bundle.BundleInfo;
import org.eclipse.wb.internal.core.nls.bundle.IPropertiesAccessor;
import org.eclipse.wb.internal.core.nls.bundle.StandardPropertiesAccessor;
import org.eclipse.wb.internal.core.nls.bundle.pure.activator.ActivatorSource;
import org.eclipse.wb.internal.core.nls.edit.EditableSource;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.model.AbstractSource;
import org.eclipse.wb.internal.core.nls.model.IKeyGeneratorStrategy;
import org.eclipse.wb.internal.core.nls.model.IKeyRenameStrategy;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstVisitorEx;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;

public abstract class AbstractBundleSource
extends AbstractSource {
    protected static final String NLS_EXPRESSION_INFO = "NLS_EXPRESSION_INFO";
    private final HashMap<String, String> m_keyToValue = new HashMap();
    public static final IKeyGeneratorStrategy KEY_GENERATOR = new IKeyGeneratorStrategy(){

        @Override
        public final String generateBaseKey(JavaInfo component, GenericProperty property) {
            String typeName = AbstractBundleSource.getTypeName(component);
            String componentName = component.getVariableSupport().getComponentName();
            return String.valueOf(typeName) + "." + componentName + "." + property.getTitle();
        }
    };
    public static final IKeyRenameStrategy KEY_RENAME = new IKeyRenameStrategy(){

        @Override
        public String getNewKey(String oldName, String newName, String oldKey) {
            if (oldName != null && oldKey.contains(oldName)) {
                String prefix;
                String newKey = oldKey;
                newKey = StringUtils.replace((String)newKey, (String)("." + oldName + "."), (String)("." + newName + "."));
                if ((newKey = StringUtils.replace((String)newKey, (String)("_" + oldName + "_"), (String)("_" + newName + "_"))).startsWith(prefix = String.valueOf(oldName) + ".")) {
                    newKey = String.valueOf(newName) + "." + newKey.substring(prefix.length());
                }
                if (newKey.startsWith(prefix = String.valueOf(oldName) + "_")) {
                    newKey = String.valueOf(newName) + "_" + newKey.substring(prefix.length());
                }
                return newKey;
            }
            return oldKey;
        }
    };
    protected final String m_bundleName;
    private final IFolder m_bundlesFolder;
    private final Map<LocaleInfo, BundleInfo> m_localeToBundleMap = Maps.newHashMap();

    public AbstractBundleSource(JavaInfo root, String bundleName) throws Exception {
        super(root);
        this.m_bundleName = bundleName;
        IFile[] bundleFiles = this.getBundleFiles();
        if (bundleFiles.length == 0) {
            throw new IllegalStateException("At least one bundle file expected for: " + this.m_bundleName);
        }
        IContainer folder = bundleFiles[0].getParent();
        if (folder instanceof IProject) {
            IProject project = (IProject)folder;
            this.m_bundlesFolder = project.getFolder("src");
        } else {
            this.m_bundlesFolder = (IFolder)bundleFiles[0].getParent();
        }
    }

    protected abstract String getBundleComment();

    protected final String getValue(String key) throws Exception {
        LocaleInfo localeInfo = this.getLocaleInfo();
        String value = this.getValue(key, localeInfo);
        if (value == null) {
            LocaleInfo[] locales = this.getLocales();
            if (value == null && !localeInfo.isDefault()) {
                localeInfo = localeInfo.getParent(locales);
                return this.getValue(key, localeInfo);
            }
        }
        return value;
    }

    private String getValue(String key, LocaleInfo localeInfo) throws Exception {
        BundleInfo bundleInfo = this.getBundleInfo(localeInfo);
        return bundleInfo == null ? null : bundleInfo.getValue(key);
    }

    protected final void setValueInBundle(String key, String value) throws Exception {
        LocaleInfo localeInfo = this.getLocaleInfo();
        BundleInfo bundleInfo = this.getBundleInfo(localeInfo);
        if (bundleInfo != null) {
            bundleInfo.setValue(key, value);
            this.saveBundle(bundleInfo);
        }
    }

    @Override
    public final String getKey(Expression expression) throws Exception {
        return this.getBasicExpressionInfo((Expression)expression).m_key;
    }

    @Override
    public boolean isExternallyChanged() throws Exception {
        LocaleInfo localeInfo = this.getLocaleInfo();
        BundleInfo bundleInfo = this.getBundleInfo(localeInfo);
        return bundleInfo.isExternallyChanged();
    }

    @Override
    public void externalize(JavaInfo component, GenericProperty property, String value) throws Exception {
        String baseKey = null;
        String key = null;
        IPreferenceStore preferences = component.getDescription().getToolkit().getPreferences();
        if (preferences.getBoolean("nls.useStringValueForKeyOnly")) {
            baseKey = AbstractBundleSource.shrinkText(value);
        } else {
            baseKey = this.getKeyGeneratorStrategy().generateBaseKey(component, property);
            if (preferences.getBoolean("nls.useStringValueForKey")) {
                baseKey = String.valueOf(baseKey) + "_" + AbstractBundleSource.shrinkText(value);
            }
        }
        key = AbstractSource.generateUniqueKey(this.m_keyToValue, baseKey, value);
        this.m_keyToValue.put(key, value);
        this.apply_externalizeProperty(property, key);
    }

    @Override
    public final void useKey(GenericProperty property, String key) throws Exception {
        AbstractBundleSource.ensureStringLiteral(property);
        BasicExpressionInfo expressionInfo = this.apply_externalize_replaceExpression(property, key);
        Assert.isNotNull((Object)expressionInfo, (String)"Not-null expression information expected for newly externalized property.");
        this.onKeyAdd(property.getJavaInfo(), key);
        NlsSupport.setSource(expressionInfo.m_expression, this);
    }

    @Override
    public final IEditableSource getEditable() throws Exception {
        EditableSource editableSource = new EditableSource();
        editableSource.setShortTitle(this.getTitle());
        editableSource.setLongTitle(String.valueOf(this.getTitle()) + " (" + this.getTypeTitle() + ")");
        LocaleInfo[] locales = this.getLocales();
        int i = 0;
        while (i < locales.length) {
            LocaleInfo locale = locales[i];
            BundleInfo bundle = this.getBundleInfo(locale);
            editableSource.add(locale, bundle.getMap());
            ++i;
        }
        editableSource.setFormKeys(this.getFormKeys());
        editableSource.setKeyToComponentsSupport(this.getKeyToComponentsSupport().getCopy(false));
        editableSource.setKeyGeneratorStrategy(this.getKeyGeneratorStrategy());
        return editableSource;
    }

    protected abstract IKeyGeneratorStrategy getKeyGeneratorStrategy();

    @Override
    public IKeyRenameStrategy getKeyRenameStrategy() {
        return KEY_RENAME;
    }

    @Override
    public final void apply_renameKeys(Map<String, String> oldToNew) throws Exception {
        AstEditor editor = this.m_root.getEditor();
        this.apply_renameKeys_pre(oldToNew);
        final ArrayList expressionInformationList = Lists.newArrayList();
        editor.getAstUnit().accept(new ASTVisitor(){

            public void postVisit(ASTNode node) {
                if (node instanceof Expression) {
                    Expression expression = (Expression)node;
                    BasicExpressionInfo expressionInfo = AbstractBundleSource.this.getBasicExpressionInfo(expression);
                    if (expressionInfo == null) {
                        return;
                    }
                    expressionInformationList.add(expressionInfo);
                }
            }
        });
        for (BasicExpressionInfo basicExpressionInfo : expressionInformationList) {
            Expression newKeyExpression;
            String newKey = oldToNew.get(basicExpressionInfo.m_key);
            if (newKey == null) continue;
            basicExpressionInfo.m_keyExpression = newKeyExpression = this.apply_renameKey_replaceKeyExpression(editor, basicExpressionInfo.m_keyExpression, newKey);
            basicExpressionInfo.m_key = newKey;
        }
        for (Map.Entry entry : oldToNew.entrySet()) {
            String oldKey = (String)entry.getKey();
            String newKey = (String)entry.getValue();
            this.onKeyRename(oldKey, newKey);
        }
    }

    protected abstract Expression apply_renameKey_replaceKeyExpression(AstEditor var1, Expression var2, String var3) throws Exception;

    protected void apply_renameKeys_pre(Map<String, String> oldToNew) throws Exception {
    }

    @Override
    public final void apply_setValues(LocaleInfo locale, Map<String, String> values) throws Exception {
        BundleInfo bundleInfo = this.getBundleInfo(locale);
        bundleInfo.setMap(values);
        this.saveBundle(bundleInfo);
    }

    @Override
    public void apply_addLocale(LocaleInfo locale, Map<String, String> values) throws Exception {
        String shortBundleName = CodeUtils.getShortClass(this.m_bundleName);
        String bundleFileName = String.valueOf(shortBundleName) + "_" + locale.getLocale().toString() + ".properties";
        AbstractBundleSource.createPropertyBundleFile(this.m_bundlesFolder, bundleFileName, this.getCharsetForBundleFiles());
        BundleInfo bundleInfo = this.getBundleInfo(locale);
        bundleInfo.setMap(values);
        this.saveBundle(bundleInfo);
    }

    protected String getCharsetForBundleFiles() {
        return null;
    }

    @Override
    public void apply_removeLocale(LocaleInfo locale) throws Exception {
        BundleInfo bundleInfo = this.getBundleInfo(locale);
        bundleInfo.getFile().delete(true, (IProgressMonitor)new NullProgressMonitor());
        this.m_localeToBundleMap.remove(locale);
    }

    @Override
    public void apply_addKey(String key) throws Exception {
    }

    @Override
    public final void apply_externalizeProperty(GenericProperty property, String key) throws Exception {
        this.apply_addKey(key);
        this.useKey(property, key);
    }

    protected abstract BasicExpressionInfo apply_externalize_replaceExpression(GenericProperty var1, String var2) throws Exception;

    @Override
    public final void apply_internalizeKeys(final Set<String> keys) throws Exception {
        final AstEditor editor = this.m_root.getEditor();
        editor.getAstUnit().accept((ASTVisitor)new AstVisitorEx(){

            @Override
            public void postVisitEx(ASTNode node) throws Exception {
                if (node instanceof Expression) {
                    Expression expression = (Expression)node;
                    BasicExpressionInfo expressionInfo = AbstractBundleSource.this.getBasicExpressionInfo(expression);
                    if (expressionInfo == null) {
                        return;
                    }
                    if (keys.contains(expressionInfo.m_key)) {
                        AbstractBundleSource.this.apply_removeNonNLSComments(expressionInfo);
                        String currentValue = AbstractBundleSource.this.getValue(expression);
                        String code = StringConverter.INSTANCE.toJavaSource(AbstractBundleSource.this.m_root, currentValue);
                        editor.replaceExpression(expression, code);
                    }
                }
            }
        });
        for (String key : keys) {
            this.onKeyInternalize(key);
        }
        this.apply_internalizeKeys_post(keys);
    }

    protected void apply_internalizeKeys_post(Set<String> keys) throws Exception {
    }

    protected void apply_removeNonNLSComments(BasicExpressionInfo basicExpressionInfo) throws Exception {
    }

    protected final Object replaceExpression_getInfo(Expression expression, String code) throws Exception {
        Expression newExpression = this.m_root.getEditor().replaceExpression(expression, code);
        Method getExpressionInfoMethod = this.getClass().getDeclaredMethod("getExpressionInfo", JavaInfo.class, Expression.class);
        getExpressionInfoMethod.setAccessible(true);
        return getExpressionInfoMethod.invoke(null, new Object[]{this.m_root, newExpression});
    }

    protected final void addNonNLSComment(Expression stringLiteralExpression) throws Exception {
        AstEditor editor = this.m_root.getEditor();
        if (stringLiteralExpression instanceof StringLiteral) {
            int index = editor.getStringLiteralNumberOnLine((StringLiteral)stringLiteralExpression);
            editor.addEndOfLineComment(stringLiteralExpression.getStartPosition(), " //$NON-NLS-" + (1 + index) + "$");
        }
    }

    protected final void removeNonNLSComment(StringLiteral literal) throws Exception {
        int index;
        AstEditor editor = this.m_root.getEditor();
        if (literal != null && (index = editor.getStringLiteralNumberOnLine(literal)) != -1) {
            String comment = "//$NON-NLS-" + (1 + index) + "$";
            editor.removeEndOfLineComment(literal.getStartPosition(), comment);
        }
    }

    protected static void createPropertyBundleFile(IPackageFragment targetPackage, String propertyFileName, String charset) throws Exception {
        if (targetPackage instanceof IProject) {
            IProject project = (IProject)targetPackage;
            project.getFile(propertyFileName);
        }
        IFolder folder = (IFolder)targetPackage.getUnderlyingResource();
        AbstractBundleSource.createPropertyBundleFile(folder, propertyFileName, charset);
    }

    protected static void createPropertyBundleFile(IFolder folder, String propertyFileName, String charset) throws Exception {
        IFile propertyFile = AbstractBundleSource.createFileIfDoesNotExist(folder, propertyFileName, "");
        if (propertyFile != null && charset != null) {
            propertyFile.setCharset(charset, null);
        }
    }

    protected static IFile createFileIfDoesNotExist(IFolder folder, String fileName, String contents) throws Exception {
        IFile file = folder.getFile(fileName);
        if (!file.exists()) {
            file.create((InputStream)new ByteArrayInputStream(contents.getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
            return file;
        }
        return null;
    }

    @Override
    public final void replace_toStringLiteral(GenericProperty property, String value) throws Exception {
        Expression expression = property.getExpression();
        BasicExpressionInfo expressionInfo = this.getBasicExpressionInfo(expression);
        this.getKeyToComponentsSupport().remove(property.getJavaInfo(), expressionInfo.m_key);
        this.apply_removeNonNLSComments(expressionInfo);
        String code = StringConverter.INSTANCE.toJavaSource(this.m_root, value);
        this.m_root.getEditor().replaceExpression(expression, code);
    }

    @Override
    public final String getTitle() throws Exception {
        return this.m_bundleName;
    }

    @Override
    public final LocaleInfo[] getLocales() throws Exception {
        IFile[] bundleFiles = this.getBundleFiles();
        return this.getLocales(bundleFiles);
    }

    private LocaleInfo[] getLocales(IFile[] bundleFiles) {
        HashSet locales = Sets.newHashSet();
        int i = 0;
        while (i < bundleFiles.length) {
            IFile file = bundleFiles[i];
            locales.add(BundleInfo.getLocale(this.m_bundleName, file));
            ++i;
        }
        return locales.toArray(new LocaleInfo[locales.size()]);
    }

    @Override
    public Set<String> getKeys() throws Exception {
        HashSet keys = Sets.newHashSet();
        LocaleInfo[] localeInfoArray = this.getLocales();
        int n = localeInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            LocaleInfo locale = localeInfoArray[n2];
            BundleInfo bundle = this.getBundleInfo(locale);
            keys.addAll(bundle.getKeys());
            ++n2;
        }
        return keys;
    }

    protected final BasicExpressionInfo getBasicExpressionInfo(Expression expression) {
        AbstractSource expressionSource = NlsSupport.getSource(expression);
        if (expressionSource == this) {
            return (BasicExpressionInfo)expression.getProperty(NLS_EXPRESSION_INFO);
        }
        return null;
    }

    protected final BundleInfo getBundleInfo(LocaleInfo localeInfo) throws Exception {
        BundleInfo bundleInfo = this.m_localeToBundleMap.get(localeInfo);
        if (bundleInfo == null) {
            IPropertiesAccessor propertiesAccessor = this.getPropertiesAccessor();
            IFile[] files = this.getBundleFiles();
            bundleInfo = BundleInfo.createBundle(propertiesAccessor, this.m_bundleName, localeInfo, files);
            this.m_localeToBundleMap.put(localeInfo, bundleInfo);
        }
        return bundleInfo;
    }

    protected IPropertiesAccessor getPropertiesAccessor() {
        return StandardPropertiesAccessor.INSTANCE;
    }

    private void saveBundle(BundleInfo bundleInfo) throws Exception {
        bundleInfo.save(this.getBundleComment());
    }

    protected final IFile[] getBundleFiles() throws Exception {
        if (this.getClass().equals(ActivatorSource.class)) {
            return this.getBundleFilesActivator();
        }
        ArrayList bundleFiles = Lists.newArrayList();
        String bundlePath = this.m_bundleName.replace('.', '/');
        String bundleFileName = new Path(bundlePath).lastSegment();
        for (IContainer container : this.getSourceContainers()) {
            IResource[] resources = new IResource[]{};
            IPath folderPath = new Path(bundlePath).removeLastSegments(1);
            IFolder folder = container.getFolder(folderPath);
            if (folder.exists()) {
                resources = folder.members();
            }
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                String fileName = resource.getName();
                if (fileName.endsWith(".properties") && (fileName.startsWith(String.valueOf(bundleFileName) + "_") || fileName.startsWith(String.valueOf(bundleFileName) + ".")) && !bundleFiles.contains(resource)) {
                    bundleFiles.add((IFile)resource);
                }
                ++n2;
            }
        }
        return bundleFiles.toArray(new IFile[bundleFiles.size()]);
    }

    private IFile[] getBundleFilesActivator() throws Exception, CoreException {
        String fileName;
        IResource resource;
        int n;
        int n2;
        IResource[] iResourceArray;
        ArrayList bundleFiles = Lists.newArrayList();
        for (IContainer container : this.getSourceContainers()) {
            IFolder folder = container.getFolder((IPath)new Path("."));
            IResource[] resources = new IResource[]{};
            if (folder.exists()) {
                resources = folder.members();
            }
            iResourceArray = resources;
            n2 = resources.length;
            n = 0;
            while (n < n2) {
                resource = iResourceArray[n];
                fileName = resource.getName();
                if (fileName.endsWith(".properties") && (fileName.startsWith("plugin_") || fileName.startsWith("plugin.")) && !bundleFiles.contains(resource)) {
                    bundleFiles.add((IFile)resource);
                }
                ++n;
            }
        }
        for (IContainer container : this.getSourceContainers()) {
            IProject project = container.getProject();
            IResource[] resources2 = project.members();
            iResourceArray = resources2;
            n2 = resources2.length;
            n = 0;
            while (n < n2) {
                resource = iResourceArray[n];
                fileName = resource.getName();
                if (fileName.endsWith(".properties") && (fileName.startsWith("plugin_") || fileName.startsWith("plugin.") || fileName.startsWith(String.valueOf(this.m_bundleName) + "_") || fileName.startsWith(String.valueOf(this.m_bundleName) + ".")) && !bundleFiles.contains(resource)) {
                    bundleFiles.add((IFile)resource);
                }
                ++n;
            }
        }
        return bundleFiles.toArray(new IFile[bundleFiles.size()]);
    }

    private List<IContainer> getSourceContainers() throws Exception {
        return CodeUtils.getSourceContainers(this.m_javaProject, true);
    }

    protected static class BasicExpressionInfo {
        private final Expression m_expression;
        public Expression m_keyExpression;
        public String m_key;

        public BasicExpressionInfo(Expression expression, Expression keyExpression, String key) {
            this.m_expression = expression;
            this.m_keyExpression = keyExpression;
            this.m_key = key;
        }
    }
}

