/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.codegen.bean;

import com.mchange.v1.xml.DomParseUtils;
import com.mchange.v2.codegen.bean.ClassInfo;
import com.mchange.v2.codegen.bean.Property;
import com.mchange.v2.codegen.bean.SimpleProperty;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ParsedPropertyBeanDocument {
    static final String[] EMPTY_SA = new String[0];
    String packageName;
    int class_modifiers;
    String className;
    String superclassName;
    String[] interfaceNames = EMPTY_SA;
    String[] generalImports = EMPTY_SA;
    String[] specificImports = EMPTY_SA;
    Property[] properties;

    public ParsedPropertyBeanDocument(Document doc) {
        Element rootElem = doc.getDocumentElement();
        this.packageName = DomParseUtils.allTextFromUniqueChild((Element)rootElem, (String)"package");
        Element modifiersElem = DomParseUtils.uniqueImmediateChild((Element)rootElem, (String)"modifiers");
        this.class_modifiers = modifiersElem != null ? ParsedPropertyBeanDocument.parseModifiers(modifiersElem) : 1;
        Element importsElem = DomParseUtils.uniqueChild((Element)rootElem, (String)"imports");
        if (importsElem != null) {
            this.generalImports = DomParseUtils.allTextFromImmediateChildElements((Element)importsElem, (String)"general");
            this.specificImports = DomParseUtils.allTextFromImmediateChildElements((Element)importsElem, (String)"specific");
        }
        this.className = DomParseUtils.allTextFromUniqueChild((Element)rootElem, (String)"output-class");
        this.superclassName = DomParseUtils.allTextFromUniqueChild((Element)rootElem, (String)"extends");
        Element implementsElem = DomParseUtils.uniqueChild((Element)rootElem, (String)"implements");
        if (implementsElem != null) {
            this.interfaceNames = DomParseUtils.allTextFromImmediateChildElements((Element)implementsElem, (String)"interface");
        }
        Element propertiesElem = DomParseUtils.uniqueChild((Element)rootElem, (String)"properties");
        this.properties = this.findProperties(propertiesElem);
    }

    public ClassInfo getClassInfo() {
        return new ClassInfo(){

            public String getPackageName() {
                return ParsedPropertyBeanDocument.this.packageName;
            }

            public int getModifiers() {
                return ParsedPropertyBeanDocument.this.class_modifiers;
            }

            public String getClassName() {
                return ParsedPropertyBeanDocument.this.className;
            }

            public String getSuperclassName() {
                return ParsedPropertyBeanDocument.this.superclassName;
            }

            public String[] getInterfaceNames() {
                return ParsedPropertyBeanDocument.this.interfaceNames;
            }

            public String[] getGeneralImports() {
                return ParsedPropertyBeanDocument.this.generalImports;
            }

            public String[] getSpecificImports() {
                return ParsedPropertyBeanDocument.this.specificImports;
            }
        };
    }

    public Property[] getProperties() {
        return (Property[])this.properties.clone();
    }

    private Property[] findProperties(Element propertiesElem) {
        NodeList nl = DomParseUtils.immediateChildElementsByTagName((Element)propertiesElem, (String)"property");
        int len = nl.getLength();
        Property[] out = new Property[len];
        for (int i = 0; i < len; ++i) {
            Element propertyElem = (Element)nl.item(i);
            int variable_modifiers = ParsedPropertyBeanDocument.modifiersThroughParentElem(propertyElem, "variable", 2);
            String name = DomParseUtils.allTextFromUniqueChild((Element)propertyElem, (String)"name", (boolean)true);
            String simpleTypeName = DomParseUtils.allTextFromUniqueChild((Element)propertyElem, (String)"type", (boolean)true);
            String defensiveCopyExpression = DomParseUtils.allTextFromUniqueChild((Element)propertyElem, (String)"defensive-copy", (boolean)true);
            String defaultValueExpression = DomParseUtils.allTextFromUniqueChild((Element)propertyElem, (String)"default-value", (boolean)true);
            int getter_modifiers = ParsedPropertyBeanDocument.modifiersThroughParentElem(propertyElem, "getter", 1);
            int setter_modifiers = ParsedPropertyBeanDocument.modifiersThroughParentElem(propertyElem, "setter", 1);
            Element readOnlyElem = DomParseUtils.uniqueChild((Element)propertyElem, (String)"read-only");
            boolean is_read_only = readOnlyElem != null;
            Element isBoundElem = DomParseUtils.uniqueChild((Element)propertyElem, (String)"bound");
            boolean is_bound = isBoundElem != null;
            Element isConstrainedElem = DomParseUtils.uniqueChild((Element)propertyElem, (String)"constrained");
            boolean is_constrained = isConstrainedElem != null;
            out[i] = new SimpleProperty(variable_modifiers, name, simpleTypeName, defensiveCopyExpression, defaultValueExpression, getter_modifiers, setter_modifiers, is_read_only, is_bound, is_constrained);
        }
        return out;
    }

    private static int modifiersThroughParentElem(Element grandparentElem, String parentElemName, int default_mods) {
        Element parentElem = DomParseUtils.uniqueChild((Element)grandparentElem, (String)parentElemName);
        if (parentElem != null) {
            Element modifiersElem = DomParseUtils.uniqueChild((Element)parentElem, (String)"modifiers");
            if (modifiersElem != null) {
                return ParsedPropertyBeanDocument.parseModifiers(modifiersElem);
            }
            return default_mods;
        }
        return default_mods;
    }

    private static int parseModifiers(Element modifiersElem) {
        int out = 0;
        String[] all_modifiers = DomParseUtils.allTextFromImmediateChildElements((Element)modifiersElem, (String)"modifier", (boolean)true);
        int len = all_modifiers.length;
        for (int i = 0; i < len; ++i) {
            String modifier = all_modifiers[i];
            if ("public".equals(modifier)) {
                out |= 1;
                continue;
            }
            if ("protected".equals(modifier)) {
                out |= 4;
                continue;
            }
            if ("private".equals(modifier)) {
                out |= 2;
                continue;
            }
            if ("final".equals(modifier)) {
                out |= 0x10;
                continue;
            }
            if ("abstract".equals(modifier)) {
                out |= 0x400;
                continue;
            }
            if ("static".equals(modifier)) {
                out |= 8;
                continue;
            }
            if ("synchronized".equals(modifier)) {
                out |= 0x20;
                continue;
            }
            if ("volatile".equals(modifier)) {
                out |= 0x40;
                continue;
            }
            if ("transient".equals(modifier)) {
                out |= 0x80;
                continue;
            }
            if ("strictfp".equals(modifier)) {
                out |= 0x800;
                continue;
            }
            if ("native".equals(modifier)) {
                out |= 0x100;
                continue;
            }
            if ("interface".equals(modifier)) {
                out |= 0x200;
                continue;
            }
            throw new IllegalArgumentException("Bad modifier: " + modifier);
        }
        return out;
    }
}

