/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.Position;

public class FragmentUpdater
extends DefaultPositionUpdater {
    private boolean fShiftMode = false;
    private boolean fIsLast = false;

    protected FragmentUpdater(String fragmentCategory) {
        super(fragmentCategory);
    }

    public void enableShiftMode(boolean enable) {
        this.fShiftMode = enable;
    }

    protected void adaptToInsert() {
        if (this.fShiftMode) {
            super.adaptToInsert();
            return;
        }
        int myStart = this.fPosition.offset;
        int myEnd = this.fPosition.offset + this.fPosition.length - (this.fIsLast ? 0 : 1);
        myEnd = Math.max(myStart, myEnd);
        int yoursStart = this.fOffset;
        int yoursEnd = this.fOffset + this.fReplaceLength - 1;
        yoursEnd = Math.max(yoursStart, yoursEnd);
        if (myEnd < yoursStart) {
            return;
        }
        if (this.fLength <= 0) {
            if (myStart <= yoursStart) {
                this.fPosition.length += this.fReplaceLength;
            } else {
                this.fPosition.offset += this.fReplaceLength;
            }
        } else if (myStart <= yoursStart && this.fOriginalPosition.offset <= yoursStart) {
            this.fPosition.length += this.fReplaceLength;
        } else {
            this.fPosition.offset += this.fReplaceLength;
        }
    }

    public void update(DocumentEvent event) {
        try {
            Position[] category = event.getDocument().getPositions(this.getCategory());
            this.fOffset = event.getOffset();
            this.fLength = event.getLength();
            this.fReplaceLength = event.getText() == null ? 0 : event.getText().length();
            this.fDocument = event.getDocument();
            int i = 0;
            while (i < category.length) {
                this.fPosition = category[i];
                this.fIsLast = i == category.length - 1;
                this.fOriginalPosition.offset = this.fPosition.offset;
                this.fOriginalPosition.length = this.fPosition.length;
                if (this.notDeleted()) {
                    this.adaptToReplace();
                }
                ++i;
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }
}

