/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.beans;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public final class BeansUtils {
    static final Object[] EMPTY_ARGS = new Object[0];
    static /* synthetic */ Class class$java$lang$Object;

    public static PropertyEditor findPropertyEditor(PropertyDescriptor pd) {
        PropertyEditor out = null;
        Class<?> editorClass = null;
        try {
            editorClass = pd.getPropertyEditorClass();
            if (editorClass != null) {
                out = (PropertyEditor)editorClass.newInstance();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("WARNING: Bad property editor class " + editorClass.getName() + " registered for property " + pd.getName());
        }
        if (out == null) {
            out = PropertyEditorManager.findEditor(pd.getPropertyType());
        }
        return out;
    }

    public static void overwriteAccessibleProperties(Object sourceBean, Object destBean) throws IntrospectionException {
        BeansUtils.overwriteAccessibleProperties(sourceBean, destBean, Collections.EMPTY_SET);
    }

    public static void overwriteAccessibleProperties(Object sourceBean, Object destBean, Collection ignoreProps) throws IntrospectionException {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(sourceBean.getClass(), class$java$lang$Object == null ? (class$java$lang$Object = BeansUtils.class$("java.lang.Object")) : class$java$lang$Object);
            PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
            int len = pds.length;
            for (int i = 0; i < len; ++i) {
                PropertyDescriptor pd = pds[i];
                if (ignoreProps.contains(pd.getName())) continue;
                Method getter = pd.getReadMethod();
                Method setter = pd.getWriteMethod();
                if (getter == null || setter == null) {
                    if (pd instanceof IndexedPropertyDescriptor) {
                        System.err.println("WARNING: BeansUtils.overwriteAccessibleProperties() does not");
                        System.err.println("support indexed properties that do not provide single-valued");
                        System.err.println("array getters and setters! [The indexed methods provide no means");
                        System.err.println("of modifying the size of the array in the destination bean if");
                        System.err.println("it does not match the source.]");
                    }
                    System.err.println("Property inaccessible for overwriting: " + pd.getName());
                    continue;
                }
                Object value = getter.invoke(sourceBean, EMPTY_ARGS);
                setter.invoke(destBean, value);
            }
        }
        catch (IntrospectionException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IntrospectionException(e.getMessage());
        }
    }

    public static void overwriteAccessiblePropertiesFromMap(Map sourceMap, Object destBean, boolean skip_nulls) throws IntrospectionException {
        BeansUtils.overwriteAccessiblePropertiesFromMap(sourceMap, destBean, skip_nulls, Collections.EMPTY_SET);
    }

    public static void overwriteAccessiblePropertiesFromMap(Map sourceMap, Object destBean, boolean skip_nulls, Collection ignoreProps) throws IntrospectionException {
        String propName = null;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(destBean.getClass(), class$java$lang$Object == null ? (class$java$lang$Object = BeansUtils.class$("java.lang.Object")) : class$java$lang$Object);
            PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
            int len = pds.length;
            for (int i = 0; i < len; ++i) {
                Object propVal;
                PropertyDescriptor pd = pds[i];
                propName = pd.getName();
                if (ignoreProps.contains(propName) || (propVal = sourceMap.get(propName)) == null && skip_nulls) continue;
                Method setter = pd.getWriteMethod();
                if (setter == null) {
                    if (pd instanceof IndexedPropertyDescriptor) {
                        System.err.println("WARNING: BeansUtils.overwriteAccessiblePropertiesFromMap() does not");
                        System.err.println("support indexed properties that do not provide single-valued");
                        System.err.println("array getters and setters! [The indexed methods provide no means");
                        System.err.println("of modifying the size of the array in the destination bean if");
                        System.err.println("it does not match the source.]");
                    }
                    System.err.println("Property inaccessible for overwriting: " + pd.getName());
                    continue;
                }
                setter.invoke(destBean, propVal);
            }
        }
        catch (IntrospectionException e) {
            if (propName != null) {
                System.err.println("Problem occurred while overwriting property: " + propName);
            }
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IntrospectionException(e.toString() + (propName == null ? "" : " [" + propName + ']'));
        }
    }

    public static void extractAccessiblePropertiesToMap(Map fillMe, Object bean) throws IntrospectionException {
        BeansUtils.extractAccessiblePropertiesToMap(fillMe, bean, Collections.EMPTY_SET);
    }

    public static void extractAccessiblePropertiesToMap(Map fillMe, Object bean, Collection ignoreProps) throws IntrospectionException {
        String propName = null;
        try {
            BeanInfo bi = Introspector.getBeanInfo(bean.getClass(), class$java$lang$Object == null ? (class$java$lang$Object = BeansUtils.class$("java.lang.Object")) : class$java$lang$Object);
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            int len = pds.length;
            for (int i = 0; i < len; ++i) {
                PropertyDescriptor pd = pds[i];
                propName = pd.getName();
                if (ignoreProps.contains(propName)) continue;
                Method readMethod = pd.getReadMethod();
                Object propVal = readMethod.invoke(bean, EMPTY_ARGS);
                fillMe.put(propName, propVal);
            }
        }
        catch (IntrospectionException e) {
            if (propName != null) {
                System.err.println("Problem occurred while overwriting property: " + propName);
            }
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IntrospectionException(e.toString() + (propName == null ? "" : " [" + propName + ']'));
        }
    }

    private static void overwriteProperty(String propName, Object value, Method putativeSetter, Object target) throws Exception {
        if (putativeSetter.getDeclaringClass().isAssignableFrom(target.getClass())) {
            putativeSetter.invoke(target, value);
        } else {
            BeanInfo beanInfo = Introspector.getBeanInfo(target.getClass(), class$java$lang$Object == null ? (class$java$lang$Object = BeansUtils.class$("java.lang.Object")) : class$java$lang$Object);
            PropertyDescriptor pd = null;
            PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
            int len = pds.length;
            for (int i = 0; i < len; ++i) {
                if (!propName.equals(pds[i].getName())) continue;
                pd = pds[i];
                break;
            }
            Method targetSetter = pd.getWriteMethod();
            targetSetter.invoke(target, value);
        }
    }

    public static void overwriteSpecificAccessibleProperties(Object sourceBean, Object destBean, Collection props) throws IntrospectionException {
        try {
            HashSet _props = new HashSet(props);
            BeanInfo beanInfo = Introspector.getBeanInfo(sourceBean.getClass(), class$java$lang$Object == null ? (class$java$lang$Object = BeansUtils.class$("java.lang.Object")) : class$java$lang$Object);
            PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
            int len = pds.length;
            for (int i = 0; i < len; ++i) {
                PropertyDescriptor pd = pds[i];
                String name = pd.getName();
                if (!_props.remove(name)) continue;
                Method getter = pd.getReadMethod();
                Method setter = pd.getWriteMethod();
                if (getter == null || setter == null) {
                    if (pd instanceof IndexedPropertyDescriptor) {
                        System.err.println("WARNING: BeansUtils.overwriteAccessibleProperties() does not");
                        System.err.println("support indexed properties that do not provide single-valued");
                        System.err.println("array getters and setters! [The indexed methods provide no means");
                        System.err.println("of modifying the size of the array in the destination bean if");
                        System.err.println("it does not match the source.]");
                    }
                    System.err.println("Property inaccessible for overwriting: " + pd.getName());
                    continue;
                }
                Object value = getter.invoke(sourceBean, EMPTY_ARGS);
                BeansUtils.overwriteProperty(name, value, setter, destBean);
            }
            Iterator ii = _props.iterator();
            while (ii.hasNext()) {
                System.err.println("failed to find expected property: " + ii.next());
            }
        }
        catch (IntrospectionException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IntrospectionException(e.getMessage());
        }
    }

    public static void debugShowPropertyChange(PropertyChangeEvent evt) {
        System.err.println("PropertyChangeEvent: [ propertyName -> " + evt.getPropertyName() + ", oldValue -> " + evt.getOldValue() + ", newValue -> " + evt.getNewValue() + " ]");
    }

    private BeansUtils() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

