/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.FieldDef;
import org.eclipse.core.internal.indexing.Insertable;
import org.eclipse.core.internal.indexing.Pointer;

public class Buffer {
    protected byte[] contents;
    private static final byte[] ZEROES = new byte[1024];

    protected Buffer() {
    }

    public Buffer(byte[] contents) {
        this.contents = contents;
    }

    public Buffer(int n) {
        this.contents = new byte[n];
    }

    public Buffer(Insertable anObject) {
        this.contents = anObject.toByteArray();
    }

    public void clear() {
        Buffer.clear(this.contents, 0, this.contents.length);
    }

    private static void clear(byte[] buffer, int offset, int length) {
        int n = length;
        int p = offset;
        while (n > 0) {
            int m = Math.min(ZEROES.length, n);
            System.arraycopy(ZEROES, 0, buffer, p, m);
            p += m;
            n -= m;
        }
    }

    private static void clear(byte[] buffer, int offset, int length, byte value) {
        int i = offset;
        while (i < offset + length) {
            buffer[i] = value;
            ++i;
        }
    }

    public void clear(int offset, int length) {
        Buffer.clear(this.contents, offset, length);
    }

    public void clear(int offset, int length, byte value) {
        Buffer.clear(this.contents, offset, length, value);
    }

    private static int compare(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
        if (length1 < length2) {
            return -Buffer.compare(buffer2, offset2, length2, buffer1, offset1, length1);
        }
        int i = 0;
        while (i < length2) {
            int j1 = buffer1[offset1 + i] & 0xFF;
            int j2 = buffer2[offset2 + i] & 0xFF;
            if (j1 > j2) {
                return 1;
            }
            if (j1 < j2) {
                return -1;
            }
            ++i;
        }
        if (length1 > length2) {
            return 1;
        }
        return 0;
    }

    public static int compare(Buffer buffer1, int offset1, int length1, Buffer buffer2, int offset2, int length2) {
        return Buffer.compare(buffer1.contents, offset1, length1, buffer2.contents, offset2, length2);
    }

    public static int compare(Buffer buffer1, Buffer buffer2) {
        return Buffer.compare(buffer1.contents, 0, buffer1.contents.length, buffer2.contents, 0, buffer2.contents.length);
    }

    public void copyInternal(int fromOffset, int toOffset, int length) {
        System.arraycopy(this.contents, fromOffset, this.contents, toOffset, length);
    }

    public void copyTo(byte[] buffer) {
        int n = Math.min(buffer.length, this.contents.length);
        System.arraycopy(this.contents, 0, buffer, 0, n);
    }

    public void copyFrom(byte[] buffer) {
        int n = Math.min(buffer.length, this.contents.length);
        System.arraycopy(buffer, 0, this.contents, 0, n);
    }

    public byte[] get() {
        return this.get(0, this.contents.length);
    }

    public byte[] get(int offset, int length) {
        byte[] result = new byte[length];
        System.arraycopy(this.contents, offset, result, 0, length);
        return result;
    }

    public byte[] get(FieldDef d) {
        return this.get(d.offset, d.length);
    }

    public Field getField(int offset, int length) {
        return new Field(this, offset, length);
    }

    public Field getField(FieldDef d) {
        return new Field(this, d.offset, d.length);
    }

    public byte getByte(int offset) {
        return this.contents[offset];
    }

    public int getInt(int offset, int length) {
        return (int)this.getLong(offset, length);
    }

    public int getInt(FieldDef d) {
        return (int)this.getLong(d.offset, d.length);
    }

    public int getUInt(int offset, int length) {
        int shift = Math.max(0, 32 - length * 8);
        int mask = -1 >>> shift & Integer.MAX_VALUE;
        return this.getInt(offset, length) & mask;
    }

    public int getUInt(FieldDef d) {
        return this.getUInt(d.offset, d.length);
    }

    public long getLong(int offset, int length) {
        if (length <= 0) {
            return 0L;
        }
        long v = this.contents[offset];
        int i = offset + 1;
        while (i < offset + length) {
            v = v << 8 | (long)(this.contents[i] & 0xFF);
            ++i;
        }
        return v;
    }

    public long getLong(FieldDef d) {
        return this.getLong(d.offset, d.length);
    }

    public byte[] getByteArray() {
        return this.contents;
    }

    public int length() {
        return this.contents.length;
    }

    public Pointer pointTo(int offset) {
        return new Pointer(this, offset);
    }

    public void put(int offset, byte value) {
        this.contents[offset] = value;
    }

    public void put(int offset, byte[] source) {
        System.arraycopy(source, 0, this.contents, offset, source.length);
    }

    public void put(int offset, int length, byte[] source) {
        int n = Math.min(length, source.length);
        System.arraycopy(source, 0, this.contents, offset, n);
    }

    public void put(FieldDef d, byte[] source) {
        this.put(d.offset, d.length, source);
    }

    public void put(int offset, int length, long n) {
        long v = n;
        int i = offset + length;
        while (i > offset) {
            this.contents[--i] = (byte)v;
            v >>>= 8;
        }
    }

    public void put(FieldDef d, long n) {
        this.put(d.offset, d.length, n);
    }

    public void put(int offset, int length, int n) {
        this.put(offset, length, (long)n);
    }

    public void put(FieldDef d, int n) {
        this.put(d.offset, d.length, (long)n);
    }

    public void put(int offset, Insertable source) {
        this.put(offset, source.toByteArray());
    }
}

