/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class IteratorForStatement
extends Statement {
    public Expression collection;
    public LocalDeclaration localDeclaration;
    public Statement action;
    public BlockScope scope;

    public IteratorForStatement(LocalDeclaration localDeclaration, Expression collection, Statement action, int start, int end) {
        this.localDeclaration = localDeclaration;
        this.collection = collection;
        this.sourceStart = start;
        this.sourceEnd = end;
        this.action = action;
        if (action instanceof EmptyStatement) {
            action.bits |= 1;
        }
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return flowInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
    }

    public StringBuffer printStatement(int tab, StringBuffer output) {
        ASTNode.printIndent(tab, output).append("for (");
        this.localDeclaration.print(0, output);
        output.append(" : ");
        this.collection.print(0, output).append(") ");
        if (this.action == null) {
            output.append(';');
        } else {
            output.append('\n');
            this.action.printStatement(tab + 1, output);
        }
        return output;
    }

    public void resetStateForCodeGeneration() {
    }

    public void resolve(BlockScope upperScope) {
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.localDeclaration.traverse(visitor, this.scope);
            this.collection.traverse(visitor, this.scope);
            if (this.action != null) {
                this.action.traverse(visitor, this.scope);
            }
        }
        visitor.endVisit(this, blockScope);
    }
}

