/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.util.ArrayList;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.patterns.BasicToken;
import org.aspectj.weaver.patterns.IToken;
import org.aspectj.weaver.patterns.ITokenSource;

public class BasicTokenSource
implements ITokenSource {
    private int index = 0;
    private IToken[] tokens;
    private ISourceContext sourceContext;

    public BasicTokenSource(IToken[] tokens, ISourceContext sourceContext) {
        this.tokens = tokens;
        this.sourceContext = sourceContext;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int newIndex) {
        this.index = newIndex;
    }

    public IToken next() {
        try {
            return this.tokens[this.index++];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return IToken.EOF;
        }
    }

    public IToken peek() {
        try {
            return this.tokens[this.index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return IToken.EOF;
        }
    }

    public IToken peek(int offset) {
        try {
            return this.tokens[this.index + offset];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return IToken.EOF;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int i = 0;
        while (i < this.tokens.length) {
            IToken t = this.tokens[i];
            if (t == null) break;
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(t.toString());
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    static ITokenSource makeTokenSource(String input) {
        char[] chars = input.toCharArray();
        int i = 0;
        ArrayList<BasicToken> tokens = new ArrayList<BasicToken>();
        while (i < chars.length) {
            char ch = chars[i++];
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '!': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '.': 
                case ':': 
                case '[': 
                case ']': {
                    tokens.add(BasicToken.makeOperator(BasicTokenSource.makeString(ch), i - 1, i - 1));
                    break;
                }
                case '&': 
                case '|': {
                    char nextChar;
                    if (i == chars.length) {
                        throw new BCException("bad " + ch);
                    }
                    if ((nextChar = chars[i++]) == ch) {
                        tokens.add(BasicToken.makeOperator(BasicTokenSource.makeString(ch, 2), i - 2, i - 1));
                        break;
                    }
                    throw new RuntimeException("bad " + ch);
                }
                case '\"': {
                    int start0 = i - 1;
                    while (i < chars.length && chars[i] != '\"') {
                        ++i;
                    }
                    tokens.add(BasicToken.makeLiteral(new String(chars, start0 + 1, ++i - start0 - 2), "string", start0, i - 1));
                }
                default: {
                    int start = i - 1;
                    while (i < chars.length && Character.isJavaIdentifierPart(chars[i])) {
                        ++i;
                    }
                    tokens.add(BasicToken.makeIdentifier(new String(chars, start, i - start), start, i - 1));
                }
            }
        }
        return new BasicTokenSource(tokens.toArray(new IToken[tokens.size()]), null);
    }

    private static String makeString(char ch) {
        return new String(new char[]{ch});
    }

    private static String makeString(char ch, int count) {
        char[] chars = new char[count];
        int i = 0;
        while (i < count) {
            chars[i] = ch;
            ++i;
        }
        return new String(chars);
    }

    public ISourceContext getSourceContext() {
        return this.sourceContext;
    }
}

