/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.bridge;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.MessageUtil;

public class Message
implements IMessage {
    private final String message;
    private final IMessage.Kind kind;
    private final Throwable thrown;
    private final ISourceLocation sourceLocation;
    private final String details;
    private final List extraSourceLocations;

    public Message(String message, ISourceLocation location, boolean isError) {
        this(message, isError ? IMessage.ERROR : IMessage.WARNING, null, location);
    }

    public Message(String message, ISourceLocation location, boolean isError, ISourceLocation[] extraSourceLocations) {
        this(message, "", isError ? IMessage.ERROR : IMessage.WARNING, location, null, (ISourceLocation[])(extraSourceLocations.length > 0 ? extraSourceLocations : null));
    }

    public Message(String message, String details, IMessage.Kind kind, ISourceLocation sourceLocation, Throwable thrown, ISourceLocation[] extraSourceLocations) {
        this.details = details;
        this.message = message != null ? message : (thrown == null ? null : thrown.getMessage());
        this.kind = kind;
        this.sourceLocation = sourceLocation;
        this.thrown = thrown;
        this.extraSourceLocations = extraSourceLocations != null ? Collections.unmodifiableList(Arrays.asList(extraSourceLocations)) : Collections.EMPTY_LIST;
        if (null == this.kind) {
            throw new IllegalArgumentException("null kind");
        }
        if (null == this.message) {
            throw new IllegalArgumentException("null message");
        }
    }

    public Message(String message, IMessage.Kind kind, Throwable thrown, ISourceLocation sourceLocation) {
        this(message, "", kind, sourceLocation, thrown, null);
    }

    public IMessage.Kind getKind() {
        return this.kind;
    }

    public boolean isError() {
        return this.kind == IMessage.ERROR;
    }

    public boolean isWarning() {
        return this.kind == IMessage.WARNING;
    }

    public boolean isDebug() {
        return this.kind == IMessage.DEBUG;
    }

    public boolean isInfo() {
        return this.kind == IMessage.INFO;
    }

    public boolean isAbort() {
        return this.kind == IMessage.ABORT;
    }

    public boolean isFailed() {
        return this.kind == IMessage.FAIL;
    }

    public final String getMessage() {
        return this.message;
    }

    public final Throwable getThrown() {
        return this.thrown;
    }

    public final ISourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public String toString() {
        return MessageUtil.renderMessage(this, false);
    }

    public String getDetails() {
        return this.details;
    }

    public List getExtraSourceLocations() {
        return this.extraSourceLocations;
    }
}

