/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.index.impl.EntryResult;
import org.eclipse.jdt.internal.core.index.impl.IndexInput;
import org.eclipse.jdt.internal.core.index.impl.IndexedFile;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;

public class SuperTypeReferencePattern
extends SearchPattern {
    private static ThreadLocal indexRecord = new ThreadLocal(){

        protected Object initialValue() {
            return new SuperTypeReferencePattern(null, null, false, 4);
        }
    };
    public char[] superQualification;
    public char[] superSimpleName;
    public char superClassOrInterface;
    public char[] pkgName;
    public char[] simpleName;
    public char[] enclosingTypeName;
    public char classOrInterface;
    public int modifiers;
    protected boolean checkOnlySuperinterfaces;
    public HashMap entryResults;
    private static final EntryResult[] NO_ENTRY_RESULT = new EntryResult[0];

    public static char[] createIndexKey(int modifiers, char[] packageName, char[] typeName, char[][] enclosingTypeNames, char classOrInterface, char[] superTypeName, char superClassOrInterface) {
        char[] superTypeSourceName;
        SuperTypeReferencePattern record = SuperTypeReferencePattern.getSuperTypeReferenceRecord();
        record.modifiers = modifiers;
        record.pkgName = packageName;
        record.classOrInterface = classOrInterface;
        record.superClassOrInterface = superClassOrInterface;
        if (superTypeName == null) {
            superTypeName = IIndexConstants.OBJECT;
        }
        record.enclosingTypeName = CharOperation.concatWith(enclosingTypeNames, '$');
        record.simpleName = CharOperation.lastSegment(typeName, '.');
        record.superSimpleName = CharOperation.lastSegment(superTypeName, '.');
        record.superQualification = null;
        if (record.superSimpleName != superTypeName) {
            int length = superTypeName.length - record.superSimpleName.length - 1;
            record.superQualification = new char[length];
            System.arraycopy(superTypeName, 0, record.superQualification, 0, length);
        }
        if ((superTypeSourceName = CharOperation.lastSegment(record.superSimpleName, '$')) != record.superSimpleName) {
            int start = record.superQualification == null ? 0 : record.superQualification.length + 1;
            int prefixLength = record.superSimpleName.length - superTypeSourceName.length;
            char[] mangledQualification = new char[start + prefixLength];
            if (record.superQualification != null) {
                System.arraycopy(record.superQualification, 0, mangledQualification, 0, start - 1);
                mangledQualification[start - 1] = 46;
            }
            System.arraycopy(record.superSimpleName, 0, mangledQualification, start, prefixLength);
            record.superQualification = mangledQualification;
            record.superSimpleName = superTypeSourceName;
        }
        return record.encodeIndexKey();
    }

    public static SuperTypeReferencePattern getSuperTypeReferenceRecord() {
        return (SuperTypeReferencePattern)indexRecord.get();
    }

    public SuperTypeReferencePattern(char[] superQualification, char[] superSimpleName, int matchRule) {
        this(superQualification, superSimpleName, false, matchRule);
    }

    public SuperTypeReferencePattern(char[] superQualification, char[] superSimpleName, boolean checkOnlySuperinterfaces, int matchRule) {
        super(16, matchRule);
        boolean isCaseSensitive = this.isCaseSensitive();
        this.superQualification = isCaseSensitive ? superQualification : CharOperation.toLowerCase(superQualification);
        this.superSimpleName = isCaseSensitive ? superSimpleName : CharOperation.toLowerCase(superSimpleName);
        this.mustResolve = superQualification != null;
        this.checkOnlySuperinterfaces = checkOnlySuperinterfaces;
    }

    public void decodeIndexKey(char[] key) {
        int slash = -1;
        int n = slash + 1;
        slash = CharOperation.indexOf('/', key, slash + 1);
        this.superSimpleName = CharOperation.subarray(key, n, slash);
        int oldSlash = slash;
        this.superQualification = (slash = CharOperation.indexOf('/', key, slash + 1)) == oldSlash + 1 ? null : CharOperation.subarray(key, oldSlash + 1, slash);
        this.superClassOrInterface = key[slash + 1];
        int n2 = (slash += 2) + 1;
        slash = CharOperation.indexOf('/', key, slash + 1);
        this.simpleName = CharOperation.subarray(key, n2, slash);
        oldSlash = slash;
        this.enclosingTypeName = (char[])((slash = CharOperation.indexOf('/', key, slash + 1)) == oldSlash + 1 ? null : (slash == oldSlash + 2 && key[oldSlash + 1] == IIndexConstants.ONE_ZERO[0] ? IIndexConstants.ONE_ZERO : CharOperation.subarray(key, oldSlash + 1, slash)));
        oldSlash = slash;
        slash = CharOperation.indexOf('/', key, slash + 1);
        this.pkgName = slash == oldSlash + 1 ? null : CharOperation.subarray(key, oldSlash + 1, slash);
        this.classOrInterface = key[slash + 1];
        this.modifiers = key[slash + 2];
    }

    public char[] encodeIndexKey() {
        int superSimpleNameLength = this.superSimpleName == null ? 0 : this.superSimpleName.length;
        int superQualificationLength = this.superQualification == null ? 0 : this.superQualification.length;
        int simpleNameLength = this.simpleName == null ? 0 : this.simpleName.length;
        int enclosingTypeNameLength = this.enclosingTypeName == null ? 0 : this.enclosingTypeName.length;
        int pkgNameLength = this.pkgName == null ? 0 : this.pkgName.length;
        int length = superSimpleNameLength + superQualificationLength + simpleNameLength + enclosingTypeNameLength + pkgNameLength + 9;
        char[] result = new char[length];
        int pos = 0;
        if (superSimpleNameLength > 0) {
            System.arraycopy(this.superSimpleName, 0, result, pos, superSimpleNameLength);
            pos += superSimpleNameLength;
        }
        result[pos++] = 47;
        if (this.superClassOrInterface != '\u0000') {
            if (superQualificationLength > 0) {
                System.arraycopy(this.superQualification, 0, result, pos, superQualificationLength);
                pos += superQualificationLength;
            }
            result[pos++] = 47;
            result[pos++] = this.superClassOrInterface;
            result[pos++] = 47;
            if (simpleNameLength > 0) {
                System.arraycopy(this.simpleName, 0, result, pos, simpleNameLength);
                pos += simpleNameLength;
            }
            result[pos++] = 47;
            if (enclosingTypeNameLength > 0) {
                System.arraycopy(this.enclosingTypeName, 0, result, pos, enclosingTypeNameLength);
                pos += enclosingTypeNameLength;
            }
            result[pos++] = 47;
            if (pkgNameLength > 0) {
                System.arraycopy(this.pkgName, 0, result, pos, pkgNameLength);
                pos += pkgNameLength;
            }
            result[pos++] = 47;
            result[pos++] = this.classOrInterface;
            result[pos++] = (char)this.modifiers;
        }
        if (pos != length) {
            char[] cArray = result;
            result = new char[pos];
            System.arraycopy(cArray, 0, result, 0, pos);
        }
        return result;
    }

    public void findIndexMatches(IndexInput input, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor progressMonitor) throws IOException {
        if (this.entryResults == null) {
            super.findIndexMatches(input, requestor, participant, scope, progressMonitor);
            return;
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        EntryResult[] entries = (EntryResult[])this.entryResults.get(input);
        if (entries == null) {
            entries = input.queryEntriesPrefixedBy(IIndexConstants.SUPER_REF);
            if (entries == null) {
                entries = NO_ENTRY_RESULT;
            }
            this.entryResults.put(input, entries);
        }
        if (entries == NO_ENTRY_RESULT) {
            return;
        }
        int slash = IIndexConstants.SUPER_REF.length;
        char[] name = this.superSimpleName;
        int length = name == null ? 0 : name.length;
        int i = 0;
        int max = entries.length;
        while (i < max) {
            char[] word;
            EntryResult entry = entries[i];
            if (name != null) {
                word = entry.getWord();
                if (slash + length < word.length && word[length + slash] == '/') {
                    int j = 0;
                    while (j < length) {
                        if (word[j + slash] == name[j]) {
                            ++j;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                word = entry.getWord();
                char[] indexKey = CharOperation.subarray(word, IIndexConstants.SUPER_REF.length, word.length);
                SearchPattern record = this.getIndexRecord();
                record.decodeIndexKey(indexKey);
                int[] references = entry.getFileReferences();
                int iReference = 0;
                int refererencesLength = references.length;
                while (iReference < refererencesLength) {
                    String documentPath = IndexedFile.convertPath(input.getIndexedFile(references[iReference]).getPath());
                    if (scope.encloses(documentPath) && !requestor.acceptIndexMatch(documentPath, record, participant)) {
                        throw new OperationCanceledException();
                    }
                    ++iReference;
                }
            }
            ++i;
        }
    }

    public SearchPattern getIndexRecord() {
        return SuperTypeReferencePattern.getSuperTypeReferenceRecord();
    }

    public char[][] getMatchCategories() {
        return new char[][]{IIndexConstants.SUPER_REF};
    }

    public boolean isMatchingIndexRecord() {
        SuperTypeReferencePattern record = SuperTypeReferencePattern.getSuperTypeReferenceRecord();
        if (this.checkOnlySuperinterfaces && record.superClassOrInterface != 'I') {
            return false;
        }
        return this.matchesName(this.superSimpleName, record.superSimpleName);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append(this.checkOnlySuperinterfaces ? "SuperInterfaceReferencePattern: <" : "SuperTypeReferencePattern: <");
        if (this.superSimpleName != null) {
            buffer.append(this.superSimpleName);
        } else {
            buffer.append("*");
        }
        buffer.append(">, ");
        switch (this.matchMode()) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        if (this.isCaseSensitive()) {
            buffer.append("case sensitive");
        } else {
            buffer.append("case insensitive");
        }
        return buffer.toString();
    }
}

