/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.ObjectHeader;
import org.eclipse.core.internal.indexing.ObjectStoreException;
import org.eclipse.core.internal.indexing.ObjectStorePage;
import org.eclipse.core.internal.indexing.PageStore;
import org.eclipse.core.internal.indexing.Reservation;
import org.eclipse.core.internal.indexing.ReservationTable;
import org.eclipse.core.internal.indexing.StoredObject;

class ObjectPage
extends ObjectStorePage {
    protected static final int MaxEntries = 256;
    protected static final int ObjectDirectoryOffset = 64;
    protected static final int ObjectSpaceOffset = 576;
    protected static final int FlagOffset = 0;
    protected static final int UsedSpaceOffset = 2;
    protected static final int UsedEntriesOffset = 4;
    protected static final int InitialEntryOffset = 6;
    protected static final int FreeSpaceOffset = 8;
    public static final int ObjectSpaceSize = 7616;
    protected int usedSpace;
    protected int usedEntries;
    protected int freeSpaceOffset;
    protected int initialEntry;

    public ObjectPage(int pageNumber, byte[] buffer, PageStore pageStore) {
        super(pageNumber, buffer, pageStore);
    }

    public void toBuffer(byte[] buffer) {
        this.dematerialize();
        this.pageBuffer.copyTo(buffer);
    }

    protected void materialize() {
        int initialized = this.pageBuffer.getUInt(0, 2);
        if (initialized == 61166) {
            this.usedSpace = this.pageBuffer.getUInt(2, 2);
            this.usedEntries = this.pageBuffer.getUInt(4, 2);
            this.initialEntry = this.pageBuffer.getUInt(6, 2);
            this.freeSpaceOffset = this.pageBuffer.getUInt(8, 2);
        } else {
            this.usedSpace = 0;
            this.usedEntries = 0;
            this.initialEntry = 0;
            this.freeSpaceOffset = 576;
        }
    }

    protected void dematerialize() {
        this.pageBuffer.put(0, 2, 61166);
        this.pageBuffer.put(2, 2, this.usedSpace);
        this.pageBuffer.put(4, 2, this.usedEntries);
        this.pageBuffer.put(6, 2, this.initialEntry);
        this.pageBuffer.put(8, 2, this.freeSpaceOffset);
    }

    public Field getObjectField(int objectNumber) throws ObjectStoreException {
        int entryOffset = 64 + 2 * objectNumber;
        int blockOffset = this.pageBuffer.getUInt(entryOffset, 2);
        if (blockOffset == 0) {
            return null;
        }
        ObjectHeader header = new ObjectHeader(this.pageBuffer.get(blockOffset, 4));
        Field f = this.pageBuffer.getField(blockOffset + 4, header.getObjectLength());
        return f;
    }

    public void insertObject(StoredObject object) throws ObjectStoreException {
        int blockLength = object.length() + 4;
        if (this.getFreeSpace() < blockLength) {
            throw new ObjectStoreException(24);
        }
        int objectNumber = object.getAddress().getObjectNumber();
        int entryOffset = 64 + objectNumber * 2;
        int blockOffset = this.pageBuffer.getUInt(entryOffset, 2);
        if (blockOffset != 0) {
            throw new ObjectStoreException(22);
        }
        if (blockLength > 8192 - this.freeSpaceOffset) {
            this.compress();
        }
        blockOffset = this.freeSpaceOffset;
        ObjectHeader header = new ObjectHeader(object.length());
        this.pageBuffer.put(blockOffset, header);
        this.pageBuffer.put(blockOffset + 4, object.toByteArray());
        this.pageBuffer.put(entryOffset, 2, blockOffset);
        this.freeSpaceOffset += blockLength;
        this.usedSpace += blockLength;
        ++this.usedEntries;
        this.initialEntry = (objectNumber + 1) % 256;
        this.setChanged();
        this.notifyObservers();
    }

    public int reserveObject(StoredObject object, ReservationTable reservations) throws ObjectStoreException {
        int blockLength = object.length() + 4;
        if (this.getFreeSpace() < blockLength) {
            throw new ObjectStoreException(24);
        }
        Reservation r = reservations.get(this.pageNumber);
        if (r == null) {
            r = new Reservation(this.getFreeSpace(), 256 - this.usedEntries, this.initialEntry);
            reservations.put(this.pageNumber, r);
        }
        int objectNumber = r.getInitialEntry();
        int blockOffset = 0;
        int entryOffset = 0;
        int i = 0;
        while (i < 256) {
            if (!r.contains(objectNumber) && (blockOffset = this.pageBuffer.getUInt(entryOffset = 64 + objectNumber * 2, 2)) == 0) break;
            objectNumber = (objectNumber + 1) % 256;
            ++i;
        }
        if (blockOffset != 0) {
            throw new ObjectStoreException(22);
        }
        r.setInitialEntry((objectNumber + 1) % 256);
        r.add(objectNumber, blockLength);
        return objectNumber;
    }

    public void removeObject(int objectNumber) throws ObjectStoreException {
        int entryOffset = 64 + 2 * objectNumber;
        int blockOffset = this.pageBuffer.getUInt(entryOffset, 2);
        if (blockOffset == 0) {
            throw new ObjectStoreException(25);
        }
        this.pageBuffer.put(entryOffset, 2, 0);
        ObjectHeader h = new ObjectHeader(this.pageBuffer.get(blockOffset, 4));
        int objectLength = h.getObjectLength();
        int blockLength = objectLength + 4;
        this.pageBuffer.clear(blockOffset, blockLength);
        this.usedSpace -= blockLength;
        --this.usedEntries;
        this.setChanged();
        this.notifyObservers();
    }

    public void updateObject(StoredObject object) throws ObjectStoreException {
        int objectNumber = object.getAddress().getObjectNumber();
        int entryOffset = 64 + 2 * objectNumber;
        int blockOffset = this.pageBuffer.getUInt(entryOffset, 2);
        if (blockOffset == 0) {
            throw new ObjectStoreException(25);
        }
        ObjectHeader header = new ObjectHeader(this.pageBuffer.get(blockOffset, 4));
        if (header.getObjectLength() != object.length()) {
            throw new ObjectStoreException(24);
        }
        int objectOffset = blockOffset + 4;
        this.pageBuffer.put(objectOffset, object.toByteArray());
        this.setChanged();
        this.notifyObservers();
    }

    private void compress() throws ObjectStoreException {
        Buffer temp = new Buffer(8192);
        int newBlockOffset = 576;
        int entryOffset = 64;
        this.usedEntries = 0;
        int i = 0;
        while (i < 256) {
            int oldBlockOffset = this.pageBuffer.getUInt(entryOffset, 2);
            if (oldBlockOffset > 0) {
                ObjectHeader h = new ObjectHeader(this.pageBuffer.get(oldBlockOffset, 4));
                int blockLength = h.getObjectLength() + 4;
                temp.put(newBlockOffset, this.pageBuffer.get(oldBlockOffset, blockLength));
                this.pageBuffer.put(entryOffset, 2, newBlockOffset);
                newBlockOffset += blockLength;
                ++this.usedEntries;
            }
            entryOffset += 2;
            ++i;
        }
        this.pageBuffer.put(576, temp.get(576, 7616));
        this.freeSpaceOffset = newBlockOffset;
    }

    public int getFreeSpace() {
        if (this.usedEntries >= 256) {
            return 0;
        }
        return 8192 - (576 + this.usedSpace);
    }

    public boolean isObjectPage() {
        return true;
    }
}

