/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.registry.BundleModel;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.internal.runtime.AuthorizationDatabase;
import org.eclipse.core.internal.runtime.FindSupport;
import org.eclipse.core.internal.runtime.Log;
import org.eclipse.core.internal.runtime.PlatformLogWriter;
import org.eclipse.core.internal.runtime.PlatformMetaArea;
import org.eclipse.core.internal.runtime.PlatformMetaAreaLock;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.internal.runtime.SafeFileInputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPlatform;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public final class InternalPlatform
implements IPlatform {
    private BundleContext context;
    private IExtensionRegistry registry;
    private Plugin runtimeInstance;
    public static boolean cacheRegistry = true;
    public static boolean lazyRegistryCacheLoading = true;
    private static IAdapterManager adapterManager;
    static ServiceRegistration platformRegistration;
    static EnvironmentInfo infoService;
    private static Map regIndex;
    private static ArrayList logListeners;
    private static Map logs;
    private static PlatformLogWriter platformLog;
    private static PlatformMetaArea metaArea;
    private static boolean initialized;
    private static Runnable endOfInitializationHandler;
    private static IPath location;
    private ServiceTracker debugTracker;
    private DebugOptions options = null;
    private static String[] allArgs;
    private static String[] appArgs;
    private static String[] frameworkArgs;
    private static final String WORKSPACE = "workspace";
    private static boolean consoleLogEnabled;
    private static ILogListener consoleLog;
    private static AuthorizationDatabase keyring;
    private static String keyringFile;
    private static String password;
    private static boolean splashDown;
    private static String pluginCustomizationFile;
    private static URL installLocation;
    private static PlatformMetaAreaLock metaAreaLock;
    private static boolean doVersionCheck;
    private static boolean writeVersion;
    private static final String PLUGIN_CUSTOMIZATION_BASE_NAME = "plugin_customization";
    private static final String PLUGIN_CUSTOMIZATION_FILE_NAME = "plugin_customization.ini";
    private static final String OPTION_DEBUG = "org.eclipse.core.runtime/debug";
    private static final String OPTION_DEBUG_SYSTEM_CONTEXT = "org.eclipse.core.runtime/debug/context";
    private static final String OPTION_DEBUG_SHUTDOWN = "org.eclipse.core.runtime/timing/shutdown";
    private static final String OPTION_DEBUG_REGISTRY = "org.eclipse.core.runtime/registry/debug";
    private static final String OPTION_REGISTRY_CACHE_TIMING = "org.eclipse.core.runtime/registry/cache/timing";
    private static final String OPTION_DEBUG_REGISTRY_DUMP = "org.eclipse.core.runtime/registry/debug/dump";
    private static final String OPTION_DEBUG_PREFERENCES = "org.eclipse.core.runtime/preferences/debug";
    private static final String ARG_APPLICATION = "-application";
    private static final String ARG_DATA = "-data";
    private static final String ARG_INSTALL = "-install";
    private static final String LOG = "-consolelog";
    private static final String KEYRING = "-keyring";
    protected static final String PASSWORD = "-password";
    private static final String NOREGISTRYCACHE = "-noregistrycache";
    private static final String NO_LAZY_REGISTRY_CACHE_LOADING = "-noLazyRegistryCacheLoading";
    private static final String PLUGIN_CUSTOMIZATION = "-plugincustomization";
    private static final String NO_PACKAGE_PREFIXES = "-noPackagePrefixes";
    private static final String NO_VERSION_CHECK = "-noversioncheck";
    private static final String CLASSLOADER_PROPERTIES = "-classloaderProperties";
    public static boolean DEBUG;
    public static boolean DEBUG_CONTEXT;
    public static boolean DEBUG_REGISTRY;
    public static boolean DEBUG_STARTUP;
    public static boolean DEBUG_SHUTDOWN;
    public static String DEBUG_REGISTRY_DUMP;
    public static boolean DEBUG_PREFERENCES;
    private static final String KEY_PREFIX = "%";
    private static final String KEY_DOUBLE_PREFIX = "%%";
    public static final String INSTALL_LOCATION = "osgi.installLocation";
    private static final String METADATA_VERSION_KEY = "org.eclipse.core.runtime";
    private static final int METADATA_VERSION_VALUE = 1;
    private static final String PLUGIN_PATH = ".plugin-path";
    private static final InternalPlatform singleton;
    private IPath configMetadataLocation;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        regIndex = null;
        logListeners = new ArrayList(5);
        logs = new HashMap(5);
        platformLog = null;
        endOfInitializationHandler = null;
        allArgs = new String[0];
        appArgs = new String[0];
        frameworkArgs = new String[0];
        consoleLogEnabled = false;
        consoleLog = null;
        keyring = null;
        keyringFile = null;
        password = "";
        splashDown = false;
        pluginCustomizationFile = null;
        installLocation = null;
        metaAreaLock = null;
        doVersionCheck = true;
        writeVersion = true;
        DEBUG = false;
        DEBUG_CONTEXT = false;
        DEBUG_REGISTRY = false;
        DEBUG_STARTUP = false;
        DEBUG_SHUTDOWN = false;
        DEBUG_REGISTRY_DUMP = null;
        DEBUG_PREFERENCES = false;
        singleton = new InternalPlatform();
    }

    private InternalPlatform() {
    }

    public static InternalPlatform getDefault() {
        return singleton;
    }

    public void addAuthorizationInfo(URL serverUrl, String realm, String authScheme, Map info) throws CoreException {
        keyring.addAuthorizationInfo(serverUrl, realm, authScheme, new HashMap(info));
        keyring.save();
    }

    public void addLogListener(ILogListener listener) {
        this.assertInitialized();
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            logListeners.remove(listener);
            logListeners.add(listener);
        }
    }

    public void addProtectionSpace(URL resourceUrl, String realm) throws CoreException {
        keyring.addProtectionSpace(resourceUrl, realm);
        keyring.save();
    }

    public URL asLocalURL(URL url) throws IOException {
        if (url.getProtocol().equals("bundle2")) {
            URL localURL;
            String bundleName = url.getHost();
            Bundle bundle = this.context.getBundle(bundleName.substring(0, bundleName.indexOf(95)));
            if (bundle != null && (localURL = bundle.getEntry(url.getPath())) != null) {
                return localURL;
            }
            return url;
        }
        if (!url.getProtocol().equals("platform")) {
            return url;
        }
        URLConnection connection = url.openConnection();
        if (!(connection instanceof PlatformURLConnection)) {
            return url;
        }
        String file = connection.getURL().getFile();
        if (file.endsWith("/") && !file.endsWith("!/")) {
            throw new IOException();
        }
        return ((PlatformURLConnection)connection).getURLAsLocal();
    }

    private void assertInitialized() {
        if (!initialized) {
            Assert.isTrue(false, Policy.bind("meta.appNotInit"));
        }
    }

    private static synchronized void clearLockFile() {
        if (metaAreaLock != null) {
            metaAreaLock.release();
        }
    }

    private static synchronized void createLockFile() throws CoreException {
        if (System.getProperty("org.eclipse.core.runtime.ignoreLockFile") != null) {
            return;
        }
        String lockLocation = metaArea.getLocation().append(".lock").toOSString();
        metaAreaLock = new PlatformMetaAreaLock(new File(lockLocation));
        try {
            if (!metaAreaLock.acquire()) {
                String message = Policy.bind("meta.inUse", lockLocation);
                throw new CoreException(new Status(4, METADATA_VERSION_KEY, 5, message, null));
            }
        }
        catch (IOException e) {
            String message = Policy.bind("meta.failCreateLock", lockLocation);
            throw new CoreException(new Status(4, METADATA_VERSION_KEY, 5, message, e));
        }
    }

    public void endSplash() {
        String startString;
        if (DEBUG && (startString = System.getProperty("eclipse.debug.startupTime")) != null) {
            try {
                long start = Long.parseLong(startString);
                long end = System.currentTimeMillis();
                System.out.println("Startup complete: " + (end - start) + "ms");
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (splashDown) {
            return;
        }
        splashDown = true;
        this.run(endOfInitializationHandler);
    }

    public void flushAuthorizationInfo(URL serverUrl, String realm, String authScheme) throws CoreException {
        keyring.flushAuthorizationInfo(serverUrl, realm, authScheme);
        keyring.save();
    }

    public IAdapterManager getAdapterManager() {
        this.assertInitialized();
        if (adapterManager == null) {
            adapterManager = new AdapterManager();
        }
        return adapterManager;
    }

    public Map getAuthorizationInfo(URL serverUrl, String realm, String authScheme) {
        Map info = keyring.getAuthorizationInfo(serverUrl, realm, authScheme);
        return info == null ? null : new HashMap(info);
    }

    public boolean getBooleanOption(String option, boolean defaultValue) {
        String value = this.getOption(option);
        return value != null && value.equalsIgnoreCase("true") || defaultValue;
    }

    public int getIntegerOption(String option, int defaultValue) {
        String value = this.getOption(option);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public String[] getAllArgs() {
        return allArgs;
    }

    public String[] getAppArgs() {
        return appArgs;
    }

    public String[] getFrameworkArgs() {
        return frameworkArgs;
    }

    public String getOption(String option) {
        if (this.options != null) {
            return this.options.getOption(option);
        }
        return null;
    }

    public IJobManager getJobManager() {
        return JobManager.getInstance();
    }

    public IPath getLogFileLocation() {
        return this.getMetaArea().getLogLocation();
    }

    public IPath getLocation() {
        this.assertInitialized();
        return location;
    }

    public ILog getLog(Bundle bundle) {
        ILog result = (ILog)logs.get(bundle);
        if (result != null) {
            return result;
        }
        result = new Log(bundle);
        logs.put(bundle, result);
        return result;
    }

    public PlatformMetaArea getMetaArea() {
        return metaArea;
    }

    public String getProtectionSpace(URL resourceUrl) {
        return keyring.getProtectionSpace(resourceUrl);
    }

    private void handleException(ISafeRunnable code, Throwable e) {
        if (!(e instanceof OperationCanceledException)) {
            Status status;
            String pluginId = METADATA_VERSION_KEY;
            String message = Policy.bind("meta.pluginProblems", pluginId);
            if (e instanceof CoreException) {
                status = new MultiStatus(pluginId, 2, message, e);
                status.merge(((CoreException)e).getStatus());
            } else {
                status = new Status(4, pluginId, 2, message, e);
            }
            this.log(status);
        }
        code.handleException(e);
    }

    public IExtensionRegistry getRegistry() {
        return this.registry;
    }

    public boolean loaderCheckVersion() {
        boolean proceed;
        writeVersion = proceed = !doVersionCheck || this.checkVersionPrompt();
        if (!proceed) {
            this.endSplash();
        }
        return proceed;
    }

    public IPlatformRunnable loaderGetRunnable(String applicationName) {
        this.assertInitialized();
        IExtension extension = this.getRegistry().getExtension(METADATA_VERSION_KEY, "applications", applicationName);
        if (extension == null) {
            return null;
        }
        IConfigurationElement[] configs = extension.getConfigurationElements();
        if (configs.length == 0) {
            return null;
        }
        try {
            IConfigurationElement config = configs[0];
            return (IPlatformRunnable)config.createExecutableExtension("run");
        }
        catch (CoreException e) {
            this.getLog(this.context.getBundle()).log(e.getStatus());
            return null;
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            return null;
        }
    }

    public void start(BundleContext context) throws Exception {
        this.context = context;
        endOfInitializationHandler = this.getSplashHandler();
        this.processCommandLine(infoService.getAllArgs());
        this.setupMetaArea();
        InternalPlatform.createLockFile();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.osgi.service.debug.DebugOptions;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.debugTracker = new ServiceTracker(context, clazz.getName(), null);
        this.debugTracker.open();
        this.options = (DebugOptions)this.debugTracker.getService();
        this.initializeDebugFlags();
        initialized = true;
        platformLog = new PlatformLogWriter(metaArea.getLogLocation().toFile());
        this.addLogListener(platformLog);
        if (consoleLogEnabled) {
            consoleLog = new PlatformLogWriter(System.out);
            this.addLogListener(consoleLog);
        }
        this.loadKeyring();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Lorg.eclipse.core.runtime.IPlatform;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        platformRegistration = context.registerService(clazz2.getName(), (Object)this, null);
    }

    private Runnable getSplashHandler() {
        ServiceReference[] ref;
        try {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("[Ljava.lang.Runnable;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ref = this.context.getServiceReferences(clazz.getName(), null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
        int i = 0;
        while (i < ref.length) {
            String name = (String)ref[i].getProperty("name");
            if (name != null && name.equals("splashscreen")) {
                Runnable result = (Runnable)this.context.getService(ref[i]);
                this.context.ungetService(ref[i]);
                return result;
            }
            ++i;
        }
        return null;
    }

    private boolean checkVersionPrompt() {
        if (this.checkVersionNoPrompt()) {
            return true;
        }
        String appId = "org.eclipse.ui.versioncheck.prompt";
        IPlatformRunnable runnable = this.loaderGetRunnable(appId);
        if (runnable == null) {
            return true;
        }
        try {
            Object result = runnable.run(null);
            return Boolean.TRUE.equals(result);
        }
        catch (Exception exception) {
            this.log(new Status(4, METADATA_VERSION_KEY, 1, Policy.bind("meta.versionCheckRun", appId), null));
            return false;
        }
    }

    public void stop(BundleContext bundleContext) {
        this.assertInitialized();
        JobManager.getInstance().shutdown();
        this.debugTracker.close();
        if (writeVersion) {
            this.writeVersion();
        }
        InternalPlatform.clearLockFile();
        if (platformLog != null) {
            platformLog.shutdown();
        }
        initialized = false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkVersionNoPrompt() {
        File pluginsDir = metaArea.getLocation().append(".plugins").toFile();
        if (!pluginsDir.exists()) {
            return true;
        }
        int version = -1;
        File versionFile = metaArea.getVersionPath().toFile();
        if (!versionFile.exists()) return version == 1;
        try {
            Properties props = new Properties();
            FileInputStream is = new FileInputStream(versionFile);
            try {
                props.load(is);
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                is.close();
                throw throwable;
            }
            {
                Object var6_9 = null;
            }
            is.close();
            String prop = props.getProperty(METADATA_VERSION_KEY);
            if (prop == null) return version == 1;
            version = Integer.parseInt(prop);
            return version == 1;
        }
        catch (Exception e) {
            this.log(new Status(4, METADATA_VERSION_KEY, 1, Policy.bind("meta.checkVersion", versionFile.toString()), e));
        }
        return version == 1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeVersion() {
        File versionFile = metaArea.getVersionPath().toFile();
        try {
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(versionFile));
            try {
                String versionLine = "org.eclipse.core.runtime=1";
                ((OutputStream)output).write(versionLine.getBytes("UTF-8"));
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                ((OutputStream)output).close();
                throw throwable;
            }
            {
                Object var4_7 = null;
                ((OutputStream)output).close();
                return;
            }
        }
        catch (Exception e) {
            this.log(new Status(4, METADATA_VERSION_KEY, 1, Policy.bind("meta.writeVersion", versionFile.toString()), e));
        }
    }

    private void loadKeyring() {
        if (keyringFile != null) {
            try {
                keyring = new AuthorizationDatabase(keyringFile, password);
            }
            catch (CoreException e) {
                this.log(e.getStatus());
            }
            if (keyring == null) {
                new File(keyringFile).delete();
                try {
                    keyring = new AuthorizationDatabase(keyringFile, password);
                }
                catch (CoreException coreException) {}
            }
        }
        if (keyring == null) {
            keyring = new AuthorizationDatabase();
        }
    }

    void initializeDebugFlags() {
        DEBUG = this.getBooleanOption(OPTION_DEBUG, false);
        if (DEBUG) {
            DEBUG_CONTEXT = this.getBooleanOption(OPTION_DEBUG_SYSTEM_CONTEXT, false);
            DEBUG_SHUTDOWN = this.getBooleanOption(OPTION_DEBUG_SHUTDOWN, false);
            DEBUG_REGISTRY = this.getBooleanOption(OPTION_DEBUG_REGISTRY, false);
            DEBUG_REGISTRY_DUMP = this.getOption(OPTION_DEBUG_REGISTRY_DUMP);
            DEBUG_PREFERENCES = this.getBooleanOption(OPTION_DEBUG_PREFERENCES, false);
        }
    }

    public void log(final IStatus status) {
        ILogListener[] listeners;
        this.assertInitialized();
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            listeners = logListeners.toArray(new ILogListener[logListeners.size()]);
        }
        int i = 0;
        while (i < listeners.length) {
            final ILogListener listener = listeners[i];
            ISafeRunnable code = new ISafeRunnable(){

                public void run() throws Exception {
                    listener.logging(status, InternalPlatform.METADATA_VERSION_KEY);
                }

                public void handleException(Throwable e) {
                }
            };
            this.run(code);
            ++i;
        }
    }

    private String[] processCommandLine(String[] args) {
        if (args == null) {
            return args;
        }
        allArgs = args;
        int[] configArgs = new int[100];
        configArgs[0] = -1;
        int configArgIndex = 0;
        int i = 0;
        while (i < args.length) {
            boolean found = false;
            if (args[i].equalsIgnoreCase(LOG)) {
                consoleLogEnabled = true;
                found = true;
            }
            if (args[i].equalsIgnoreCase(NOREGISTRYCACHE)) {
                cacheRegistry = false;
                found = true;
            }
            if (args[i].equalsIgnoreCase(NO_LAZY_REGISTRY_CACHE_LOADING)) {
                lazyRegistryCacheLoading = false;
                found = true;
            }
            if (args[i].equalsIgnoreCase(NO_PACKAGE_PREFIXES)) {
                found = true;
            }
            if (args[i].equalsIgnoreCase(NO_VERSION_CHECK)) {
                doVersionCheck = false;
                found = true;
            }
            if (args[i].equalsIgnoreCase(CLASSLOADER_PROPERTIES)) {
                found = true;
            }
            if (found) {
                configArgs[configArgIndex++] = i;
            } else if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase(ARG_DATA)) {
                    location = new Path(arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(KEYRING)) {
                    keyringFile = arg;
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(PASSWORD)) {
                    password = arg;
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(ARG_APPLICATION)) {
                    System.setProperty("eclipse.application", arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(PLUGIN_CUSTOMIZATION)) {
                    pluginCustomizationFile = arg;
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(CLASSLOADER_PROPERTIES)) {
                    found = true;
                }
                if (found) {
                    configArgs[configArgIndex++] = i - 1;
                    configArgs[configArgIndex++] = i;
                }
            }
            ++i;
        }
        if (configArgIndex == 0) {
            appArgs = args;
            return args;
        }
        appArgs = new String[args.length - configArgIndex];
        frameworkArgs = new String[configArgIndex];
        configArgIndex = 0;
        int j = 0;
        int k = 0;
        int i2 = 0;
        while (i2 < args.length) {
            if (i2 == configArgs[configArgIndex]) {
                InternalPlatform.frameworkArgs[k++] = args[i2];
                ++configArgIndex;
            } else {
                InternalPlatform.appArgs[j++] = args[i2];
            }
            ++i2;
        }
        return appArgs;
    }

    public void removeLogListener(ILogListener listener) {
        this.assertInitialized();
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            logListeners.remove(listener);
        }
    }

    public URL resolve(URL url) throws IOException {
        if (!url.getProtocol().equals("platform")) {
            return url;
        }
        URLConnection connection = url.openConnection();
        if (connection instanceof PlatformURLConnection) {
            return ((PlatformURLConnection)connection).getResolvedURL();
        }
        return url;
    }

    public void run(ISafeRunnable code) {
        Assert.isNotNull(code);
        try {
            code.run();
        }
        catch (Exception e) {
            this.handleException(code, e);
        }
        catch (LinkageError e) {
            this.handleException(code, e);
        }
    }

    private void run(Runnable handler) {
        if (handler == null) {
            return;
        }
        final Runnable finalHandler = handler;
        ISafeRunnable code = new ISafeRunnable(){

            public void run() throws Exception {
                finalHandler.run();
            }

            public void handleException(Throwable e) {
            }
        };
        this.run(code);
    }

    public void setOption(String option, String value) {
        if (this.options != null) {
            this.options.setOption(option, value);
        }
    }

    private void setupMetaArea() throws CoreException {
        if (location == null) {
            location = new Path(System.getProperty("user.dir")).append(WORKSPACE);
        }
        if (!location.isAbsolute()) {
            location = new Path(System.getProperty("user.dir")).append(location);
        }
        if (location.toFile().exists() && !location.toFile().isDirectory()) {
            String message = Policy.bind("meta.notDir", location.toString());
            throw new CoreException(new Status(4, METADATA_VERSION_KEY, 5, message, null));
        }
        if (location.getDevice() == null) {
            location = new Path(location.toFile().getAbsolutePath());
        }
        metaArea = new PlatformMetaArea(location);
        metaArea.createLocation();
        if (keyringFile == null) {
            keyringFile = metaArea.getLocation().append(".keyring").toOSString();
        }
    }

    public void addLastModifiedTime(String pathKey, long lastModTime) {
        if (regIndex == null) {
            regIndex = new HashMap(30);
        }
        regIndex.put(pathKey, new Long(lastModTime));
    }

    public Map getRegIndex() {
        return regIndex;
    }

    public void clearRegIndex() {
        regIndex = null;
    }

    public Properties getPreferenceTranslator(String uniqueIdentifier, String basePrefFileName) {
        return new Properties();
    }

    public String translatePreference(String value, Properties props) {
        value = value.trim();
        if (props == null || value.startsWith(KEY_DOUBLE_PREFIX)) {
            return value;
        }
        if (value.startsWith(KEY_PREFIX)) {
            int ix = value.indexOf(" ");
            String key = ix == -1 ? value : value.substring(0, ix);
            String dflt = ix == -1 ? value : value.substring(ix + 1);
            return props.getProperty(key.substring(1), dflt);
        }
        return value;
    }

    public void applyPrimaryFeaturePluginDefaultOverrides(String id, Preferences preferences) {
    }

    public void applyCommandLinePluginDefaultOverrides(String id, Preferences preferences) {
        if (pluginCustomizationFile == null) {
            if (DEBUG_PREFERENCES) {
                System.out.println("Command line argument -pluginCustomization not used.");
            }
            return;
        }
        try {
            URL pluginCustomizationURL = new File(pluginCustomizationFile).toURL();
            if (DEBUG_PREFERENCES) {
                System.out.println("Loading preferences from " + pluginCustomizationURL);
            }
            this.applyPluginDefaultOverrides(pluginCustomizationURL, id, preferences, null);
        }
        catch (MalformedURLException e) {
            if (DEBUG_PREFERENCES) {
                System.out.println("MalformedURLException creating URL for plugin customization file " + pluginCustomizationFile);
                e.printStackTrace();
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void applyPluginDefaultOverrides(URL propertiesURL, String id, Preferences preferences, Properties props) {
        block24: {
            block23: {
                block22: {
                    block21: {
                        overrides = new Properties();
                        in = null;
                        try {
                            try {
                                inFile = new File(propertiesURL.getFile());
                                if (!inFile.exists()) {
                                    if (InternalPlatform.DEBUG_PREFERENCES) {
                                        System.out.println("Preference file " + propertiesURL + " not found.");
                                    }
                                    var8_9 = null;
                                    break block21;
                                }
                                in = new SafeFileInputStream(inFile);
                                if (in == null) {
                                    if (InternalPlatform.DEBUG_PREFERENCES) {
                                        System.out.println("Failed to open " + propertiesURL);
                                    }
                                    break block22;
                                }
                                overrides.load(in);
                                break block23;
                            }
                            catch (IOException e) {
                                if (InternalPlatform.DEBUG_PREFERENCES) {
                                    System.out.println("IOException reading preference file " + propertiesURL);
                                    e.printStackTrace();
                                }
                                var8_11 = null;
                                try {
                                    if (in == null) return;
                                    in.close();
                                    return;
                                }
                                catch (IOException e) {
                                    if (InternalPlatform.DEBUG_PREFERENCES == false) return;
                                    System.out.println("IOException closing preference file " + propertiesURL);
                                    e.printStackTrace();
                                }
                                return;
                            }
                        }
                        catch (Throwable var9_21) {
                            var8_12 = null;
                            ** try [egrp 2[TRYBLOCK] [5 : 181->194)] { 
lbl39:
                            // 1 sources

                            if (in == null) throw var9_21;
                            in.close();
                            throw var9_21;
lbl42:
                            // 1 sources

                            catch (IOException e) {
                                if (InternalPlatform.DEBUG_PREFERENCES == false) throw var9_21;
                                System.out.println("IOException closing preference file " + propertiesURL);
                                e.printStackTrace();
                            }
                            throw var9_21;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [5 : 181->194)] { 
lbl49:
                    // 1 sources

                    if (in == null) return;
                    in.close();
                    return;
lbl52:
                    // 1 sources

                    catch (IOException e) {
                        if (InternalPlatform.DEBUG_PREFERENCES == false) return;
                        System.out.println("IOException closing preference file " + propertiesURL);
                        e.printStackTrace();
                    }
                    return;
                }
                var8_10 = null;
                ** try [egrp 2[TRYBLOCK] [5 : 181->194)] { 
lbl60:
                // 1 sources

                if (in == null) return;
                in.close();
                return;
lbl63:
                // 1 sources

                catch (IOException e) {
                    if (InternalPlatform.DEBUG_PREFERENCES == false) return;
                    System.out.println("IOException closing preference file " + propertiesURL);
                    e.printStackTrace();
                }
                return;
            }
            var8_13 = null;
            ** try [egrp 2[TRYBLOCK] [5 : 181->194)] { 
lbl71:
            // 1 sources

            if (in != null) {
                in.close();
            }
            break block24;
lbl74:
            // 1 sources

            catch (IOException e) {
                if (!InternalPlatform.DEBUG_PREFERENCES) break block24;
                System.out.println("IOException closing preference file " + propertiesURL);
                e.printStackTrace();
            }
        }
        it = overrides.entrySet().iterator();
        while (true) {
            if (!it.hasNext()) break;
            entry = it.next();
            qualifiedKey = (String)entry.getKey();
            s = qualifiedKey.indexOf(47);
            if (s < 0 || s == 0 || s == qualifiedKey.length() - 1 || !(pluginId = qualifiedKey.substring(0, s)).equals(id)) continue;
            propertyName = qualifiedKey.substring(s + 1);
            value = (String)entry.getValue();
            value = this.translatePreference(value, props);
            preferences.setDefault(propertyName, value);
        }
        if (InternalPlatform.DEBUG_PREFERENCES == false) return;
        System.out.println("Preferences now set as follows:");
        prefNames = preferences.propertyNames();
        i = 0;
        while (true) {
            if (i >= prefNames.length) break;
            value = preferences.getString(prefNames[i]);
            System.out.println("\t" + prefNames[i] + " = " + value);
            ++i;
        }
        prefNames = preferences.defaultPropertyNames();
        i = 0;
        while (true) {
            if (i >= prefNames.length) {
                return;
            }
            value = preferences.getDefaultString(prefNames[i]);
            System.out.println("\tDefault values: " + prefNames[i] + " = " + value);
            ++i;
        }
    }

    public void setExtensionRegistry(IExtensionRegistry value) {
        this.registry = value;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public Bundle getBundle(String id) {
        return this.getBundleContext().getBundle(id);
    }

    public URL getInstallURL() {
        if (installLocation == null) {
            try {
                installLocation = new URL(System.getProperty(INSTALL_LOCATION));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return installLocation;
    }

    public EnvironmentInfo getEnvironmentInfoService() {
        return infoService;
    }

    public boolean isRunning() {
        int state = this.context.getBundle(METADATA_VERSION_KEY).getState();
        return state == 32;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL[] getPluginPath(URL pluginPathLocation) {
        InputStream input = null;
        if (pluginPathLocation == null) {
            return null;
        }
        try {
            input = pluginPathLocation.openStream();
        }
        catch (IOException iOException) {}
        if (input == null) {
            try {
                URL url = new URL("platform:/base/.plugin-path");
                input = url.openStream();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {}
        }
        if (input == null) {
            return null;
        }
        URL[] result = null;
        try {
            try {
                result = this.readPluginPath(input);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                input.close();
                throw throwable;
            }
            {
                Object var4_6 = null;
                input.close();
                return result;
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    private URL[] readPluginPath(InputStream input) {
        Properties ini = new Properties();
        try {
            ini.load(input);
        }
        catch (IOException iOException) {
            return null;
        }
        Vector<URL> result = new Vector<URL>(5);
        Enumeration<?> groups = ini.propertyNames();
        while (groups.hasMoreElements()) {
            String group = (String)groups.nextElement();
            StringTokenizer entries = new StringTokenizer(ini.getProperty(group), ";");
            while (entries.hasMoreElements()) {
                String entry = (String)entries.nextElement();
                if (entry.equals("")) continue;
                try {
                    result.addElement(new URL(entry));
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println(Policy.bind("ignore.plugin", entry));
                }
            }
        }
        return result.toArray(new URL[result.size()]);
    }

    public IPath getConfigurationMetadataLocation() {
        if (this.configMetadataLocation == null) {
            this.configMetadataLocation = new Path(System.getProperty("osgi.configuration.area"));
        }
        return this.configMetadataLocation;
    }

    public IPath getStateLocation(Bundle bundle, boolean create) {
        this.assertInitialized();
        IPath result = metaArea.getStateLocation(bundle);
        if (create) {
            result.toFile().mkdirs();
        }
        return result;
    }

    public URL find(Bundle b, IPath path) {
        return FindSupport.find(b, path);
    }

    public URL find(Bundle bundle, IPath path, Map override) {
        return FindSupport.find(bundle, path, override);
    }

    public InputStream openStream(Bundle bundle, IPath file) throws IOException {
        return FindSupport.openStream(bundle, file, false);
    }

    public InputStream openStream(Bundle bundle, IPath file, boolean localized) throws IOException {
        return FindSupport.openStream(bundle, file, localized);
    }

    public IPath getStateLocation(Bundle bundle) {
        return this.getStateLocation(bundle, true);
    }

    public ResourceBundle getResourceBundle(Bundle bundle) throws MissingResourceException {
        BundleModel model = (BundleModel)((ExtensionRegistry)this.getRegistry()).getElement(bundle.getGlobalName());
        return model != null ? model.getResourceBundle() : null;
    }

    public String getResourceString(Bundle bundle, String value) {
        BundleModel model = (BundleModel)((ExtensionRegistry)this.getRegistry()).getElement(bundle.getGlobalName());
        return model != null ? model.getResourceString(value) : value;
    }

    public String getResourceString(Bundle bundle, String value, ResourceBundle resourceBundle) {
        BundleModel model = (BundleModel)((ExtensionRegistry)this.getRegistry()).getElement(bundle.getGlobalName());
        return model != null ? model.getResourceString(value, resourceBundle) : value;
    }

    public String getOSArch() {
        return this.getEnvironmentInfoService().getOSArch();
    }

    public String getNL() {
        return this.getEnvironmentInfoService().getNL();
    }

    public String getOS() {
        return this.getEnvironmentInfoService().getOS();
    }

    public String getWS() {
        return this.getEnvironmentInfoService().getWS();
    }

    public String[] getApplicationArgs() {
        return this.getEnvironmentInfoService().getApplicationArgs();
    }

    public void setRuntimeInstance(Plugin runtime) {
        this.runtimeInstance = runtime;
    }

    public Plugin getRuntimeInstance() {
        return this.runtimeInstance;
    }
}

