/*
 * Copyright (c) 2017, 2021, Oracle and/or its affiliates.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2.0, as
 * published by the Free Software Foundation.
 *
 * This program is also distributed with certain software (including
 * but not limited to OpenSSL) that is licensed under separate terms,
 * as designated in a particular file or component or in included license
 * documentation.  The authors of MySQL hereby grant you an
 * additional permission to link the program and your derivative works
 * with the separately licensed software that they have included with
 * MySQL.
 *
 * Without limiting anything contained in the foregoing, this file,
 * which is part of MySQL Connector/Node.js, is also subject to the
 * Universal FOSS Exception, version 1.0, a copy of which can be found at
 * http://oss.oracle.com/licenses/universal-foss-exception.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License, version 2.0, for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
 */

/**
 * @fileoverview
 * @enhanceable
 * @suppress {messageConventions} JS Compiler reports an error if a variable or
 *     field starts with 'MSG_' and isn't a translatable message.
 * @public
 */
// GENERATED CODE -- DO NOT EDIT!

var jspb = require('google-protobuf');
var goog = jspb;
var global = Function('return this')();

var mysqlx_pb = require('./mysqlx_pb.js');
var mysqlx_datatypes_pb = require('./mysqlx_datatypes_pb.js');
goog.exportSymbol('proto.Mysqlx.Sql.StmtExecute', null, global);
goog.exportSymbol('proto.Mysqlx.Sql.StmtExecuteOk', null, global);

/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Sql.StmtExecute = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.Mysqlx.Sql.StmtExecute.repeatedFields_, null);
};
goog.inherits(proto.Mysqlx.Sql.StmtExecute, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  proto.Mysqlx.Sql.StmtExecute.displayName = 'proto.Mysqlx.Sql.StmtExecute';
}
/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.Mysqlx.Sql.StmtExecute.repeatedFields_ = [2];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto suitable for use in Soy templates.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     com.google.apps.jspb.JsClassTemplate.JS_RESERVED_WORDS.
 * @param {boolean=} opt_includeInstance Whether to include the JSPB instance
 *     for transitional soy proto support: http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Sql.StmtExecute.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Sql.StmtExecute.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Whether to include the JSPB
 *     instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Sql.StmtExecute} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Sql.StmtExecute.toObject = function(includeInstance, msg) {
  var f, obj = {
    namespace: jspb.Message.getFieldWithDefault(msg, 3, "sql"),
    stmt: msg.getStmt_asB64(),
    argsList: jspb.Message.toObjectList(msg.getArgsList(),
    mysqlx_datatypes_pb.Any.toObject, includeInstance),
    compactMetadata: jspb.Message.getFieldWithDefault(msg, 4, false)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Sql.StmtExecute}
 */
proto.Mysqlx.Sql.StmtExecute.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Sql.StmtExecute;
  return proto.Mysqlx.Sql.StmtExecute.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Sql.StmtExecute} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Sql.StmtExecute}
 */
proto.Mysqlx.Sql.StmtExecute.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 3:
      var value = /** @type {string} */ (reader.readString());
      msg.setNamespace(value);
      break;
    case 1:
      var value = /** @type {!Uint8Array} */ (reader.readBytes());
      msg.setStmt(value);
      break;
    case 2:
      var value = new mysqlx_datatypes_pb.Any;
      reader.readMessage(value,mysqlx_datatypes_pb.Any.deserializeBinaryFromReader);
      msg.addArgs(value);
      break;
    case 4:
      var value = /** @type {boolean} */ (reader.readBool());
      msg.setCompactMetadata(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Sql.StmtExecute.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Sql.StmtExecute.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Sql.StmtExecute} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Sql.StmtExecute.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = /** @type {string} */ (jspb.Message.getField(message, 3));
  if (f != null) {
    writer.writeString(
      3,
      f
    );
  }
  f = /** @type {!(string|Uint8Array)} */ (jspb.Message.getField(message, 1));
  if (f != null) {
    writer.writeBytes(
      1,
      f
    );
  }
  f = message.getArgsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      2,
      f,
      mysqlx_datatypes_pb.Any.serializeBinaryToWriter
    );
  }
  f = /** @type {boolean} */ (jspb.Message.getField(message, 4));
  if (f != null) {
    writer.writeBool(
      4,
      f
    );
  }
};


/**
 * optional string namespace = 3;
 * @return {string}
 */
proto.Mysqlx.Sql.StmtExecute.prototype.getNamespace = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 3, "sql"));
};


/** @param {string} value */
proto.Mysqlx.Sql.StmtExecute.prototype.setNamespace = function(value) {
  jspb.Message.setField(this, 3, value);
};


proto.Mysqlx.Sql.StmtExecute.prototype.clearNamespace = function() {
  jspb.Message.setField(this, 3, undefined);
};


/**
 * Returns whether this field is set.
 * @return {!boolean}
 */
proto.Mysqlx.Sql.StmtExecute.prototype.hasNamespace = function() {
  return jspb.Message.getField(this, 3) != null;
};


/**
 * required bytes stmt = 1;
 * @return {!(string|Uint8Array)}
 */
proto.Mysqlx.Sql.StmtExecute.prototype.getStmt = function() {
  return /** @type {!(string|Uint8Array)} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * required bytes stmt = 1;
 * This is a type-conversion wrapper around `getStmt()`
 * @return {string}
 */
proto.Mysqlx.Sql.StmtExecute.prototype.getStmt_asB64 = function() {
  return /** @type {string} */ (jspb.Message.bytesAsB64(
      this.getStmt()));
};


/**
 * required bytes stmt = 1;
 * Note that Uint8Array is not supported on all browsers.
 * @see http://caniuse.com/Uint8Array
 * This is a type-conversion wrapper around `getStmt()`
 * @return {!Uint8Array}
 */
proto.Mysqlx.Sql.StmtExecute.prototype.getStmt_asU8 = function() {
  return /** @type {!Uint8Array} */ (jspb.Message.bytesAsU8(
      this.getStmt()));
};


/** @param {!(string|Uint8Array)} value */
proto.Mysqlx.Sql.StmtExecute.prototype.setStmt = function(value) {
  jspb.Message.setField(this, 1, value);
};


proto.Mysqlx.Sql.StmtExecute.prototype.clearStmt = function() {
  jspb.Message.setField(this, 1, undefined);
};


/**
 * Returns whether this field is set.
 * @return {!boolean}
 */
proto.Mysqlx.Sql.StmtExecute.prototype.hasStmt = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * repeated Mysqlx.Datatypes.Any args = 2;
 * @return {!Array.<!proto.Mysqlx.Datatypes.Any>}
 */
proto.Mysqlx.Sql.StmtExecute.prototype.getArgsList = function() {
  return /** @type{!Array.<!proto.Mysqlx.Datatypes.Any>} */ (
    jspb.Message.getRepeatedWrapperField(this, mysqlx_datatypes_pb.Any, 2));
};


/** @param {!Array.<!proto.Mysqlx.Datatypes.Any>} value */
proto.Mysqlx.Sql.StmtExecute.prototype.setArgsList = function(value) {
  jspb.Message.setRepeatedWrapperField(this, 2, value);
};


/**
 * @param {!proto.Mysqlx.Datatypes.Any=} opt_value
 * @param {number=} opt_index
 * @return {!proto.Mysqlx.Datatypes.Any}
 */
proto.Mysqlx.Sql.StmtExecute.prototype.addArgs = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 2, opt_value, proto.Mysqlx.Datatypes.Any, opt_index);
};


proto.Mysqlx.Sql.StmtExecute.prototype.clearArgsList = function() {
  this.setArgsList([]);
};


/**
 * optional bool compact_metadata = 4;
 * Note that Boolean fields may be set to 0/1 when serialized from a Java server.
 * You should avoid comparisons like {@code val === true/false} in those cases.
 * @return {boolean}
 */
proto.Mysqlx.Sql.StmtExecute.prototype.getCompactMetadata = function() {
  return /** @type {boolean} */ (jspb.Message.getFieldWithDefault(this, 4, false));
};


/** @param {boolean} value */
proto.Mysqlx.Sql.StmtExecute.prototype.setCompactMetadata = function(value) {
  jspb.Message.setField(this, 4, value);
};


proto.Mysqlx.Sql.StmtExecute.prototype.clearCompactMetadata = function() {
  jspb.Message.setField(this, 4, undefined);
};


/**
 * Returns whether this field is set.
 * @return {!boolean}
 */
proto.Mysqlx.Sql.StmtExecute.prototype.hasCompactMetadata = function() {
  return jspb.Message.getField(this, 4) != null;
};



/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Sql.StmtExecuteOk = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Mysqlx.Sql.StmtExecuteOk, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  proto.Mysqlx.Sql.StmtExecuteOk.displayName = 'proto.Mysqlx.Sql.StmtExecuteOk';
}


if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto suitable for use in Soy templates.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     com.google.apps.jspb.JsClassTemplate.JS_RESERVED_WORDS.
 * @param {boolean=} opt_includeInstance Whether to include the JSPB instance
 *     for transitional soy proto support: http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Sql.StmtExecuteOk.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Sql.StmtExecuteOk.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Whether to include the JSPB
 *     instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Sql.StmtExecuteOk} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Sql.StmtExecuteOk.toObject = function(includeInstance, msg) {
  var f, obj = {

  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Sql.StmtExecuteOk}
 */
proto.Mysqlx.Sql.StmtExecuteOk.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Sql.StmtExecuteOk;
  return proto.Mysqlx.Sql.StmtExecuteOk.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Sql.StmtExecuteOk} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Sql.StmtExecuteOk}
 */
proto.Mysqlx.Sql.StmtExecuteOk.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Sql.StmtExecuteOk.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Sql.StmtExecuteOk.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Sql.StmtExecuteOk} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Sql.StmtExecuteOk.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
};


goog.object.extend(exports, proto.Mysqlx.Sql);
