/*
 * Copyright (c) 2018, 2021, Oracle and/or its affiliates.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2.0, as
 * published by the Free Software Foundation.
 *
 * This program is also distributed with certain software (including
 * but not limited to OpenSSL) that is licensed under separate terms,
 * as designated in a particular file or component or in included license
 * documentation.  The authors of MySQL hereby grant you an
 * additional permission to link the program and your derivative works
 * with the separately licensed software that they have included with
 * MySQL.
 *
 * Without limiting anything contained in the foregoing, this file,
 * which is part of MySQL Connector/Node.js, is also subject to the
 * Universal FOSS Exception, version 1.0, a copy of which can be found at
 * http://oss.oracle.com/licenses/universal-foss-exception.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License, version 2.0, for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
 */

'use strict';

const Expr = require('../../../../Protocol/Stubs/mysqlx_expr_pb').Expr;
const Operator = require('../../../../Protocol/Stubs/mysqlx_expr_pb').Operator;
const Scalar = require('../../../../Protocol/Stubs/mysqlx_datatypes_pb').Scalar;
const Pa = require('parsimmon');

const parser = options => r => Pa
    .seq(r.IS.skip(r.blank), r.optNotSuffix, Pa.alt(r.NULL, r.TRUE, r.FALSE))
    .map(data => ({ operator: data[0] + data[1], operand: data[2] }))
    .map(data => {
        const operator = new Operator();
        operator.setName(data.operator);

        const scalar = new Scalar();

        if (data.operand !== null) {
            scalar.setType(Scalar.Type.V_BOOL);
            scalar.setVBool(data.operand);
        } else {
            scalar.setType(Scalar.Type.V_NULL);
        }

        const param = new Expr();
        param.setType(Expr.Type.LITERAL);
        param.setLiteral(scalar);

        operator.addParam(param);

        return operator;
    });

module.exports = { name: 'IS_PARTIAL', parser };
