dnl
dnl $Id: config.m4,v 1.25 2006/10/09 04:46:03 georg Exp $
dnl config.m4 for extension mysqli

PHP_ARG_WITH(mysqli, for MySQLi support,
[  --with-mysqli[=FILE]    Include MySQLi support. FILE is the optional pathname 
                          to mysql_config])

PHP_ARG_ENABLE(embedded_mysqli, whether to enable embedded MySQLi support,
[  --enable-embedded-mysqli  MYSQLi: Enable embedded support], no, no)

if test -z "$PHP_MYSQLND"; then
  PHP_ARG_ENABLE(mysqlnd, whether to enable MySQL native driver support,
  [  --enable-mysqlnd          MYSQLi: Enable MySQL native driver supprt], no, no)
fi

dnl If some extension uses mysqlnd it will get compiled in PHP whether MYSQLi is enabled or not.
if test "$PHP_MYSQLND" = "yes"; then
  AC_DEFINE(HAVE_MYSQLND, 1, [MySQL native driver support enabled])
  mysqlnd_sources="mysqlnd.c mysqlnd_charset.c mysqlnd_wireprotocol.c \
                   mysqlnd_ps.c mysqlnd_loaddata.c mysqlnd_palloc.c \
                   mysqlnd_ps_codec.c mysqlnd_statistics.c mysqlnd_qcache.c"

  PHP_ADD_SOURCES(ext/mysqli/mysqlnd, $mysqlnd_sources)
  PHP_ADD_BUILD_DIR([ext/mysqli/mysqlnd])
  PHP_INSTALL_HEADERS([ext/mysqli/mysqlnd])
fi

if test "$PHP_MYSQLI" != "no" && test "$PHP_MYSQLND" != "yes"; then

  if test "$PHP_MYSQLI" = "yes"; then
    MYSQL_CONFIG=`$php_shtool path mysql_config`
  else
    MYSQL_CONFIG=$PHP_MYSQLI
  fi

  MYSQL_LIB_NAME='mysqlclient'
  if test "$PHP_EMBEDDED_MYSQLI" = "yes"; then
    AC_DEFINE(HAVE_EMBEDDED_MYSQLI, 1, [embedded MySQL support enabled])
    MYSQL_LIB_CFG='--libmysqld-libs'
    dnl mysqlnd doesn't support embedded, so we have to add some extra stuff
    extra_sources="mysqli_embedded.c"
  elif test "$enable_maintainer_zts" = "yes"; then
    MYSQL_LIB_CFG='--libs_r'
    MYSQL_LIB_NAME='mysqlclient_r'
  else
    MYSQL_LIB_CFG='--libs'
  fi
  
  if test -x "$MYSQL_CONFIG" && $MYSQL_CONFIG $MYSQL_LIB_CFG > /dev/null 2>&1; then
    MYSQLI_INCLINE=`$MYSQL_CONFIG --cflags | $SED -e "s/'//g"`
    MYSQLI_LIBLINE=`$MYSQL_CONFIG $MYSQL_LIB_CFG | $SED -e "s/'//g"`
  else
    AC_MSG_RESULT([mysql_config not found])
    AC_MSG_ERROR([Please reinstall the mysql distribution])
  fi

  dnl
  dnl Check the library
  dnl
  PHP_CHECK_LIBRARY($MYSQL_LIB_NAME, mysql_set_server_option,
  [
    PHP_EVAL_INCLINE($MYSQLI_INCLINE)
    PHP_EVAL_LIBLINE($MYSQLI_LIBLINE, MYSQLI_SHARED_LIBADD)
    AC_DEFINE(HAVE_MYSQLILIB, 1, [ ])
    PHP_CHECK_LIBRARY($MYSQL_LIB_NAME, mysql_set_character_set,
    [ ],[
      AC_MSG_ERROR([MySQLI doesn't support versions < 4.1.13 (for MySQL 4.1.x) and < 5.0.7 for (MySQL 5.0.x) anymore. Please update your libraries.])
    ],[$MYSQLI_LIBLINE])
  ],[
    AC_MSG_ERROR([wrong mysql library version or lib not found. Check config.log for more information.])
  ],[
    $MYSQLI_LIBLINE
  ])

  extra_sources="$extra_sources mysqli_repl.c"
fi

if test -n "$extra_sources" || test "$PHP_MYSQLI" != "no"; then
  mysqli_sources="mysqli.c mysqli_api.c mysqli_prop.c mysqli_nonapi.c \
                  mysqli_fe.c mysqli_report.c mysqli_driver.c mysqli_warning.c \
                  mysqli_exception.c $extra_sources"
  PHP_NEW_EXTENSION(mysqli, $mysqli_sources, $ext_shared)
  PHP_SUBST(MYSQLI_SHARED_LIBADD)
fi
