/*
  +----------------------------------------------------------------------+
  | PHP Version 6                                                        |
  +----------------------------------------------------------------------+
  | Copyright (c) 2006-2007 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.01 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | http://www.php.net/license/3_01.txt                                  |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Authors: Georg Richter <georg@mysql.com>                             |
  |          Andrey Hristov <andrey@mysql.com>                           |
  |          Ulf Wendel <uwendel@mysql.com>                              |
  +----------------------------------------------------------------------+
*/

/* $Id: header,v 1.17 2006/01/01 13:09:48 sniper Exp $ */
#ifndef MYSQLND_PALLOC_H
#define MYSQLND_PALLOC_H

/* Session caching allocator */
struct st_mysqlnd_zval_list {
	zval 	**ptr_line;
	zval	**last_added;
};

typedef struct st_mysqlnd_zval_cache	MYSQLND_ZVAL_CACHE;

struct st_mysqlnd_zval_cache {
	struct st_mysqlnd_zval_list	*free_list;
	unsigned int		free_items;
	unsigned int		max_items;
	unsigned int		references;
	unsigned long		get_hits;
	unsigned long		get_misses;
	unsigned long		put_hits;
	unsigned long		put_full_misses;
	unsigned long		put_refcount_misses;
};


/* Persistent caching allocator */
typedef struct st_mysqlnd_zval {
	/* Should be first */
	zval		zv;
	zend_bool	copy_alloced_on_result_free;
} mysqlnd_zval;


typedef struct st_mysqlnd_ndzval_list {
	mysqlnd_zval 	**ptr_line;
	mysqlnd_zval	**last_added;
} mysqlnd_ndzval_list;


struct st_mysqlnd_zval_pcache {
	mysqlnd_zval		*block;
	mysqlnd_zval		*last_in_block;
	mysqlnd_ndzval_list	*free_list;
	unsigned int		free_items;
	unsigned int		max_items;
	unsigned int		references;

	unsigned long		get_hits;
	unsigned long		get_misses;
	unsigned long		put_hits;
	unsigned long		put_misses;
#ifdef ZTS
	MUTEX_T 			LOCK_access;
#endif
};


#endif /* MYSQLND_PALLOC_H */
