--TEST--
$res->fetch_field_direct(s)
--SKIPIF--
<?php require_once('skipif.inc'); ?>
<?php require_once('skipifemb.inc'); ?>
--FILE--
<?php
    include "connect.inc";

    $tmp    = NULL;
    $link   = NULL;
    
    $mysqli = new mysqli();    
    $res = @new mysqli_result($mysqli);
    if (!is_null($tmp = @$res->fetch_field_direct()))
        printf("[001] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);    

    require('table.inc');
    
    if (!$mysqli = new mysqli($host, $user, $passwd, $db, $port, $socket))
        printf("[002] Cannot connect to the server using host=%s, user=%s, passwd=***, dbname=%s, port=%s, socket=%s\n",
            $host, $user, $db, $port, $socket);

    if (!$res = $mysqli->query("SELECT id AS ID, label FROM test AS TEST ORDER BY id LIMIT 1")) {
        printf("[003] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
    }
    
    if (!is_null($tmp = @$res->fetch_field_direct()))
        printf("[004] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);    
    
    if (!is_null($tmp = @$res->fetch_field_direct($link)))
        printf("[005] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);

    if (!is_null($tmp = @$res->fetch_field_direct($link, $link)))
        printf("[006] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);

    var_dump($res->fetch_field_direct(-1));
    var_dump($res->fetch_field_direct(0));
    var_dump($res->fetch_field_direct(2));

    $res->free_result();
    
    if (NULL !== ($tmp = $res->fetch_field_direct(0)))
        printf("[007] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);
    
    $mysqli->close();
    print "done!";
?>
--EXPECTF--
Warning: mysqli_result::fetch_field_direct(): Field offset is invalid for resultset in %s on line %d
bool(false)
object(stdClass)#%d (11) {
  ["name"]=>
  string(2) "ID"
  ["orgname"]=>
  string(2) "id"
  ["table"]=>
  string(4) "TEST"
  ["orgtable"]=>
  string(4) "test"
  ["def"]=>
  string(0) ""
  ["max_length"]=>
  int(%d)
  ["length"]=>
  int(11)
  ["charsetnr"]=>
  int(%d)
  ["flags"]=>
  int(%d)
  ["type"]=>
  int(%d)
  ["decimals"]=>
  int(%d)
}

Warning: mysqli_result::fetch_field_direct(): Field offset is invalid for resultset in %s on line %d
bool(false)

Warning: mysqli_result::fetch_field_direct(): Couldn't fetch mysqli_result in %s on line %d
done!
--UEXPECTF--
Warning: mysqli_result::fetch_field_direct(): Field offset is invalid for resultset in %s on line %d
bool(false)
object(stdClass)#%d (11) {
  [u"name"]=>
  unicode(2) "ID"
  [u"orgname"]=>
  unicode(2) "id"
  [u"table"]=>
  unicode(4) "TEST"
  [u"orgtable"]=>
  unicode(4) "test"
  [u"def"]=>
  unicode(0) ""
  [u"max_length"]=>
  int(%d)
  [u"length"]=>
  int(%d)
  [u"charsetnr"]=>
  int(%d)
  [u"flags"]=>
  int(%d)
  [u"type"]=>
  int(%d)
  [u"decimals"]=>
  int(%d)
}

Warning: mysqli_result::fetch_field_direct(): Field offset is invalid for resultset in %s on line %d
bool(false)

Warning: mysqli_result::fetch_field_direct(): Couldn't fetch mysqli_result in %s on line %d
done!
