#include <stdio.h>
#include <FSextend.h>
#include <mysql.h>
#include <stdlib.h>
#include "sqlmy.h"
#include "dbf.h"

char errores[100];

/*************************************************************/
/* OPEN a MySQL database
 * A UDF to connect to a MySQL database
 *
 * PARAMETERS : One is required - the name of the database
 *
 * open_my(db, host, user, pass, port, unixsock, flags)       */

FSudfname( open_my)
{
  char *db_name, *my_host, *my_user, *my_pass, *my_unixsock;
  int my_port, my_flags;

  int i;

  FSinit();
  err_log = getenv("MY_ERROR_LOG");
  verbosity = atoi(getenv("MY_LEVEL_VERBOSITY"));
  /*if (PCOUNT != 1 || _parinfo (1) != CHARACTER)*/
  if (PCOUNT < 1 || _parinfo (1) != CHARACTER)
    {
      pr_error("open_my() requires at least db name");
      _retni (-1);
      FSreturn;
    }

/* Verify the number of arguments */

  if (PCOUNT > 7) {
    pr_error("The number of argument is exceded");
    _retni(-1);
    FSreturn;
  }

/* initialize the variable to standard values  */

  my_host = "localhost";
  my_user = "";
  my_pass = "";
  my_port = 3306;
  my_unixsock = "";
  my_flags = 0;

/* set the variable depending on the arguments pass it */

  for(i=1;i<=PCOUNT;i++){
    switch (i) {
      case 1: /* database name */
        db_name= _parc(i);
        break;
      case 2:  /* user name */
        my_host= _parc(i);
        break;
      case 3:  /* user name */
        my_user= _parc(i);
        break;
      case 4:  /* password if set, if not null */
        my_pass= _parc(i);
        break;
      case 5:  /* port number */
        my_port= _parni(i);
        break;
      case 6:  /* unix socket file name */
        my_unixsock= _parc(i);
        break;
      case 7:  /* flags */
        my_flags= _parni(7);
        break;
    }
  }

  /* only one open connection is allowed per session */
  if (IsOpen) {
    pr_error("Attempt to open a database twice.");
    _retni(-1);
    FSreturn;
  }

  if(!mysql_init(&conn)) {
    pr_error("Cannot create the conection structure.");
    _retni(-1);
    FSreturn;
  }

  mysql_real_connect(&conn,my_host,my_user,my_pass,db_name,my_port,my_unixsock,my_flags);
  if (verifica(&conn)){
    _retni(-1);
    FSreturn;
  }
  if (verbosity > 2){
    sprintf(errores, "User %s opened : %s db", getenv("USER"),conn.db);
    pr_error(errores);
  }

  _retni (0);
  FSreturn;
}

/*************************************************************/
/* CLOSE a My-SQL database */
FSudfname( close_my)
{
  FSinit();
  err_log = getenv("MY_ERROR_LOG");
  verbosity = atoi(getenv("MY_LEVEL_VERBOSITY"));
  if (verbosity > 2){
    sprintf(errores, "User %s closed : %s db\n", getenv("USER"),conn.db);
    pr_error(errores);
  }
  mysql_close(&conn);
  IsOpen = 0;
  FSreturn;
}

/*************************************************************/
/* RETRIEVE tuples from a My-SQL database 
 *
 *   Four parameters are required.
 *
 *      type_of_retrieve              input parameter
 *                       0: Retrieve the result row-by-row
 *                       1: Retrieve the entire result
 *
 *      select_statement              input parameter
 *
 *      pointer to temp_file_name     output parameter
 *
 *      pointer to number_of_fields   output parameter
 *
 *   Return value : number_of_tuples
 *
 */
FSudfname( ret_my )
{
  char *sel_statement, *retrieve_dir, *err_log;
  char cmd[3000];
  unsigned char garbage[5];
  char tfilename[80];
  int nFields, nRows, i, j, pid, type_of_retrieve;
  static int RelCount = 0;
  FILE *tfp;
  char *ctime();
  long time(), now;
  MYSQL_RES *result; 
  MYSQL_ROW tuple;
  MYSQL_FIELD *fields;

  FSinit();

  err_log = getenv("MY_ERROR_LOG");
  verbosity = atoi(getenv("MY_LEVEL_VERBOSITY"));
  if (PCOUNT != 4 || _parinfo(1) != CHARACTER)
    {
      pr_error("ret_my() requires three parameters");
      _retni(-1);
      FSreturn;
    }

  sel_statement = _parc(1);
  type_of_retrieve = _parni(2);
  if(verbosity>2){
    sprintf(errores, "User %s executed : %s db\n", getenv("USER"),sel_statement);
    pr_error(errores);
  }

  mysql_query(&conn,sel_statement);
  if (verifica(&conn)){
    _retni(-1);
    FSreturn;
  }

  /* verify the type of retrieve*/

  if (type_of_retrieve){
	 result=mysql_store_result(&conn);
  }
  else {
	result=mysql_use_result(&conn);
  }

  if (verifica(&conn)){
    _retni(-1);
    FSreturn;
  }
  nFields=mysql_num_fields(result);


  /* store number of fields in third parameter */
  _storni( (long)nFields, 4 );

  /* make temp retrieved-records file */
  retrieve_dir = getenv("MY_RETRIEVE_DIR");
  if (retrieve_dir == NULL) retrieve_dir="";
  pid = getpid();
#ifdef TMP_FILE_TXT
  sprintf( tfilename, "%s%s%d%c%d", retrieve_dir, "myselect",
  ++RelCount, '.', pid); 
#else
  sprintf( tfilename, "%s%s%d%d%c%s", retrieve_dir, "myselect",
  ++RelCount,pid, '.', "dbf"); 
#endif
  _storc(tfilename,3);

  tfp = fopen( tfilename, "w" );
  if (tfp == NULL){
    pr_error("unable to open tmp file in ret_my()");
    _retni(-1);
    FSreturn;
  }

  fields=mysql_fetch_fields(result);
#ifdef TMP_FILE_TXT
  nRows=write_in_txt(tfp,result);
#else
  nRows=write_in_dbf(tfp,result);
#endif
  fclose( tfp );  /* close the temporary text file */
  mysql_free_result(result); /* frees the memory asociated with result */
  if(nRows==-1) { 
    _retni(-1);
    FSreturn;
  }

 
  /*We put in the structure the number of Rows */
  tfp = fopen( tfilename, "r+" );
  if (tfp == NULL){
    pr_error("unable to open tmp file in ret_my()");
    _retni(-1);
    FSreturn;
  }
  _retni( nRows );   /* return number of records retrieved */
  FSreturn;
}

/*Function: verifica(), verify if the excecuted SQL instruction
  it's OK. If true return 0, else return -1 recording the problem
  in its error log, if any. It's up to the programmer abort or not
  when status is -1 is received */

int verifica(MYSQL *mysql){
  if(mysql_errno(mysql)){
    sprintf(errores,"Error: %s",mysql_error(mysql));
    pr_error(errores);
  }
  return 0;
}


/*************************************************************/
/* EXEC a My-SQL SQL command
 *
 * may be used for all SQL commands execept SELECT
 *
 * PARAMETERS : one required : the SQL string
 *
 */
FSudfname( exec_my )
{
  char *cmd;
  char *ctime(), *err_log;
  long time(), now, affected_rows;

  FSinit();
  err_log = getenv("MY_ERROR_LOG");
  verbosity = atoi(getenv("MY_LEVEL_VERBOSITY"));

  if (PCOUNT != 1 || _parinfo (1) != CHARACTER)
    {
      pr_error("exec_my() requires a parameter");
      _retni (-1);
      FSreturn;
    }

  cmd = _parc(1);  

  mysql_query(&conn,cmd);
  if (verifica(&conn)){
    _retni(-1);
    FSreturn;
  }
  affected_rows=mysql_affected_rows(&conn);

  if (verbosity > 2){
    sprintf(errores, "User %s executed : %s db", getenv("USER"),cmd);
    pr_error(errores);
  }

  _retni (affected_rows);
  FSreturn;
}
int write_in_txt(FILE *tfp, MYSQL_RES *result)
{
  int nFields, nRows,j;
  MYSQL_ROW  tuple;
  unsigned char i=0;

  nRows=0;
  nFields=mysql_num_fields(result);
  for(j=0;j<nFields;j++) fprintf(tfp, "%d |",
           result->fields[j].type);
  while ((tuple=mysql_fetch_row(result))){
      
    for(j=0;j<nFields;j++) fprintf(tfp, "%s|", tuple[j]);
    fprintf(tfp, "\n");
    nRows++;
  }
  if(!mysql_eof(result)) {  // mysql_fetch_row() failed due to an error
    sprintf(errores, "Error: %s", mysql_error(&conn));
    pr_error(errores);
    nRows=DB_ERROR;
  }
  return nRows;
}
