/******************************************************************************
	  CCCC	    A	  BBBBB	  L	EEEEE  N     N	EEEEE	TTTTTTT
	 C    C    A A	  B    B  L	E      NN    N	E	   T
	C	  A   A	  B    B  L	E      N N   N	E	   T
	C	 AAAAAAA  BBBBB	  L	EEEEE  N  N  N	EEEEE	   T
	C        A     A  B    B  L	E      N   N N	E	   T
	 C    C  A     A  B    B  L	E      N    NN  E 	   T
	  CCCC	 A     A  BBBBB	  LLLL	EEEEE  N     N	EEEEE	   T
*******************************************************************************

CableNet Source Module:
	Copyright 1994-1995 (C) CableNet Limited. All Rights Reserved.

    Module Name:		$RCSfile: Vlib.h,v $
    Module Description:	Virtual library header file


Description: 


Edit History:

	$Log: Vlib.h,v $
 * Revision 3.3  1997/08/20  10:54:27  damian
 * remove the defaults stuff (now in dflts.h)
 *
 * Revision 3.2  1996/11/29  11:36:15  damian
 * declare extern Vprogram
 *
 * Revision 3.1  1996/11/29  10:50:51  damian
 * define Vstrerror depending on system
 *
 * Revision 2.4  1996/02/02  12:16:52  damian
 * add LockFile function prototypes
 *
 * Revision 2.3  1996/01/11  11:46:51  V
 * add DfltGetBool() prototype
 *
 * Revision 2.2  1996/01/04  12:41:25  V
 * include Vansi.h, change char arg to int FindArgInfo...(), VstrError to Vstrerror
 *
 * Revision 2.1  1996/01/04  11:17:05  V
 * Version 2
 * add shared memory access and Control Buffer access
 *
 * Revision 1.8  1995/12/22  18:09:20  V
 * latest revision
 *
 * Revision 1.7  1995/07/26  19:17:11  V
 * added lots of new stuff
 *
 * Revision 1.6  1995/03/14  01:38:36  V
 * add Str*LL function prototypes and remove MailHdr junk
 *
 * Revision 1.5  1995/02/24  20:38:19  V
 * added Replace{In|CharIn}String prototypes
 *
 * Revision 1.4  1995/02/11  01:09:22  V
 * change Syslog ActionLog
 *
 * Revision 1.3  1995/02/03  18:34:37  V
 * changes to defaults interface
 *
 * Revision 1.2  1995/01/20  18:36:45  V
 * brought into line with Vlib library
 *
 * Revision 1.1  1995/01/19  10:29:18  V
 * Initial revision
 *


*/

/* RCS identification string (for "what" program) 
static char moduleRCSid[] = "@(#) $Id: Vlib.h,v 3.3 1997/08/20 10:54:27 damian Exp $";
*/


#ifndef _VLIB_H
#define _VLIB_H

#include <stdio.h>

#include "Vllist.h"

extern char *Vprogram;

#ifdef Vsunos40
#include "Vansi.h"
#endif

/*  application command line processing stuff */
/*
  VappSetupArgs     flag bits

  bits  0-15  control bits

  bits  16-31 value bits

*/

#define VARG_MANDATORY       0x01    /* if set arg is mandatory */
#define VARG_MANDATORY_SET   0x02    /* if set arg is part of a mandatory set */
#define VARG_FAILTRUE        0x04    /* if set fail if evaluation func is true */
#define VARG_FAILFALSE       0x00    /* opposite of FAILTRUE so bit is not set */
#define VARG_EXITFAIL        0x08    /* if set exit if validation fails */
#define VARG_PRNUSAGE        0x10    /* if set print usage for this arg */
#define VARG_POSITION        0x20    /* if set arg is position dependent 
					(top 8 bits determine position ) */


/*  define control bits for args to VappInit */
#define V_NORMAL_INIT       0
#define VARG_NOVERSION      0x01 /* don't print program name and version */
#define VARG_LOGFILE        0x02 /* create a logfile for redirected stderr */
#define VARG_USAGE          0x04 /* don't print usage when exiting */
#define VARG_DFLTS          0x08 /* open defaults area */



typedef struct VargInfo     *VargInfoPtr; 
        

/* this structure is used to process command line arguments.  It can be used
   to identify command line options and also their arguments.  An option
   argument is kept in a distinct arginfo item because this may have nothing
   to do with the preceding option identifier, it may be a positional
   argument in it's own right.  How it is viewed will be determined by 
   subsequent interrogation of the argument list.  If a process asks for
   an option's argument then it will get the next argument that came on the
   command line (as long as it wasn't an option itself) */

/* 

The following command line will produce this list of arginfo items;

   %foo  -dbase -P 1234 -f berks.tar -Wall -Wnobackup -verbose 1000a.c1

a)   -dbase will produce { 1, 'd', "dbase", "base", NULL, 0, NULL, NULL }
b)   -P     will produce { 2, 'P', NULL, "1234", &c, 0, NULL, NULL }
c)   1234   will produce { 3, '\0', NULL, "1234", NULL, 0, NULL, NULL }
d)   -f     will produce { 4, 'f', NULL, "berks.tar", &e, NULL, 0, NULL, NULL }
e)   berks.tar  ==       { 5, '\0', NULL, "berks.tar", NULL, 0, NULL, NULL }
f)   -Wall  will produce { 6, 'W', "Wall", "all", NULL, 0, &g, NULL }
g)   -Wnobackup ==       { 7, 'W', "Wnobackup", "nobackup", NULL, 0, NULL, &f }
h)   -verbose   ==       { 8, 'v', "verbose", "erbose", &i, 0, NULL, NULL }
i)   1000a.c1   ==       { 9, '\0', NULL, "1000a.c1", NULL, 0, NULL, NULL }


NB: this presumes no prior setup (which would affect the way things are
    interpreted)

*/

typedef struct VargInfo {
    int             argindex;	/*-- where this arg occured on the cmd line  */
    char            shortname;	/*-- single char identifier  */
    char            *longname;  /*-- long name identifier  */
    char            *value;	/*-- possible value for short identifier  */
    VargInfoPtr     optarg;	/*-- a possible argument to this option  */
    BitMask         flags;	/*-- control flags  */
    VargInfoPtr     next;	/*-- next option in this identifier's list */
    VargInfoPtr     prev;	/*-- previous option  --  ditto --  */
    int             mutexid;    /*-- mutual exclusion identifier */
/* the following items are setup prior to calling VappInit() */
    char            *range;	/*-- valid range for argument  */
    int             exval;      /*-- exit value if args fails validation */
    BOOLEAN         (*func)();  /*-- validation function */
    char            *desc;	/*-- short description of argument  */
} VargInfo ;



/* public function declarations */

/*
 * AppInit.c and AppArgs.c
 */

#ifdef VANSI_1
extern char     *VappInit( int *, char *[], char *, 
			  int (*)(), BitMask );
extern int      VappSetupArg( char * , char , char *, char *,
			     BOOLEAN (*)(), int, BitMask );
extern int      VappMutExclArgs( char *arg1, ... );
extern int      VappArgINT( char * );
extern char     *VappArgCHAR( char * );
extern int      VappArgPosINT( int  );
extern char     *VappArgPosCHAR( int );
extern int      VappArgPosition( char *, BOOLEAN );
extern char     *VappArgListScan( VargInfoPtr *);
extern VargInfoPtr     VappArgListStart( char * );
#else

extern int      VappSetupArg();	/* setup a named arg */
extern char     *VappArgsInit();	/* process command line */
extern int      VappMutExclArgs(); /* setup list of mutually exclusive args */
extern int      VappArgINT();		/* retrieve an integer argument */
extern char     *VappArgCHAR();	/* retrieve a char * argument */
extern int      VappArgPosINT();	/* get positional arg as an integer */
extern char     *VappArgPosCHAR(); /* get positional arg as a char pointer */
extern int      VappArgPosition();	/* get the position of an argument */
extern char     *VappArgListScan();
extern VargInfoPtr     VappArgListStart();
#endif

extern char     *ProgramName();
extern char     *GlobalDefaults();
extern char     *LocalDefaults();
extern char     *UserDefaults();
extern LLlist 	*VappArgList();	/* get handle on argument list */
extern void     VappGenericArgs();	/* accept set of generic args */


/* private function declarations */
#ifdef VANSI_1
extern VargInfoPtr _FindArgInfoLong( char *);
extern VargInfoPtr _FindArgInfoShort( int  );
extern VargInfoPtr _AddNewArgInfo( char *, int );
#else
extern VargInfoPtr _FindArgInfoLong();
extern VargInfoPtr _FindArgInfoShort();
extern VargInfoPtr _AddNewArgInfo();
#endif


/*  miscellaneous stuff */
#define BitSet( x, y )  (( 0x1 << (x)) & (y))
#define CharBitSet( x, y )  (( 0x80 >> (x)) & (y))
#define LOWNIBBLE(x)   ( (x) & 0xf )
#define HIGHNIBBLE(x)   ( ((x) & 0xf0) >> 4 )

#define isvowel(x) ( (x == 'a') || (x == 'e') || (x == 'i') || (x == 'o') || (x == 'u') || (x == 'A') || (x == 'E') || (x == 'I') || (x == 'O') || (x == 'U'))

#ifndef MIN
#define MIN(a,b)    (( a > b ? b : a ))
#define MAX(a,b)     (( a > b ? a : b ))
#endif


#define FTRACESETNAME(x)    SetProgramName(x)

/* user class or library class */
#define VLT_LIB            0x02
#define VLT_USER           0x00

/* class of message, info, warn or error */
#define VLT_INFO           0x04
#define VLT_WARN           0x08
#define VLT_ERROR          0x10

#define VLT_EXEC           0x20
#define VLT_READ           0x40
#define VLT_WRITE          0x80

#define VLT_ADD            0x100
#define VLT_DEL            0x200

#define VLT_TIME           0x400  /* print the time */
#define VLT_PID            0x800  /* print the process pid */

#define VLT_DFLTSET        0x1000
#define VLT_DFLTGROUP      0x2000


/***** Debug mode masks */

#define VDBG_STRINGS       0x10000
#define VDBG_MEMORY        0x20000
#define VDBG_DFLTS         0x40000
#define VDBG_TIME          0x80000
#define VDBG_SOUND         0x100000


#ifdef VANSI_1
typedef void (*VusageFunc)(char * progname );
#else
typedef void (*VusageFunc)();
#endif

/*-- define some strings to identify defaults items */
#define LastMessageProcessed     "LastMsgProcessed"
#define LastStartDate            "LastStartDate"
#define LastEndFileNumber        "LastEndFileNumber"
#define LastStartFileNumber      "LastStartFileNumber"
#define LastLTRACElevel          "LastLTRACElevel"
#define LastDebugMode            "LastDebugMode"
#define LastSourceDirectory      "LastSourceDirectory"

/*
 * Control.c
 */

#define CONTROLBUF_CVAL_SIZE     512

typedef struct _controlbuf {
    int	        pid;
    int 	senderid;
    int 	recipientid;
    time_t  sent;
    time_t  expires;
    int 	cmd;
    unsigned int	uival;
    unsigned long	ulval;
    unsigned char	cval[CONTROLBUF_CVAL_SIZE];
    int	clen;
    int	flags;
} ControlBuf;

extern void InitControlBuf(void);
extern LLITEMPTR ReadControl(short id);
extern LLITEMPTR PeekControl(short id);
extern int SendControl(int senderid, int recipientid, int cmd,
	    uint uival, ulong ulval, uchar *cval, uint clen, 
	    time_t expires, int flags);

/*
 *  DbgTrace.c
 */

#ifdef VANSI_1
extern void     LTRACE( BitMask mask, ... );
extern void     FTRACE( char *fmt, ...  );
extern void     FTRACEON(void);
extern void     DbgSetLvl( BitMask mask );
extern void     DbgAddLvl( BitMask mask );
extern void     AddLtraceLevel (BitMask);
extern void     AddDebugMode (BitMask);
extern void     SetLtraceLevel (BitMask);
extern void     SetLogFile (int fd);
extern void     SetLogFunction (int (*fd)(char *));
extern void     SetDebugMode (BitMask);
extern void     SetRecoveryMode (BitMask);
extern void     SetStracePattern (char *);
extern void     SetStraceWindow (int);
extern void     SetStraceCase (int);
extern BitMask  DebugMode (void);
extern BitMask  LtraceLevel (void);
extern BitMask  RecoveryMode(void);
#else
extern void     LTRACE( /* BitMask mask, char *fmt, ...*/ );
extern void     FTRACE( /* char *fmt, ... */ );
extern void      DbgSetLvl();
extern void      DbgAddLvl();
extern void     AddLtraceLevel ();
extern void     AddDebugMode ();
extern void     SetLtraceLevel ();
extern void     SetLogFunction (int (*fd)(char *));
extern void     SetLogFile (int fd);
extern void     SetDebugMode ();
extern void     SetRecoveryMode ();
extern void     SetStracePattern ();
extern void     SetStraceWindow ();
extern void     SetStraceCase ();
extern BitMask  DebugMode ();
extern BitMask  RecoveryMode();
#endif



/*
 *  DirUtils.c
*/
#ifdef VANSI_1
extern int TreeSize(char *dir);
#else
extern int TreeSize();
#endif

/*
 * Error.c
*/

#ifdef Vsunos40

extern char *sys_errlist[];

#define Vstrerror(x) sys_errlist[(x)]
#else

#define Vstrerror(x) strerror(x)

#endif

#ifdef VANSI_1
extern void Verror (int,...);
extern void Vsave_err (char *,...);

#else
extern void Verror ();
extern void Vsave_err ();

#endif

#define VE_NOERROR	0

/*  error codes - printf-style argument types given - this list must
   be kept in line with the errlist array in Verror.c - or else! */
#define VE_INVPARM (1000)	/* Invalid Parameter */
/* %s function name, %s parameter name */
#define VE_SWITCH (1001)	/* Invalid switch value */
/* %s function name, %d switch value */
#define VE_MEMORY (1002)	/* Out of memory */
/* %s function name, %d amount of memory */
#define VE_TOPEN (1003)		/* Error opening port */
/* %s port name, %s open type */
#define VE_FOPEN (1004)		/* Error opening file */
/* %s function, %s filename, %s open type */
#define VE_APPL (1005)		/* General Application Error */
/* %s error message */
#define VE_WRITE (1006)		/* Error writing to file */
/* %s function, %s file */
#define VE_ISINIT (1007)	/* Error initing ISAM */
/* %d error code */
#define VE_SIGSET (1008)	/* Error setting signal trap */
/* %s function, %s signal name */
#define VE_ISOPEN (1009)	/* Error opening ISAM file */
/* %s function, %s file, %d error code */
#define VE_NOREC (1010)		/* Record not found */
/* %s function, %s file, %d index, %s key */
#define VE_ISREAD (1011)	/* Error reading ISAM file */
/* %s function, %s file, %d index, %s key, %d error code */
#define VE_ISUPDATE (1012)	/* Error updating ISAM file */
/* %s function, %s file, %d index, %s key, %d error code */
#define VE_ISENDTRX (1013)	/* Error ending ISAM transaction */
/* %s function, %d error code */
#define VE_SETENV (1014)	/* Error during setenv() */
/* %s function, %s variable, %s value */
#define VE_EXEC (1015)		/* Failed to exec() program */
/* %s function, %s program path */
#define VE_ISCLOSE (1016)	/* Error closing ISAM file */
/* %s function, %s file, %d error code */
#define VE_CONFIG (1017)	/* Invalid Parameter Name in Config file */
/* %s file name, %s offending line */
#define VE_PASSWD (1018)	/* Error reading rec from passwd file */
/* %s username */
#define VE_SETUID (1019)	/* Error setting user id */
/* %s user name, %d user id */
#define VE_ARGV (1020)		/* Invalid program startup argument */
/* %s argument value */
#define VE_SOPEN (1021)		/* Error opening system file */
/* %s function */
#define VE_SMMOPEN (1022)	/* Error opening shared memory */
/* %d function */

/* VMINERR and VMAXERR must always be set to the lowest and highest error code
   values! */
#define VMINERR VE_INVPARM
#define VMAXERR VE_SMMOPEN

extern char Vusrmsg[];  /* program message buffer */

/*
 *   Fatalf.c
 */
#ifdef VANSI_1
extern void Fatalf( /* va_alist */ );
#else
extern void Fatalf( /* va_alist */ );
#endif

/*
 *  FileUtils.c
 */

extern char *GetStringFromFile(char *file, int logerrs );
extern int AddStringToFile(char *file, char *str, int logerrs );
extern int GetIntFromFile(char *file, int logerrs );
extern int AddIntToFile(char *file, int n, int logerrs );
extern int TryToOpenFile(char *file, int flags, int mode);
extern int AcquireLockFile(char *);
extern void ReleaseLockFile(char *);

/*
 *  LListString.c
 */

#define CASE_IGNORE         0x01
#define EX_STRING           0x02
#define EX_SUBSTRING        0x04
#define EX_STRINGSUB        0x08
#define EX_STRSTR           0x10
#define EX_SUBSTRSTR        0x20

#ifdef VANSI_1
extern int      AddStringToLListOfStrings( LLITEMPTR list, 
					  char *string, int mode );
extern int      RmStringFromLListOfStrings( LLITEMPTR list, 
					  char *string, int mode );
extern void StrDestroyLL(LLlist *list, int mode );
extern int StrDeleteLL(LLlist *list, char *string, int mode );
extern LLnode *StrAddLL(LLlist *list, char *string, int mode );
extern char *StrFindLL(LLlist *list, char *string, int mode );
extern LLlist *StrCreateLL(void);
#else
extern int      AddStringToLListOfStrings();
extern int      RmStringFromLListOfStrings();
extern void StrDestroyLL();
extern int StrDeleteLL();
extern LLnode *StrAddLL();
extern char *StrFindLL();
extern LLlist *StrCreateLL();
#endif

/*
 * Mailutils.c
*/
typedef struct MailHdr {
    off_t   start;		/* starting offset in file */
    size_t  len;		/* length of the header */
    char    *From;		/* From field */
    char    *Return_Path;
    char    *Received;
    char    *Message_ID;
    char    *Subject;
    char    *To;
    char    *Date;
    char    Status;		/* single char status */
    LLlist  *items;		/* linked list of other items */
} MailHdr;

#define FROM_FLD        0
#define RETURN_PATH_FLD 1
#define RECEIVED_FLD    2
#define MESSAGE_ID_FLD  3
#define SUBJECT_FLD     4
#define TO_FLD          5
#define DATE_FLD        6
#define STATUS_FLD      7
#define TABID_FLD       8
#define MESSAGE_ID2_FLD 9
#define OTHERS_FLD      10

typedef struct MailBody {
    off_t   start;		/* starting offset in file of body */
    size_t  len;		/* length of the body of the message */
    char    *text;		/* text of the body */
} MailBody;

typedef struct MailMsg {
    MailHdr    hdr;		/* all the header fields */
    MailBody   body;		/* body of message */
    char       *attachments[5];
} MailMsg;


#define MAX_BODY_SIZE   (1024*64)
#define MAIL_INVALID_HEADER     1
#define MAIL_INVALID_BODY       2

/* define some error conditions */
#define MAIL_INVALID_LOGIN      -2
#define MAIL_INVALID_MAILBOX    -3
#define MAIL_INVALID_DOMAIN     -4
#define MAIL_UNKNOWN_USER       -5
#define MAIL_INVALID_USER       -6


#ifdef VANSI_1
extern int MailToUser( char *user, ...);
extern char    *GetMailbox( char *from );
extern char    *GetMailboxDomain( char *From );
extern char    *GetMailLogin( char *From );
extern char    *GetMailUser( char *From );
extern MailMsg     *GetNextMailMsg( FILE *fp);
extern void         DestroyMailMsg( MailMsg *mm );
extern int          ExtractMsg( FILE *fp, MailMsg *mm );
#else
extern int MailToUser( /* va_alist */ );
extern char    *GetMailbox();
extern char    *GetMailboxDomain();
extern char    *GetMailLogin();
extern char    *GetMailUser();
extern MailMsg     *GetNextMailMsg();
extern void         DestroyMailMsg();
extern int          ExtractMsg();
#endif

/*
 * Memory.c  
 */
#ifdef VANSI_1
extern char     *CopyString( char *string );
extern void     Free( void *arg );
extern void     *Malloc( size_t n );
extern void     *Realloc( void *old, size_t size );
extern void     *Calloc(size_t nobj,size_t size);
extern void	Memset( void *, int, size_t );
#else
extern char     *CopyString();
extern void     Free();
extern void     *Malloc();
extern void     *Realloc();
extern void     *Calloc();
extern void	Memset();

#endif

/*  debugging functions provided in Memory.c for debugging memory 
    allocations etc. */

extern int PrintFullMemoryUsage();
extern int PrintUsedMemory();
extern int SwitchOnDebuggingMemory();
extern int SwitchOffDebuggingMemory();



#define PLAY_ONCE           1
#define PLAY_CONTINUOUS     2
#define EXEC                3
#define SYSTEM              4

/*
 *   MsgAction.c
 */
#ifdef VANSI_1
extern void     MsgAction( char *msg );
extern void     ActionLog( int mask, char *msg, ... );
#else
extern void     MsgAction();
extern void     ActionLog();
#endif

/*
 *   MsgClassAction.c
 */
#ifdef VANSI_1
extern int      ClassAction( int actclass, char *actbuf, int buflen );
extern int      MessageAction( char *msg, char *actbuf, int buflen,
			      int *classptr, char *classbuf, int clbuflen );
#else
extern int      ClassAction();
extern int      MessageAction();
#endif

/*
 *  PlaySoundFiles.c
 */
#ifdef VANSI_1
extern int      PlaySoundFiles( char *file, ...); /*-- last arg must be null */
extern void     PlayFileListOnce(  char *list );
extern void     PlayFileContinuously( char *file );
extern int      VerifySoundFile( char *fname );
#else
extern int      PlaySoundFiles();
extern void     PlayFileListOnce();
extern void     PlayFileContinuously();
extern int      VerifySoundFile();
#endif

/*
 *    PlayError.c
 */

#ifdef VANSI_1
extern void     PlayError( int playclass, char *msg );
extern void     PlayClassMsg( char *msg );
#else
extern void      PlayError();
extern void     PlayClassMsg();
#endif

/*
 *   PlayLog.c
 */

#ifdef VANSI_1
extern void     PlayLogClass( int playclass );
extern void     PlayLogMsg( char *msg );
#else
extern void     PlayLogClass();
extern void     PlayLogMsg();
#endif

/*
 *   RmfromString.c
 */

#ifdef VANSI_1
extern char     *RemoveFromString( char *string, char *subst );
extern char     *RemoveWordsFromString( char *string, char *subst );
extern char     *RemoveCharFromString( char *string, char ch );
extern char     *ReplaceInString( char *string, char *orig, char *subst );
extern char     *ReplaceCharInString( char *string, char orig, char subst );
#else
extern char     *RemoveFromString();
extern char     *RemoveWordsFromString();
extern char     *RemoveCharFromString();
extern char     *ReplaceInString();
extern char     *ReplaceCharInString();
#endif

/*
 * ShmemAccess.c
 */

/* the shared memory will get set to whatever size by the creating
 application */

typedef struct _shmem_buf {
    int	    count;
    int     size;
    void    *datap;	/* start of the variable data part */
} ShmemBuf;

typedef struct _shm_handle {
    int     shmem_id;
    int     sem_id;
    ShmemBuf    *smb;
} SharedMemHandle;

/* shared memory flag values */
#define SHMEM_FLAGS_INUSE		0x02
#define SHMEM_FLAGS_URGENT	0x04
#define SHMEM_FLAGS_NOHANG	0x06
#define SHMEM_FLAGS_REPLY	0x08
#define SHMEM_FLAGS_ALERT	0x10
#define SHMEM_FLAGS_WARN		0x20
#define SHMEM_FLAGS_ERROR	0x40
#define SHMEM_FLAGS_INFO		0x60
#define SHMEM_FLAGS_DEBUG	0x80
#define SHMEM_FLAGS_EXPIRES	0x100

extern int ShmemInit(SharedMemHandle *smh, char *file, int code, int shmem_size);
extern int ShmemUnlock(SharedMemHandle *smh, int perm);
extern int ShmemLock(SharedMemHandle *smh);


/*
 *  SoundFiles.c
 */
#ifdef VANSI_1
extern int       OpenSoundFile( char *fname );
extern int       VerifySoundFile( char *fname );
#else
extern int       OpenSoundFile();
extern int       VerifySoundFile();
#endif


/*
 * StrUtils.c
 */
#ifdef VANSI_1
extern char     *EndOfString( char * string );
extern void     StripLTBlanks( char *s );
extern int      CountWords( char *str );
extern int      CountWordsInString( char *str );
extern int      CountWordsInStringList( StringList list );
extern char     *UpperStr( char *str );
extern char     *LowerStr( char *str );
extern char     *strcasestr( char *str1, char *str2 );
extern int      PosStringDiff( char *str1, char *str2 );
extern int      NumCharInString( char *string, char ch );
extern char     *TerminateAtNextChar( char *str, char *seps );
extern int      StringToArgVector( char *str, char *argv[0] );
#else
extern char     *EndOfString();
extern void     StripLTBlanks();
extern int      CountWords();
extern int      CountWordsInString();
extern int      CountWordsInStringList();
extern char     *UpperStr();
extern char     *strcasestr();
extern int      PosStringDiff();
extern int      NumCharInString();
extern char     *TerminateAtNextChar();
extern int      StringToArgVector();
#endif



/*
 *   StringList.c
 */

#ifdef VANSI_1
extern StringList       CreateStringList(int num);
extern void             DestroyStringList(StringList list);
extern StringList       ExtendStringList(StringList list, int *newnum);
extern int              CountStringList( StringList list);
#else
extern StringList       CreateStringList();
extern void             DestroyStringList();
extern StringList       ExtendStringList();
extern int              CountStringList();
#endif

/*
 *   StrListUtils.c
 */

#ifdef VANSI_1
extern int           StringListMemberIndex( char *str, StringList list, 
					      int flag );
extern int           MenuStringList( StringList list, char *banner );
extern StringList    *FileToListOfStringList( char *key, char *fname, 
					  int *num, char *seperators );
extern StringList    FileToStringList(  char *filename, int *num );
extern StringList    DirectoryStringList(  char *key, 
					 char *filename, int *num );
extern int           PageStringList( StringList list, void (*clr)(),
		    void (*goxy)(), void (*drawline)(), char *banner );

#else
extern int           StringListMemberIndex();
extern int           MenuStringList();
extern StringList    *FileToListOfStringList();
extern StringList    FileToStringList();
extern StringList    DirectoryStringList();
extern int           PageStringList();
#endif


/*
 *   StringToList.c
 */

#ifdef VANSI_1
extern StringList TruncateStringToStringList( char *str, int len, int num );
extern StringList BreakStringToStringList( char *str, int len, int num );
extern StringList StringToStringList( char *str, int len, int num );
#else
extern StringList TruncateStringToStringList();
extern StringList BreakStringToStringList();
extern StringList StringToStringList();
#endif


/*
 *  StrSubst.c
 */
#ifdef VANSI_1
extern LLlist *VcreateSubstList( char *filename );
extern char   *VgetSubstitution( LLlist *list, char *text );
#else
extern LLlist *VcreateSubstList();
extern char   *VgetSubstitution();

#endif


#ifndef SECS_IN_DAY
#define SECS_IN_DAY     (60 * 60 * 24)
#endif

#ifndef SECS_IN_WEEK
#define SECS_IN_WEEK    (SECS_IN_DAY * 7)
#endif

#ifndef SECS_IN_MONTH
#define SECS_IN_MONTH    (SECS_IN_WEEK * 4)
#endif

/* 
 * TimeLogic.c
 */
#ifdef VANSI_1
extern int TimeLogic( int command, time_t tparam );
#else
extern int TimeLogic();
#endif

/* TimeLogic command codes used for evaluation of time parameter tparam */
/* meaning of the return value differs for each command/command set */

/* determine if the current time is before or after tparam */
/* return TRUE (1) or FALSE (0) */
#define     TL_AFTER_CURRENT        1 /* tparam is > time() */
#define     TL_BEFORE_CURRENT       2 /* tparam is < time() */
#define     TL_EQUAL_CURRENT        3 /* tparam is equal to time() */

/* determine if tparam has same component as current time */
/* return TRUE (1) or FALSE (0) */
#define     TL_SAME_WDAY           10 /* tparam's weekday == current w'day */
#define     TL_SAME_MDAY           11 /* ditto for month day */
#define     TL_SAME_YDAY           12 /* ditto for year day */
#define     TL_SAME_WEEK           13 /* ditto for week */
#define     TL_SAME_MONTH          14 /* ditto for month */
#define     TL_SAME_YEAR           15 /* ditto for year */
#define     TL_SAME_HOUR           16 /* ditto for hour */
#define     TL_SAME_MINUTE         17 /* ditto for minute */
#define     TL_SAME_SECOND         18 /* ditto for second */

/* determine past relation of tparam to current time */
/* return TRUE (1) or FALSE (0) */
#define     TL_WAS_YESTERDAY       30 /* tparam was yesterday */
#define     TL_WAS_LAST_WEEK       31 /* ditto for week */
#define     TL_WAS_LAST_MONTH      32 /* ditto for month */
#define     TL_WAS_LAST_YEAR       33 /* ditto for year */
#define     TL_WAS_LAST_HOUR       34 /* ditto for hour */
#define     TL_WAS_LAST_MINUTE     35 /* ditto for minute */
#define     TL_WAS_LAST_SECOND     36 /* ditto for second */

/* determine future relation of tparam to current time */
/* return TRUE (1) or FALSE (0) */
#define     TL_IS_TOMORROW          40 /* tparam is tomorrow */
#define     TL_IS_NEXT_WEEK         41 /* ditto for week */
#define     TL_IS_NEXT_MONTH        42 /* ditto for month */
#define     TL_IS_NEXT_YEAR         43 /* ditto for year */
#define     TL_IS_NEXT_HOUR         44 /* ditto for hour */
#define     TL_IS_NEXT_MINUTE       45 /* ditto for minute */
#define     TL_IS_NEXT_SECOND       46 /* ditto for second */

/* determine a component of tparam */
/* return an int based on command code ( -1 == error ) */
#define     TL_WDAY_OF              50  /* tparam's day of week (1-7) */
#define     TL_MDAY_OF              51  /* tparam's day of month (1-31) */
#define     TL_YDAY_OF              52  /* tparam's day of year (1-366) */
#define     TL_WEEK_OF              53  /* tparam's week of year (0-53) */
#define     TL_MONTH_OF             54  /* tparam's month of year (1-12)*/
#define     TL_YEAR_OF              55  /* tparam's year (0-9999) */
#define     TL_24HOUR_OF            56  /* tparam's hour (0-23) */
#define     TL_12HOUR_OF            57  /* tparam's hour (1-12) */
#define     TL_MINUTE_OF            58  /* tparam's minute (0-59) */
#define     TL_SECOND_OF            59  /* tparam's second (0-59) */


/* determine a component of current time */
/* return an int based on command code (-1 == error ) */
#define     TL_CURRENT_WDAY         70 /* current day of week (0-6) */
#define     TL_CURRENT_MDAY         71 /* current day of month (1-31) */
#define     TL_CURRENT_YDAY         72 /* current day of year (1-366) */
#define     TL_CURRENT_WEEK         73 /* current week of year (0-53) */
#define     TL_CURRENT_MONTH        74 /* current month of year (1-12)*/
#define     TL_CURRENT_YEAR         75 /* current year (0-9999) */
#define     TL_CURRENT_24HOUR       76 /* current hour (0-23) */
#define     TL_CURRENT_12HOUR       77 /* current hour (1-12) */
#define     TL_CURRENT_MINUTE       78 /* current minute (0-59) */
#define     TL_CURRENT_SECOND       79 /* current second (0-59) */

#define     TL_WEEK_BIT      0x02
#define     TL_MONTH_BIT     0x04
#define     TL_DAY_BIT       0x08
#define     TL_HOUR_BIT      0x10
#define     TL_MINUTE_BIT    0x20
#define     TL_SECOND_BIT    0x40

/*
 *  TimerQ.c
 */


#define TQCOMMENT_SIZE      52	/* this makes structure size 64 bytes */

typedef struct {
    time_t run_at;	    /* first time to run command at */
    time_t run_by;	    /* latest time to run command by */
    void (*func)();	    /* function to run */
    char comment[TQCOMMENT_SIZE];       /* comment for debugging queue */
} TimerQent ;


#ifdef VANSI_1
extern void     VkillTQueue(TimerQent *cmd);
extern void     VcheckTQueue(time_t rtime);
extern void     VaddTQueue(TimerQent *cmd);
extern void     VaddTQalarmCall( time_t t, void (*func)(), char *comment ) ;
#else
extern void     VkillTQueue();
extern void     VcheckTQueue();
extern void     VaddTQueue();
extern void     VaddTQalarmCall(); 
#endif

extern void      VinitTQueue();
extern int       DEBUGtimerQueue();

/*
 *  Truncate.c
 */

#ifdef VANSI_1
extern char     *TruncateString( char *str, int len );
extern char     *TruncateWords( char *str, int len );
#else
extern char     *TruncateString();
extern char     *TruncateWords();
#endif



/* 
 * Util.c
 */

#ifdef VANSI_1

#else

#endif


/*
 *   UInput.c
 */


#ifdef VANSI_1
extern char     *UInputString( FILE *fp );
extern char     UInputChar( FILE *fp );
extern char     UInputCh( FILE *fp );
extern int      UInputInt( FILE *fp );
extern int      VerifyString( char *desc, char *str, char *repl, int replen );
extern int      VerifyInt( char *desc, int *num, int base );
#else
extern char     *UInputString();
extern char     UInputChar();
extern char     UInputCh();
extern int      UInputInt();
extern int      VerifyString();
extern int      VerifyInt();
#endif

/* StrUtils.c */
#ifdef VANSI_1
extern char	*UpperStr(char *str);
extern void	UppString(char *str);
#else
extern char	*UpperStr();
extern void	UppString();

#endif

/* TagValue.c */


typedef struct _TagDef
{
    char *tag;
    char *val;
} TagDef;

#ifdef VANSI_1
extern TagDef *CreateTagDef( char *tag, char *val );
extern void DestroyTagDef( TagDef *tg );
extern LLlist *CreateTagValueLLlist(void);
extern int  AddTagValueToLLlist(LLlist *list, char *tag, char *val);
extern void InitTagValueScan(LLlist *list);
extern int GetNextTagValuePair(LLlist *list, char **tag, char **val);
extern char *FindTagValue(LLlist *list, char *tag);
extern int  SeperateTagAndValue (char *str, char **tag, char **val);
#else
extern TagDef *CreateTagDef();
extern void DestroyTagDef();
extern LLlist *CreateTagValueLLlist();
extern int  AddTagValueToLLlist();
extern void InitTagValueScan();
extern int GetNextTagValuePair();
extern char *FindTagValue();
extern int  SeperateTagAndValue ();

#endif

#endif  /* _VLIB_H_ */

