/******************************************************************************
	  CCCC	    A	  BBBBB	  L	EEEEE  N     N	EEEEE	TTTTTTT
	 C    C    A A	  B    B  L	E      NN    N	E	   T
	C	  A   A	  B    B  L	E      N N   N	E	   T
	C	 AAAAAAA  BBBBB	  L	EEEEE  N  N  N	EEEEE	   T
	C        A     A  B    B  L	E      N   N N	E	   T
	 C    C  A     A  B    B  L	E      N    NN  E 	   T
	  CCCC	 A     A  BBBBB	  LLLL	EEEEE  N     N	EEEEE	   T
*******************************************************************************

CableNet Source Module:
	Copyright 1994-1995 (C) CableNet Limited. All Rights Reserved.

    Module Name:		$RCSfile: test.c,v $
    Module Description:	test functions in the Vdb library

Command Line Args: (for main program modules only)
    Arg      Param      Description

Description: 

Linked with: <file.c> .. <file.c>

Created on   17 May 1996    By damian

Edit History:

	$Log: test.c,v $
 * Revision 1.2  1997/09/02  12:07:09  damian
 * cleanups
 *
	Revision 1.1  1997/08/21 18:08:59  damian
	Initial revision



*/

/* RCS identification string (for "what" program) */
static char moduleRCSid[] = "@(#) $Id: test.c,v 1.2 1997/09/02 12:07:09 damian Exp damian $";

/* must come first header files */
#include "V.h"
#include "Vport.h"

/*
 * system header files 
*/
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <errno.h>

/*
 * third party headers ie, X, informix, ctree 
*/

/*
 * project header files 
*/

#include "Vlib.h"
#include "msql.h"
#include "Vdb.h"

#include "dflts.h"

/*
 * local header files 
*/

/*
 * local defines 
*/

/*
 * local typedefs 
*/

/*
 * static function declarations 
*/

/*
 * static local variables 
*/

/*
 * exported objects/variables (non-static) 
*/

char *Vprogram = "test" ; 

/*
 * static functions 
*/

/*
 * non static functions 
*/

/* 

  demonstrate the use of the various functions in the CableNet library 

*/

char    *host = "localhost";
char    *dbase = "test";

char    *user = NULL;
char    *passwd = NULL;

int
ExerciseSql(char *query)
{
    int     handle, num, slnum, i, handle2;
    char    *fldv[128], *id, *start, *length;
    StringList  sl;

    /* access the SQL database engine using the generic interface library */

    if (user != NULL && passwd != NULL) {
      if (VdbInit(user,passwd) < 0) {
	fprintf(stderr, "Initialisation failed! %s\n", Vdbmsg);
	return 1;
      }
    }

    if ((handle = VdbConnect(host)) < 0) {
	fprintf(stderr, "Couldn't connect to engine! %s\n", Vdbmsg);
	return 1;
    }

    if (VdbSelect(handle, dbase) < 0) {
	fprintf(stderr, "Couldn't select database %s! %s\n", dbase, Vdbmsg);
	return 1;
    }

    if ((handle2 = VdbConnectDB(host,dbase)) < 0) {
	fprintf(stderr, "Couldn't connect to engine! %s\n", Vdbmsg);
	return 1;
    }

    if (handle != handle2) {
	fprintf(stderr, "Second connect doesn't return same handle %d/%d\n",
		handle, handle2);
	return 1;
    }

    /* do the query */
    if (VdbQuery(handle, query) < 0 ) {
	fprintf(stderr, "Query failed! %s\n", Vdbmsg);
	return 1;
    }

    /* get the number of fields from the query, more than 128 will SIGSEGV */
    if ((num = VdbNumFields(handle)) < 0) {
	fprintf(stderr, "Can't get number of fields in the result set %s\n",
		Vdbmsg );
	return 1;
    }

    if (VdbNumRows(handle) == 0) {
	fprintf(stderr, "Empty result set\n");
	return 1;
    }

    /* just retrieve the first record that matches */

    if (VdbFirstRec(handle, &fldv[0], &num) < 0) {
	fprintf(stderr, "Can't retrieve first record from result set %s\n",
		Vdbmsg );
	return 1;
    } else {
      for (i = 0; i < num; i++)
	printf("%d == %s\n", i, fldv[i] );
    }

    /* retrieve the result set as a string list which we can cycle through
       easily */
    sl = VdbResultSL(handle, '^');

    slnum = CountStringList(sl);

    for( i = 0 ; i < slnum ; i++) {
      char    *p;

      for (p = strtok(sl[i],"^"); p ; p = strtok(NULL,"^") )
	printf("%s\t", p );

      printf("\n");
    }

    VdbClose(handle);

    return 0;
}

char *ver = "$Revision: 1.2 $";

int
usage()
{
    fprintf(stdout, "%s: usage:  test \"<query>\"\n", Vprogram);
    return 0;
}

int
main(int argc, char **argv)
{

    if (argc != 2) {
	usage();
	exit(1);
    }

    return ExerciseSql(argv[1]);

}
