#ifndef CGI_MACRO_ENV_H
#define CGI_MACRO_ENV_H

#include <string>
#include <vector>

class CgiApp;

struct CgiMacroEnv
 {
  CgiApp* cgi_app;

  string source_file;
  string sql_db_driver;
  string sql_on_error;
  string sql_dbh;
  string sql_row_var_name;
  string sql_cursor_res_var_name;
  string seg_fault_text;
  string seg_fault_handler;
  string sql_client_app;
  string sql_schema_file;

  int cur_sql_cursor_depth; // used to handle nested invocations of
   // SQL_CURSOR_DO
 
  int has_mailer;
  int max_args;
  int arg_buf_size;
  int http_cookie_auth; // write code for user authentication
   // with HTTP cookies
  string http_cookie_maker; // user function responsible for printing
  // the cookie value to stdout

  string mailer_on_error;
  string mailer_app;

  CgiMacroEnv(): 
        sql_db_driver("mysql"),
	sql_on_error(""),
	sql_dbh("dbh"),
	sql_row_var_name("sql_row"),
	sql_cursor_res_var_name("sql_res"),
	http_cookie_maker(""),
	http_cookie_auth(0),
	mailer_on_error(""),
	mailer_app("/usr/sbin/sendmail -t"),
      	seg_fault_handler("cgipp_handle_seg_fault"),
        seg_fault_text("The cgi program received SIGSEGV and was aborted"),
	max_args(5), arg_buf_size(8192), cur_sql_cursor_depth(0),
	has_mailer(0),
	cgi_app(NULL)
	 {}
    
   void write_sql_cursor_var_sub(ofstream& os) 
    { 
     if (cur_sql_cursor_depth > 1)  
      os << (cur_sql_cursor_depth - 1);  
    }
 };
 

#endif
