#include "cgi_app.h"
#include "cgi_macro_env.h"
#include "cgi_c_macro.h"

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

extern CgiMacroEnv macro_env;

CgiApp::CgiApp(vector <CgiAppSection*> *init_sections)
 {
  sections = init_sections;
  macro_env.cgi_app = this;
 }

CgiApp::~CgiApp()
 {
  //cerr << "In ~CgiApp() " << endl;
  if(CgiCMacro::schema_s)
  {
   CgiCMacro::schema_s << "EOT" << endl;
   CgiCMacro::schema_s.close();
   chmod(macro_env.sql_schema_file.c_str(), 0700);
  }
 }

void CgiApp::write_c_forms(ofstream& os)
 {
  unsigned int i;

  for(i = 0; i < cgi_form_list.size(); i++)
   {
    cgi_form_list[i].write_c(os);
   }
 }

void CgiApp::write_c_includes(ofstream& os)
 {
  unsigned int i;
  char* inc_list[] = {"iostream.h", "fstream.h", 
   "strstream.h", "stdio.h",
   "stdlib.h", "string.h", "ctype.h", "unistd.h",
     "string", "vector", "cgi++-lib.h",
    "time.h", "sys/types.h", "signal.h", NULL};

  for(i = 0; inc_list[i];  i++)
   {
    os << "#include <" << inc_list[i] << ">" << endl;
   }
   
   
   os << endl;
 }

void CgiApp::write_c_functions(ofstream& os)
 {
  os << "inline void cgipp_wearehtml()" << endl;
  os << "{" << endl;
  os << " if(!cgipp_said_wearehtml)" << endl;
  os << "  {" << endl;
  os << "   cout << \"Content-type: text/html\n\n\";" << endl;
  os << "   cgipp_said_wearehtml = 1; " << endl;
  os << "  }" << endl;
  os << "}" << endl;

  os << "static void cgipp_handle_seg_fault(int num)" << endl;
  os << "{" << endl;
  os << " if(cgipp_in_cookie) cout << endl;" << endl;
  os << " cgipp_wearehtml();" << endl;
  os << " cout << \"" << macro_env.seg_fault_text << "\" << endl;" << endl;
  os << "}" << endl;
 

 
 }

void CgiApp::write_c_sections(ofstream& os)
 {
  unsigned int i;

  for(i = 0; i < sections->size(); i++)
   {
    (*sections)[i]->expand(os);
   }
 }

void CgiApp::write_c_globals(ofstream& os)
 {
  os << "static int cgipp_said_wearehtml = 0;" << endl;
  os << "static int cgipp_in_cookie = 0;" << endl;
  os << "static const int MAX_MACRO_ARGS = " << 
   macro_env.max_args << ";" << endl;
  os << "static const int MACRO_ARG_BUF_SIZE = " << 
   macro_env.arg_buf_size << ";" << endl;
  int i;

  if(CgiForm::num_post_forms > 1 || CgiForm::num_get_forms > 1)
   os << "char* content_buf = NULL;" << endl;
  os << "int content_len = 0; " << endl;

  if(macro_env.has_mailer)
   {
    os << "FILE* mailer_pipe;" << endl;
    os << "ofstream mailer_ostream;" << endl;
   }

  for(i = 0; i < macro_env.max_args; i++)
   {
    os << "static char macro_arg_buf" << i << "[" << 
     macro_env.arg_buf_size << "];" << endl;
   }
 }

void CgiApp::write_c(ofstream& os)
 {
  os << "/* File generated by cgi++ - for questions/comments \
   bug reports contact Sasha Pachev <sasha@direct1.com>" << endl;
   os << "* do not edit, your changes will be lost */" << endl;
  os << endl;
  os << "// required and most common includes" << endl;
  write_c_includes(os);
  os << endl;
  os << "// global varialbes " << endl;
  write_c_globals(os);
  os << "// generated funtions " << endl;
  write_c_functions(os);
  os << endl;
  os << "// form classes inferred from user HTML" << endl;
  write_c_forms(os);
  os << endl;
  os << "// code generated direction from user input" << endl;
  write_c_sections(os);
 }

