
#include <stdio.h>
#include <stdlib.h>
#include <mysql.h>
#include <eif_eiffel.h>


EIF_POINTER mb_get_new_mysql_pointer()
{
	void	*a;
	
	a = malloc( sizeof(MYSQL) );
	
	return a;
}

EIF_POINTER mb_get_new_mysql_result_pointer()
{
	void	*a;
	
	a = malloc( sizeof(MYSQL_RES) );
	
	return a;
}

void mb_init( MYSQL **mysql, MYSQL_RES **res )
{
	*res = NULL;
}

EIF_BOOLEAN mb_connect( MYSQL **mysql, char *host, char *username,
		char *password )
{
	if( mysql_connect(*mysql, host, username, password) == NULL )
	{
		return EIF_FALSE;
	}

	return EIF_TRUE;
}

void mb_disconnect( MYSQL **mysql )
{
	mysql_close( *mysql );
}

EIF_BOOLEAN mb_select_database( MYSQL **mysql,  char *db_name )
{
	if( mysql_select_db(*mysql, db_name) )
		return EIF_FALSE;
	
	return EIF_TRUE;
}

void mb_free_result_data( MYSQL_RES **res )
{
	mysql_free_result( *res );
}

void mb_free_mysql_pointer( MYSQL **mysql )
{
	free( *mysql );
}

EIF_BOOLEAN mb_execute_query( MYSQL **mysql, MYSQL_RES **res, char *query )
{
	if( *res != NULL )
	{
		mb_free_result_data( res );
		*res = NULL;
	}

	if( mysql_query(*mysql, query) == 0 )
	{
		*res = mysql_store_result( *mysql );

		if( res == NULL )
		{
			if( mysql_num_fields(*mysql) == 0 )
				return EIF_TRUE;
			else
				return EIF_FALSE;
		}
		else
			return EIF_TRUE;
	}
	else
		return EIF_FALSE;

	return EIF_FALSE;
}

EIF_INTEGER mb_row_count( MYSQL_RES **res )
{
	if( *res == NULL )
		return 0;
	
	return	mysql_num_rows( *res );
}

EIF_INTEGER mb_field_count( MYSQL_RES **res )
{
	if( *res == NULL )
		return 0;

	return mysql_num_fields( *res );
}

EIF_REFERENCE mb_field_name( MYSQL_RES **res, int n )
{
	MYSQL_FIELD	*field;

	if( *res == NULL )
		return RTMS( "" );
	
	mysql_field_seek( *res, n );
	field = mysql_fetch_field( *res );
	
	if( field == NULL )
		return RTMS( "" );

	return RTMS( field->name );
}

EIF_INTEGER mb_field_size( MYSQL_RES **res, int n )
{
	MYSQL_FIELD	*field;
	
	if( *res == NULL )
		return 0;
	
	mysql_field_seek( *res, n );
	field = mysql_fetch_field( *res );

	if( field == NULL )
		return 0;
	
	return field->length;
}

void mb_select_row( MYSQL_RES **res, int n )
{
	mysql_data_seek( *res, n );
}

EIF_POINTER mb_get_row( MYSQL_RES **res )
{
	return (EIF_POINTER)mysql_fetch_row( *res );
}

EIF_REFERENCE mb_get_field( MYSQL_ROW row, int n )
{
	return RTMS( row[n] );
}

EIF_REFERENCE mb_get_mysql_error( MYSQL **mysql )
{
	return	RTMS( mysql_error(*mysql) );
}
