indexing

	description: "Test program for SQL_DATABASE, uses EiffelFox as it's%
	             %Gui Interface"
	date: "1999/06/00"
	copyright: "Copyright 1999 Michael Ravits"
	license: "Eiffel Forum Freeware License, version 1"
	
class TEST_FOX_AND_SQL

inherit
	FX_APPLICATION
		rename
			make as make_application,
			Id_last as App_id_last
		end
	FX_OPTION_SET
	EXCEPTIONS
	
creation
	make

feature	 -- Initialization

	make is
			-- Initialize
		do
			make_application( App_name, App_vendor )
			initialize

			------------------------------------------
			create main_win.make_with_options( Current,
					Main_window_title,
					<<decor_all>> )

			main_win.set_width( 800 )
			main_win.set_height( 600 )
			------------------------------------------


			install_message_handlers
			
			construct_widgets

			create_resources

			main_win.show
			
			create database.make

			run
		end

feature  -- Message identifiers

	Id_connect          : INTEGER is do Result := App_id_last     end
	Id_query            : INTEGER is do Result := App_id_last + 1 end
	Id_query_app_status : INTEGER is do Result := App_id_last + 2 end
	Id_setup            : INTEGER is do Result := App_id_last + 3 end
	Id_last             : INTEGER is do Result := App_id_last + 4 end

feature{SETUP}  -- Status change

	set_result_font( font : FX_FONT ) is
			-- Set font in which query results will
			-- be printed
		do
			result_list.set_font( font )
		end

feature{NONE}  -- Implementation


	install_message_handlers is 
			-- Set callbacks
		local
			cmd : FX_ROUTINE
		do
			create cmd.make( ~connect_disconnect_database )
			add_command( cmd, Id_connect, 0 )
			
			create cmd.make( ~query_database )
			add_command( cmd, Id_query, 0 )
			
			create cmd.make( ~on_query_app_status )
			add_command( cmd, main_window.Id_query_help, 0 )

			create cmd.make( ~show_setup )
			add_command( cmd, Id_setup, 0 )
		end

	construct_widgets is 
			-- Create GUI components
		local
			button	    : FX_BUTTON
			label	    : FX_LABEL
			h_separator : FX_HORIZONTAL_SEPARATOR
			result_font : FX_FONT
		do
			-- Main Frame

			create contents_frame.make_with_options( main_win,
					<<Layout_side_top,
					Layout_fill_horizontally,
					Layout_fill_vertically>> )

			-- Status bar
			
			create status_bar.make_with_options( main_win,
					<<Layout_side_bottom,
					Layout_fill_horizontally,
					Status_bar_with_drag_corner>> )
					
			status_line := status_bar.status_line
			status_line.relay_messages( Current, main_window.Id_query_help )

			-- Query result frame
			
			create list_frame.make_with_options( contents_frame,
					<<Frame_sunken,
					Layout_fill_horizontally,
					Layout_fill_vertically,
					Layout_top,
					Layout_left>> )
			
			create label.make_with_options( list_frame,
					List_frame_label1,
					<<Justify_center_horizontally,
					Layout_fill_horizontally>> )

			create h_separator.make_with_options( list_frame,
					<<Separator_groove,
					Layout_fill_horizontally>> )

			create query_input_box.make_with_options( list_frame,
					20,
					<<Justify_left,
					Frame_sunken,
					Frame_thick,
					Layout_side_top,
					Layout_fill_horizontally>> )

			create label.make_with_options( list_frame,
					List_frame_label2,
					<<Justify_center_horizontally,
					Layout_fill_horizontally>> )

			create h_separator.make_with_options( list_frame,
					<<Separator_groove,
					Layout_fill_horizontally>> )

			create result_list.make_with_options( list_frame, 20,
					<<Frame_sunken,
					Layout_fill_horizontally,
					Layout_fill_vertically,
					Layout_top,
					Layout_left>> )

			create result_font.make( Current, "fixed", 12 )

			result_list.set_font( result_font ) 

			-- Errors box


			create h_separator.make_with_options( list_frame,
					<<Separator_groove,
					Layout_fill_horizontally>> )

			create error_text_box.make_with_options( list_frame,
					<<Frame_sunken,
					Layout_fill_horizontally,
					Layout_top,
					Layout_left>> )


			-- Buttons frame
			
			create button_frame.make_with_options( contents_frame,
					<<Frame_sunken,
					Layout_fill_vertically,
					Layout_top,
					Layout_left>> )
			
			create label.make_with_options( button_frame,
					Button_frame_label,
					<<Justify_center_horizontally,
					Layout_fill_horizontally>> )

			create h_separator.make_with_options( button_frame,
					<<Separator_ridge,
					Layout_fill_horizontally>> )
			
			-- Buttons
			
			create button.make_with_options( button_frame,
					Connect_button_label,
					<<Frame_thick,
					Frame_raised,
					Layout_fill_horizontally,
					Layout_top,
					Layout_left>> )
			
			button.relay_messages( Current, Id_connect )
			
			
			create button.make_with_options( button_frame,
					Query_button_label,
					<<Frame_thick,
					Frame_raised,
					Layout_fill_horizontally,
					Layout_top,
					Layout_left>> )
			
			button.relay_messages( Current, Id_query )


			create button.make_with_options( button_frame,
					Setup_button_label,
					<<Frame_thick,
					Frame_raised,
					Layout_fill_horizontally,
					Layout_top,
					Layout_left>> )
			
			button.relay_messages( Current, Id_setup )

			
			create button.make_with_options( button_frame,
					Exit_button_label,
					<<Frame_thick,
					Frame_raised,
					Layout_fill_horizontally,
					Layout_top,
					Layout_left>> )
			
			button.relay_messages( Current, Id_quit )

			-- Setup

			create program_setup.make( Current )
		end


	set_status_line( s : STRING ) is
			-- Set line to be displayed on the
			-- status bar
		require			
			not_void: s /= Void
		do
			current_status := s 
		end

	display_query_result is 
			-- Show what we've got
		local
			item       : FX_LIST_ITEM
			i          : INTEGER
			f          : INTEGER
			s          : STRING
			filer      : STRING
			fill_space : INTEGER
		do
			result_list.wipe_out
			create s.make( 0 )

			from
				i := 1
			until
				i = database.row_count + 1
			loop
				database.select_row( i ) 
				s.clear_all
				s.append( "|" )
				
				from
					f := 1
				until
					f = database.field_count + 1
				loop
					database.select_field( f )
					
					s.append( " " )
					s.append( database.get_field )

					fill_space := database.field_size( f ) - database.get_field.count
					create filer.make( fill_space )
					filer.fill_character( ' ' )
					s.append( filer )
					
					s.append( " |" )
					
					f := f + 1
				end
				
				create item.make( s )
				result_list.extend( item )

				i := i + 1
			end
		end

feature{NONE}  -- Implementation, callbacks

	
	connect_disconnect_database( data : FX_MESSAGE ) is
			-- Connect or disconnect to/from SQL server
		require
			not_void: database /= Void
		local
			button : FX_BUTTON
			failed : BOOLEAN
			s      : STRING 
		do
			if not failed then
				if database.is_connected then
					button ?= data.sender
				
					check not_void: button /= Void end

					button.set_text( Connect_button_label )

					database.disconnect
				else
					database.set_host_username_and_password( program_setup.hostname.text,
							program_setup.username.text,
							program_setup.password.text )

					database.connect
					database.set_database_name( program_setup.database_name.text )
					database.select_database

					button ?= data.sender
				
					check not_void: button /= Void end

					button.set_text( Disconnect_button_label )
				end
			end
		rescue
			if is_developer_exception and developer_exception_name.is_equal( database.last_exception ) then
			
				create s.make( developer_exception_name.count +
						database.error.count + ("%N").count );
						
				s.append(developer_exception_name)
				s.append( "%N" )
				s.append( database.error )

				print_error( s )
				
				failed := True
				retry
			end
		end

	query_database( data : FX_MESSAGE ) is
			-- Query database
		require
			not_void: database /= Void
		local
			failed : BOOLEAN
			s      : STRING
		do
			if not failed then
				if database.is_connected then
					database.set_query( query_input_box.text )
					database.execute
					display_query_result
				else
					set_status_line( "Not connected to database" )
				end
			end
		rescue
			if is_developer_exception and developer_exception_name.is_equal( database.last_exception ) then
			
				create s.make( developer_exception_name.count +
						database.error.count + ("%N").count );
						
				s.append(developer_exception_name)
				s.append( "%N" )
				s.append( database.error )

				print_error( s )
				
				failed := True
				retry
			end
		end

	on_query_app_status( data : FX_MESSAGE ) is
			-- Update status bar
		local
			status : FX_STATUS_LINE
		do
			status ?= data.sender

			check status /= Void end

			if current_status /= Void then
				status.set_text( current_status )
			end
		end


	show_setup( data : FX_MESSAGE ) is
			-- Show setup window
		require
			not_void: program_setup /= Void
		do
			program_setup.show
		end

	print_error( s : STRING ) is
			-- Print error string `s' in the errors box
		require
			not_void: s /= Void
		do
			error_text_box.set_text( s )
		end
		
feature{NONE}

	main_win         : FX_MAIN_WINDOW
	contents_frame   : FX_HORIZONTAL_FRAME
	button_frame     : FX_VERTICAL_FRAME
	list_frame       : FX_VERTICAL_FRAME
	result_list      : FX_LIST
	status_bar       : FX_STATUS_BAR
	status_line      : FX_STATUS_LINE
	query_input_box  : FX_TEXT_FIELD
	error_text_box   : FX_TEXT

	program_setup	 : SETUP

	database : SQL_DATABASE

	query_string   : STRING
	current_status : STRING


	Main_window_title       : STRING is "SQL and Fox test" 
	App_name                : STRING is "SQL and Fox test" 
	App_vendor	        : STRING is "Anonymous"
	Button_frame_label      : STRING is "Options" 
	List_frame_label1       : STRING is "Query" 
	List_frame_label2       : STRING is "Query result" 
	Connect_button_label    : STRING is "&Connect"
	Disconnect_button_label : STRING is "&Disconnect"
	Exit_button_label       : STRING is "&Exit"
	Query_button_label      : STRING is "&Query"
	Setup_button_label      : STRING is "&Setup"

end -- class TEST_FOX_AND_SQL
