#!/usr/bin/perl -T
########################################################################
#                                                                      #
#    dictimport.pl                InnerCite                            #
#                                 Mike Machado <mike@innercite.com>    #
#                                 27 April 1999                        #
#                                                                      #
#    Imports standard RADIUS dictionaries into mysql                   #
#                                                                      #
#                   Copyright under same terms as Cistron RADIUS       #
#                                                                      #
########################################################################


use DBI;
use strict;
my $file = shift || '';

if ($file eq '') {
  print "Usage: dictimport.pl dictionary\n";
  exit;
}

my $dbusername = 'root';
my $dbpassword = 'rootpass';
my $dbh = DBI->connect("DBI:mysql:radius",$dbusername, $dbpassword) || die "Could not connect to radius database as $dbusername\n";

open(DICT, $file) || die "Cannot open $file for read\n";

my ($dummystr, $namestr, $valstr, $typestr, $vendorstr);
my $sth;
my $sql = '';
my $lineno = 0;
while (<DICT>) {
  $lineno++;

  next if (/^#/);
  next if (/^\$/);
  next if (/^$/);

  ($dummystr, $namestr, $valstr, $typestr, $vendorstr) = split(/\s+/);
 
  if ($dummystr =~ 'ATTRIB') {
     $sql = "INSERT INTO dictionary VALUES \(\"\",\"$dummystr\",\"$namestr\",\"$valstr\",\"$typestr\",\"$vendorstr\"\)";
  } elsif ($dummystr eq 'VALUE') {
     $sql = "INSERT INTO dictionary VALUES \(\"\",\"$dummystr\",\"$namestr\",\"$valstr\",\"$typestr\",\"\"\)";
  } elsif ($dummystr eq 'VENDOR') {
     $sql = "INSERT INTO dictionary VALUES \(\"\",\"$dummystr\",\"$namestr\",\"$valstr\",\"\",\"\"\)";
  } else {
     print "Unknown entry on line $lineno\n";
     $sql = '';
  }
  $sth = $dbh->do($sql) if $sql;
}
$dbh->disconnect;
