#include "udm_config.h"
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <string.h>
#include <errno.h>

#include "udm_common.h"
#include "udm_spell.h"
#include "udm_db.h"
#include "udm_charset.h"
#include "udm_proto.h"
#include "udm_parseurl.h"
#include "udm_parser.h"
#include "udm_conf.h"
#include "udm_indexer.h"
#include "udm_log.h"
#include "udm_hrefs.h"
#include "udm_robots.h"
#include "udm_utils.h"
#include "udm_xmalloc.h"
#include "udm_host.h"
#include "udm_server.h"
#include "udm_alias.h"
#include "udm_filter.h"
#include "udm_search_tl.h"
#include "udm_env.h"
#include "udm_mimetype.h"
#include "udm_stopwords.h"

/****************************  Load Configuration **********************/

static int UdmFollowType(char * follow){
	if(!strcasecmp(follow,"no"))return(UDM_FOLLOW_NO);
	if(!strcasecmp(follow,"page"))return(UDM_FOLLOW_NO);
	if(!strcasecmp(follow,"yes"))return(UDM_FOLLOW_PATH);
	if(!strcasecmp(follow,"path"))return(UDM_FOLLOW_PATH);
	if(!strcasecmp(follow,"site"))return(UDM_FOLLOW_SITE);
	if(!strcasecmp(follow,"world"))return(UDM_FOLLOW_WORLD);
	return(UDM_FOLLOW_UNKNOWN);
}



#define IF_NUM_PARAM(src,name,dst,def) \
if(!UDM_STRNCASECMP(src,name)){if(sscanf(src+strlen(name),"%d",&(dst))!=1)dst=def;}

#define IF_TIME_PARAM(src,name,dst,def) \
if (!UDM_STRNCASECMP(src,name)){ \
	if ((dst=Udm_dp2time_t(src+strlen(name)))==-1) \
		dst=def; \
}

#define IF_BOOL_PARAM(src,name,dst,def) \
if(!UDM_STRNCASECMP(src,name)){ \
char xxx[1024]; \
if(sscanf(src+strlen(name),"%s",xxx)==1){ \
	if(!UDM_STRNCASECMP(xxx,"yes"))dst=1; \
	else	dst=0; \
}else \
	dst=def; \
}


__INDLIB__  UDM_ENV * UdmLoadConfig(UDM_ENV * Conf,const char *conf_name,int config_level,int load_flags){
int i=0; /* For line number */
FILE *config;
char str[UDMSTRSIZ]="";
char str1[UDMSTRSIZ]="";
char str2[UDMSTRSIZ]="";
char *ch;

	Conf->errcode=0;
	Conf->errstr[0]=0;

	if(config_level==0){ /* Do some initialization */
		Conf->force1251=0;
		Conf->nspell=0;
		Conf->csrv=(UDM_SERVER*)UdmXmalloc(sizeof(UDM_SERVER));
		UdmInitServer(Conf->csrv);
		sprintf(Conf->user_agent,"%s/%s",UDM_USER_AGENT,VERSION);
		Conf->extra_headers[0]=0;
		Conf->max_doc_size=UDM_MAXDOCSIZE;
		UdmSetLogFacility(Conf, "");
		Conf->local_charset=UDM_CHARSET_USASCII;

		/* I have removed it to allow adding of URLs  */
		/* Passed in -i with -u command line args     */
		/* But it seems that UnloadConf() is required */
		/* REMOVED      UdmFreeHrefs(); */
	}

	/* Open config file */
	if(!(config=fopen(conf_name,"r"))){
		sprintf(Conf->errstr,"Error: can't open config file '%s': %s",conf_name, strerror(errno));
		Conf->errcode=1;
		return(Conf);
	}

	/*  Read lines and parse */
	while(fgets(str1,sizeof(str1),config)){
		char *end;
		i++;
		if(!str1[0])continue;
		end=str1+strlen(str1)-1;
		while((end>=str1)&&(*end=='\r'||*end=='\n')){
			*end=0;if(end>str1)end--;
		}
		if(!str1[0])continue;
		if(str1[0]=='#')continue;

		if(*end=='\\'){
			*end=0;strcat(str,str1);
			continue;
		}
		strcat(str,str1);
		strcpy(str1,"");

		if(!UDM_STRNCASECMP(str,"DBAddr")){
			if(UdmEnvSetDBAddr(Conf,UdmTrim(str+6," \r\n\t"))){
				sprintf(Conf->errstr,"Bad DBAddr in config file '%s' line %d:%s",conf_name,i,str);
				Conf->errcode=1;
				return(Conf);
			}
		}else
		if(!UDM_STRNCASECMP(str,"DBMode")){
			UdmEnvSetDBMode(Conf,UdmTrim(str+6," \r\n\t"));
		}else
		if(!UDM_STRNCASECMP(str,"LogdAddr")){
			UDM_FREE(Conf->logd_addr);
			Conf->logd_addr=strdup(UdmTrim(str+8," \r\n\t"));
		}else
		if(!UDM_STRNCASECMP(str,"LocalCharset")){
			Conf->local_charset=UdmGetCharset(UdmTrim(str+13," \r\n\t"));
		}else
		if(!UDM_STRNCASECMP(str,"UseRemoteContentType")){
					if(!UDM_STRNCASECMP(UdmTrim(str+20,"= \r\t\n"),"no")) 
					     Conf->use_remote_cont_type=0;
					else Conf->use_remote_cont_type=1;
		}else
		if(!UDM_STRNCASECMP(str,"IspellMode")){
					if(!UDM_STRNCASECMP(UdmTrim(str+10,"= \r\t\n"),"db")) 
					     Conf->ispell_mode |= UDM_ISPELL_MODE_DB;
					else {
					  Conf->ispell_mode &= ~UDM_ISPELL_MODE_DB;
					  if(!UDM_STRNCASECMP(UdmTrim(str+10,"= \r\t\n"),"server")) {
					    Conf->ispell_mode |= UDM_ISPELL_MODE_SERVER;
					    Conf->spellhost = strdup(UdmTrim(UdmTrim(str+10, "= \r\t\n")+ 6, "= \r\t\n"));
					    UdmLoadSpellFromServer(Conf, Conf->spellhost);
					  }
					}
		}else
		if(!UDM_STRNCASECMP(str,"IspellUsePrefixes")){
					if(!UDM_STRNCASECMP(UdmTrim(str+17,"= \r\t\n"),"yes")) 
					     Conf->ispell_mode |= UDM_ISPELL_USE_PREFIXES;
					else Conf->ispell_mode &= ~UDM_ISPELL_USE_PREFIXES;
		}else
		if(!UDM_STRNCASECMP(str,"Disallow")){
			if(UdmAddFilterStr(Conf,str,UDM_DISALLOW))
				return(Conf);
		}else	
		if(!UDM_STRNCASECMP(str,"Allow")){
			if(UdmAddFilterStr(Conf,str,UDM_ALLOW))
				return(Conf);
		}else
		if(!UDM_STRNCASECMP(str,"CheckOnly")){
			if(UdmAddFilterStr(Conf,str,UDM_HEAD))
				return(Conf);
		}else
		if(!UDM_STRNCASECMP(str,"HrefOnly")){
			if(UdmAddFilterStr(Conf,str,UDM_HREFONLY))
				return(Conf);
		}else
		if(!UDM_STRNCASECMP(str,"AddType")){
			char *mime_type=NULL,*lt,*ttok;
			int flags=0;

			ttok=UdmGetStrToken(str+7,&lt);
			while(ttok){
				if(!strcasecmp(ttok,"regex"))
					flags|=UDM_MIME_REGEX;
				else
				if(!strcasecmp(ttok,"regexp"))
					flags|=UDM_MIME_REGEX;
				else
				if(!strcasecmp(ttok,"string"))
					flags&=~UDM_MIME_REGEX;
				else
				if(!strcasecmp(ttok,"case"))
					flags|=UDM_MIME_CS;
				else
				if(!strcasecmp(ttok,"nocase"))
					flags&=~UDM_MIME_CS;
				else
				if(!mime_type)
					mime_type=ttok;
				else{
					if(UdmAddType(Conf,mime_type,ttok,flags))
						return(Conf);
				}
				ttok=UdmGetStrToken(NULL,&lt);
			}
		}else
		if(!UDM_STRNCASECMP(str,"CharSet")){
			UDM_FREE(Conf->csrv->charset);
			if(sscanf(str+7,"%s",str1))
				Conf->csrv->charset=strdup(str1);
		}else
		if(!UDM_STRNCASECMP(str,"ProxyAuthBasic")){
			UDM_FREE(Conf->csrv->proxy_basic_auth);
			if(sscanf(str+14,"%s",str1)){
				Conf->csrv->proxy_basic_auth=(char*) UdmXmalloc(BASE64_LEN(strlen(str1)));
				udm_base64_encode(str1,Conf->csrv->proxy_basic_auth,strlen(str1));
			}
		}else
		if(!UDM_STRNCASECMP(str,"Proxy")){
			UDM_FREE(Conf->csrv->proxy);
			if(sscanf(str+5,"%s",str1)&&strcmp(str1,""))
				Conf->csrv->proxy=strdup(str1);
		}else
		if(!UDM_STRNCASECMP(str,"Category")){
			UDM_FREE(Conf->csrv->category);
			if(sscanf(str+9,"%s",str1))
			Conf->csrv->category=strdup(str1);
		}else
		if(!UDM_STRNCASECMP(str,"Tag")){
			UDM_FREE(Conf->csrv->tag);
			if(sscanf(str+3,"%s",str1))
			Conf->csrv->tag=strdup(str1);
		}else
		if(!UDM_STRNCASECMP(str,"HTTPHeader")){
			char * arg;
			arg=UdmTrim(str+11," \r\n\t");
			if(sscanf(arg,"%[^\n\r]s",str1)&&strcmp(str1,"")){
				if(!UDM_STRNCMP(str1,"User-Agent: ")){
					strcpy(Conf->user_agent,str1+12);
				}else{
					strcat(Conf->extra_headers,str1);
					strcat(Conf->extra_headers,"\r\n");
				}
			}
		}else
#ifdef HAVE_SYSLOG_H
		if(!UDM_STRNCASECMP(str,"SyslogFacility")){
			if(sscanf(str+14,"%s",str1)&&strcmp(str1,""))
				UdmSetLogFacility(Conf, str1);
		}else
#endif
		if(!UDM_STRNCASECMP(str,"AuthBasic")){
			UDM_FREE(Conf->csrv->basic_auth);
			UDM_FREE(Conf->csrv->user);
			UDM_FREE(Conf->csrv->passwd);
			if(sscanf(str+9,"%s",str1)){
				Conf->csrv->basic_auth=(char*) UdmXmalloc(BASE64_LEN(strlen(str1)));
				udm_base64_encode(str1,Conf->csrv->basic_auth,strlen(str1));
                                if ((ch=strchr(str1, ':'))){
                            		Conf->csrv->user=(char*)UdmXmalloc((size_t)(ch-str1+1));
                            		udm_snprintf(Conf->csrv->user, (size_t)(ch-str1+1), "%s", str1);
                            		Conf->csrv->passwd=(char*)UdmXmalloc(strlen(ch)+1);
                            		sprintf(Conf->csrv->passwd, "%s", ch+1);
                                }

			}
		}else
		if(!UDM_STRNCASECMP(str,"HTDBList")){
			UDM_FREE(Conf->csrv->htdb_list);
			Conf->csrv->htdb_list=strdup(UdmTrim(str+8," \t\r\n"));
		}else
		if(!UDM_STRNCASECMP(str,"HTDBDoc")){
			UDM_FREE(Conf->csrv->htdb_doc);
			Conf->csrv->htdb_doc=strdup(UdmTrim(str+8," \t\r\n"));
		}else
		if(!UDM_STRNCASECMP(str,"Mime")){
			char *mime_arg[4],*lt,*mtok;
			int argn=0;

			mtok=UdmGetStrToken(str+4,&lt);
			for(;(mtok)&&(argn<4);argn++){
				mime_arg[argn]=mtok;
				mtok=UdmGetStrToken(NULL,&lt);	
			}
			if(argn!=3){
				sprintf(Conf->errstr,"Error in config file '%s' line %d too %s arguments for Mime command\n",conf_name,i,(argn<3?"few":"many"));
				Conf->errcode=1;
				return(Conf);
			}else{
				UdmAddParser(Conf,mime_arg[0],mime_arg[1],mime_arg[2]);
			}
		}else
		if(!UDM_STRNCASECMP(str,"AliasProg")){
			char * aprog,* lt;
			if((aprog=UdmGetStrToken(str+9,&lt)))
				Conf->alias_prog=strdup(aprog);
		}else
		if(!UDM_STRNCASECMP(str,"Alias")){
			if(sscanf(str+5,"%s%s",str1,str2)==2)
				UdmAddAlias(Conf,str1,str2);
			else{
				sprintf(Conf->errstr,"Error in config file '%s' line %d:%s",conf_name,i,str);
				Conf->errcode=1;
				return(Conf);
			}
		}else
		if(!UDM_STRNCASECMP(str,"DefaultLang")){
			if(sscanf(str+11,"%s",str1)&&strcmp(str1,""))
				strncpy(Conf->csrv->lang,str1,2);
		}else
		if(!UDM_STRNCASECMP(str,"StopwordTable")){
			int len;
			char * tables;
			
			tables=UdmTrim(str+13," \r\n\t");
			len=strlen(Conf->stop_tables);
			if((len+strlen(tables)+3)>sizeof(Conf->stop_tables)){
				sprintf(Conf->errstr,"Error in config file '%s' line %d: too many StopwordTable commands",conf_name,i);
				Conf->errcode=1;
				return(Conf);
			}
			sprintf(Conf->stop_tables+len," %s",tables);
		}else
		if(!UDM_STRNCASECMP(str,"ServerTable")){
			int len;
			char * tables;
			
			tables=UdmTrim(str+11," \r\n\t");
			len=strlen(Conf->srv_tables);
			if((len+strlen(tables)+3)>sizeof(Conf->srv_tables)){
				sprintf(Conf->errstr,"Error in config file '%s' line %d: too many ServerTable commands",conf_name,i);
				Conf->errcode=1;
				return(Conf);
			}
			sprintf(Conf->srv_tables+len," %s",tables);
		}else
		if(!UDM_STRNCASECMP(str,"Server")||!UDM_STRNCASECMP(str,"Realm")){
			int match_type, follow;
			char * cmd, * lt;

			if(!UDM_STRNCASECMP(str,"Server")){
				match_type=UDM_SERVER_SUBSTR|UDM_SERVER_MATCH;
			}else{
				match_type=UDM_SERVER_STRING|UDM_SERVER_MATCH;
			}

			/* Store follow value */
			follow=Conf->csrv->follow;
			
			cmd=UdmGetToken(str," \t\r\n",&lt);
			
			while((cmd=UdmGetToken(NULL," \t\r\n",&lt))){
				if(!strcasecmp(cmd,"no"))Conf->csrv->follow=UDM_FOLLOW_NO;
				else
				if(!strcasecmp(cmd,"page"))Conf->csrv->follow=UDM_FOLLOW_NO;
				else
				if(!strcasecmp(cmd,"yes"))Conf->csrv->follow=UDM_FOLLOW_PATH;
				else
				if(!strcasecmp(cmd,"path"))Conf->csrv->follow=UDM_FOLLOW_PATH;
				else
				if(!strcasecmp(cmd,"site"))Conf->csrv->follow=UDM_FOLLOW_SITE;
				else
				if(!strcasecmp(cmd,"world"))Conf->csrv->follow=UDM_FOLLOW_WORLD;
				else
				if(!strcasecmp(cmd,"nocase"))match_type&=~UDM_SERVER_CS;
				else
				if(!strcasecmp(cmd,"case"))match_type|=UDM_SERVER_CS;
				else
				if(!strcasecmp(cmd,"match"))match_type|=UDM_SERVER_MATCH;
				else
				if(!strcasecmp(cmd,"nomatch"))match_type&=~UDM_SERVER_MATCH;
				else
				if(!strcasecmp(cmd,"string"))UDM_SET_SRV_TYPE(match_type,UDM_SERVER_STRING);
				else
				if(!strcasecmp(cmd,"regex"))UDM_SET_SRV_TYPE(match_type,UDM_SERVER_REGEX);
				else{
					if(!Conf->csrv->url)
						Conf->csrv->url=strdup(cmd);
					else
					if(!Conf->csrv->alias)
						Conf->csrv->alias=strdup(cmd);
					else{
						Conf->errcode=1;
						sprintf(Conf->errstr,"'%s' line %d: too many argiments: '%s'",conf_name,i,cmd);
						return(Conf);
					}
				}
			}
			if(UdmAddServer(Conf,Conf->csrv,load_flags,match_type)){
				char * s_err;
				Conf->errcode=1;
				s_err=strdup(Conf->errstr);
				sprintf(Conf->errstr,"'%s' line %d: %s",conf_name,i,s_err);
				free(s_err);
				UDM_FREE(Conf->csrv->url);
				return(Conf);
			}
			UDM_FREE(Conf->csrv->url);
			UDM_FREE(Conf->csrv->alias);
			/* Restore follow value */
			Conf->csrv->follow=follow;
			
		}else
		if(!UDM_STRNCASECMP(str,"Follow")){
			if(sscanf(str+6,"%s",str1)!=1)
				continue;
			Conf->csrv->follow=UdmFollowType(str1);
			if(Conf->csrv->follow==UDM_FOLLOW_UNKNOWN){
				Conf->errcode=1;
				sprintf(Conf->errstr,"'%s' line %d: Unknown follow type: %s",conf_name,i,str1);
				return(Conf);
			}
		}
		else	IF_BOOL_PARAM(str,"Robots",Conf->csrv->use_robots,1)
		else	IF_BOOL_PARAM(str,"DeleteBad",Conf->csrv->deletebad,0)
		else	IF_BOOL_PARAM(str,"DeleteNoServer",Conf->csrv->delete_no_server,1)
		else	IF_BOOL_PARAM(str,"ForceIISCharset1251",Conf->force1251,0)
		else	IF_BOOL_PARAM(str,"UseCRC32UrlId",Conf->use_crc32_url_id,0)
		else	IF_BOOL_PARAM(str,"Clones",Conf->csrv->use_clones,1)
		else	IF_BOOL_PARAM(str,"CheckMp3Tag",Conf->csrv->check_mp3_tag,0)
		else	IF_BOOL_PARAM(str,"IndexMP3TagOnly",Conf->csrv->check_only_mp3_tag,0)
		else	IF_BOOL_PARAM(str,"Index",Conf->csrv->index,1)
		else	IF_BOOL_PARAM(str,"Phrase",Conf->use_phrases,0)
		else	IF_BOOL_PARAM(str,"CrossWords",Conf->use_crossword,0)
		
		else	IF_NUM_PARAM(str,"MaxNetErrors",Conf->csrv->max_net_errors,UDM_MAXNETERRORS)
		else	IF_TIME_PARAM(str,"NetErrorDelayTime",Conf->csrv->net_error_delay_time,UDM_DEFAULT_NET_ERROR_DELAY_TIME)
		else	IF_TIME_PARAM(str,"ReadTimeOut",Conf->csrv->read_timeout,UDM_READ_TIMEOUT)
		else	IF_TIME_PARAM(str,"DocTimeOut",Conf->csrv->doc_timeout,UDM_DOC_TIMEOUT)
		else	IF_TIME_PARAM(str,"Period",Conf->csrv->period,UDM_DEFAULT_REINDEX_TIME)
		else	IF_NUM_PARAM(str,"MaxHops",Conf->csrv->maxhops,0)
		else	IF_NUM_PARAM(str,"CrossWeight",Conf->csrv->crossweight,32)
		else	IF_NUM_PARAM(str,"BodyWeight",Conf->csrv->bodyweight,1)
		else	IF_NUM_PARAM(str,"TitleWeight",Conf->csrv->titleweight,2)
		else	IF_NUM_PARAM(str,"DescWeight",Conf->csrv->descweight,2)
		else	IF_NUM_PARAM(str,"UrlWeight",Conf->csrv->urlweight,0)
		else    IF_NUM_PARAM(str,"UrlHostWeight",Conf->csrv->urlhostweight,0)
		else    IF_NUM_PARAM(str,"UrlPathWeight",Conf->csrv->urlpathweight,0)
		else    IF_NUM_PARAM(str,"UrlFileWeight",Conf->csrv->urlfileweight,0)
		else	IF_NUM_PARAM(str,"IspellCorrectFactor",Conf->csrv->correct_factor,1)
		else	IF_NUM_PARAM(str,"IspellIncorrectFactor",Conf->csrv->incorrect_factor,1)
		else	IF_NUM_PARAM(str,"NumberFactor",Conf->csrv->number_factor,1)
		else	IF_NUM_PARAM(str,"AlnumFactor",Conf->csrv->alnum_factor,1)
		else	IF_NUM_PARAM(str,"MinWordLength",Conf->min_word_len,1)
		else	IF_NUM_PARAM(str,"MaxWordLength",Conf->max_word_len,32)
		else	IF_NUM_PARAM(str,"KeywordWeight",Conf->csrv->keywordweight,2)
		else	IF_NUM_PARAM(str,"MaxDocSize",Conf->max_doc_size,UDM_MAXDOCSIZE)
		else  /* Should be after URLWeight etc */
		if(!UDM_STRNCASECMP(str,"URL")){
			if(load_flags&UDM_FLAG_ADD_SERV){
				if(sscanf(str+3,"%s",str1)&&strcmp(str1,"")){
					char al[UDM_URLSIZE*2];
					UDM_SERVER * Srv;
					Srv=UdmFindServer(Conf,str1,al);
					UdmAddHref(Conf,str1,0,0,0,Srv->tag,Srv->category);
				}
			}
		}else
		if(!UDM_STRNCASECMP(str,"Affix")){
			char lang[20];
			if(load_flags&&UDM_FLAG_SPELL&&(!(Conf->ispell_mode & UDM_ISPELL_MODE_DB))){
				if(2==sscanf(str+5,"%s%s",lang,str1)){
					if(*str1=='/')strcpy(str,str1);
					else	sprintf(str,"%s/%s",UDM_CONF_DIR,str1);
					if(UdmImportAffixes(Conf,lang,str,NULL,0)){
						Conf->errcode=1;
						sprintf(Conf->errstr,"Can't load affix :%s",str);
						return(Conf);
					}
				}
				else {
					Conf->errcode=1;
					sprintf(Conf->errstr,"Error in config file '%s' line %d:%s",conf_name,i,str);
					return(Conf);
				}
			}
		}else
		if(!UDM_STRNCASECMP(str,"Spell")){
			char lang[20];
			if(load_flags&&UDM_FLAG_SPELL&&(!(Conf->ispell_mode & UDM_ISPELL_MODE_DB))){
				if(2==sscanf(str+5,"%s%s",lang,str1)){
					if(*str1=='/')strcpy(str,str1);
					else	sprintf(str,"%s/%s",UDM_CONF_DIR,str1);
					/* -----  0 or 1 ?  */
					if(UdmImportDictionary(Conf,lang,str,0,"")){
						Conf->errcode=1;
						sprintf(Conf->errstr,"Can't load dictionary :%s",str);
						return(Conf);
					}
				}else{
					Conf->errcode=1;
					sprintf(Conf->errstr,"Error in config file '%s' line %d:%s",conf_name,i,str);
					return(Conf);
				}
			}
		}else
		if(!UDM_STRNCASECMP(str,"Include")){
			if((sscanf(str+7,"%s",str1))&&(config_level<5)){
				if(*str1=='/')strcpy(str,str1);
				else	sprintf(str,"%s/%s",UDM_CONF_DIR,str1);
				UdmLoadConfig(Conf,str,config_level+1,load_flags);
				if(Conf->errcode)return(Conf);
			}
		}else
		if(!UDM_STRNCASECMP(str,"MirrorRoot")){
			if((sscanf(str+10,"%s",str1))){
				if(*str1=='/')
					strcpy(str,str1);
				else
					sprintf(str,"%s/%s",UDM_CONF_DIR,str1);
			} else {
				sprintf(str,"%s/mirrors",UDM_CONF_DIR);
			}
			Conf->csrv->mirror_root = strdup(str);
			Conf->csrv->use_mirror=(Conf->csrv->use_mirror>0)?Conf->csrv->use_mirror:0;
		}else
		if(!UDM_STRNCASECMP(str,"MirrorHeadersRoot")){
			if((sscanf(str+17,"%s",str1))){
				if(*str1=='/')
					strcpy(str,str1);
				else
					sprintf(str,"%s/%s",UDM_CONF_DIR,str1);
			} else {
				sprintf(str,"%s/headers",UDM_CONF_DIR);
			}
			Conf->csrv->mirror_headers = strdup(str);
			Conf->csrv->use_mirror=(Conf->csrv->use_mirror>0)?Conf->csrv->use_mirror:0;
		}else
		IF_TIME_PARAM(str,"MirrorPeriod",Conf->csrv->use_mirror,UDM_MIRROR_NO)
		else
		if(!UDM_STRNCASECMP(str,"StopwordFile")){
			if(sscanf(str+12,"%s",str1)){
				if(*str1=='/')strcpy(str,str1);
				else    sprintf(str,"%s/%s",UDM_CONF_DIR,str1);
				if(UdmFileLoadStopList(Conf,str))
					return(Conf);
			} else {
				Conf->errcode=1;
				sprintf(Conf->errstr,"Error in config file '%s' line %d:%s",conf_name,i,str);
				return(Conf);
			}
		}		
		else{
			Conf->errcode=1;
			sprintf(Conf->errstr,"Error in config file '%s' line %d: %s",conf_name,i,str);
			return(Conf);
		}
		str[0]=0;
	}
	fclose(config);
	/* On level0 : Free some variables, prepare others, etc */
	if(config_level==0){

		/* Add one virtual server if we want FollowOutside */
		/* or DeleteNoServer no	*/
		UDM_FREE(Conf->csrv->url);
		if((Conf->csrv->follow==UDM_FOLLOW_WORLD)||(!Conf->csrv->delete_no_server)){
			UdmAddServer(Conf,Conf->csrv,load_flags,UDM_SERVER_SUBSTR|UDM_SERVER_MATCH);
		}

		/* Removed due to new Realm command             */
		/* Servers/Realms now found in appearence order */
		/* UdmSortServers(Conf);                        */

		if (Conf->csrv->regexp) regfree(Conf->csrv->regexp);
		UDM_FREE(Conf->csrv->url);
		UDM_FREE(Conf->csrv->alias);
		UDM_FREE(Conf->csrv->charset);
		UDM_FREE(Conf->csrv->category);
		UDM_FREE(Conf->csrv->tag);
		UDM_FREE(Conf->csrv->proxy);
		UDM_FREE(Conf->csrv->basic_auth);
		UDM_FREE(Conf->csrv->proxy_basic_auth);
		UDM_FREE(Conf->csrv->htdb_list);
		UDM_FREE(Conf->csrv->htdb_doc);
		UDM_FREE(Conf->csrv->user);
		UDM_FREE(Conf->csrv->passwd);
		UDM_FREE(Conf->csrv->mirror_root);
		UDM_FREE(Conf->csrv->mirror_headers);
		UDM_FREE(Conf->csrv);

		/* Sort Aliases for binary search            */
		/* This is incorrect - aliases must          */
		/* be found in the order of their appearance */
		/* UdmSortAliases(Conf); */

		/* Sort ispell dictionay if it has been loaded */
		if (!(Conf->ispell_mode & UDM_ISPELL_MODE_DB)) {
		    if(Conf->nspell) {
		      UdmSortDictionary(Conf);
		      UdmSortAffixes(Conf);
		    }
		} 
	}
	return(0);
}
