#include "udm_config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "udm_utils.h"
#include "udm_xmalloc.h"
#include "udm_id3.h"

#ifdef USE_MP3
char *get_id3_tag(char *buf_in, size_t size){
unsigned short hd,len;
char *ch, *buf_out=NULL;
int tagcount=0;
unsigned char frame_size;
char blank[2]="";
char *artist=NULL, *album=NULL, *songname=NULL;

        /* check id3 header */
        hd = (unsigned short )*buf_in;
        hd &= 0xf0ff;
        if(hd == 0xf0ff){
                return NULL;
        }else if (!strncmp(buf_in, "RIFF", 4)){
                return NULL;
        }else if (!strncmp(buf_in, "ID3", 3)){
		ch = buf_in;
		/* id3 header v2.3.0 http://www.id3.org
			ID3	3
			version	1+1
    			flag	1
			size	4 */
		if ( *(ch+6) == 'b'){
			/* extened header 
				size	4
				flag	2
				size of pagging 4*/
			ch +=20;
		}else
			ch +=10;
		while(1){
			/* frame header
				frame id 4
				size	4
				flags	2 */
			/* fix me: len should be 4 bytes */
			frame_size = (unsigned char)*(ch+7);
			len = frame_size>size?size:frame_size;
			if (!strncmp(ch , "TPE1", 4)){
				ch +=10;
				artist = UdmXmalloc(len);
				udm_snprintf(artist, len, "%s", ch+1);
				UdmRTrim(artist," ");
				if (++tagcount == 3)
					break;
			}else if(!strncmp(ch , "TALB", 4)){
				ch +=10;
				album = UdmXmalloc(len);
				udm_snprintf(album, len, "%s", ch+1);
				UdmRTrim(album," ");
				if (++tagcount == 3)
					break;
			}else if(!strncmp(ch , "TIT2", 4) ){
				ch +=10;
				songname = UdmXmalloc(len);
				udm_snprintf(songname, len, "%s", ch+1);
				UdmRTrim(songname," ");
				if (++tagcount == 3)
					break;
			}else if ((ch - buf_in+frame_size) <size){
				ch +=10;
			}else{
				break;
			}
			ch +=frame_size;
		}
		if (!artist)
			artist=strdup(blank);
		if (!album)
			album=strdup(blank);
		if (!songname)
			songname=strdup(blank);

		buf_out = UdmXmalloc(size+200);
		udm_snprintf(buf_out, size+200,"<title>%s</title><meta name=description content=\"%s\"><meta name=keywords content=\"%s\"><body>%s %s %s</body>",
			songname,artist,album,artist,album,songname);
			

		UDM_FREE(artist);
		UDM_FREE(album);
		UDM_FREE(songname);

		return buf_out;
        }else if (!strncmp(buf_in, "TAG", 3)){
		char year[5]="";
		/* Artist */
		artist = UdmXmalloc(31);
		udm_snprintf(artist, 31, "%s", buf_in+33);
		UdmRTrim(artist, " ");
		/* Album */
		album = UdmXmalloc(31);
		udm_snprintf(album, 31, "%s", buf_in+63);
		UdmRTrim(album, " ");
		/* Songname */
		songname = UdmXmalloc(31);
		udm_snprintf(songname, 31, "%s", buf_in+3);
		UdmRTrim(songname, " ");
		/*Year*/
                udm_snprintf(year, 5, "%s", buf_in+93);
                UdmRTrim(songname, " ");
		if (!artist)
			artist=strdup(blank);
		if (!album)
			album=strdup(blank);
		if (!songname)
			songname=strdup(blank);

		buf_out = UdmXmalloc(size+200);
		udm_snprintf(buf_out, size+200,"<title>%s</title><meta name=description content=\"%s\"><meta name=keywords content=\"%s %s\"><body>%s %s %s %s</body>",
			songname,artist,album,year,artist,album,year,songname);
		
		UDM_FREE(artist);
		UDM_FREE(album);
		UDM_FREE(songname);
		
                return buf_out;
        }else 
		return (char*)-1;
}
#endif
